/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.cache.http.Utils;
import com.apollographql.apollo3.cache.http.internal.StatusLine;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.internal.http.HttpMethod;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0002\u001a\u00020#H\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020)R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseHeaderRecord;", "", "source", "Lokio/Source;", "(Lokio/Source;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "code", "", "handshake", "Lokhttp3/Handshake;", "isHttps", "", "()Z", "message", "", "protocol", "Lokhttp3/Protocol;", "receivedResponseMillis", "", "requestMethod", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "url", "varyHeaders", "addHeaderLenient", "", "headersBuilder", "Lokhttp3/Headers$Builder;", "line", "readCertificateList", "", "Ljava/security/cert/Certificate;", "Lokio/BufferedSource;", "writeCertList", "sink", "Lokio/BufferedSink;", "certificates", "writeTo", "Lokio/Sink;", "Companion", "apollo-http-cache"})
public final class ResponseHeaderRecord {
    private final String url;
    private final Headers varyHeaders;
    private final String requestMethod;
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Headers responseHeaders;
    private final Handshake handshake;
    private final long sentRequestMillis;
    private final long receivedResponseMillis;
    private static final String SENT_MILLIS = "OkHttp-Sent-Millis";
    private static final String RECEIVED_MILLIS = "OkHttp-Received-Millis";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void writeTo(@NotNull Sink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        bufferedSink.writeUtf8(this.url).writeByte(10);
        bufferedSink.writeUtf8(this.requestMethod).writeByte(10);
        Headers headers = this.varyHeaders;
        Intrinsics.checkNotNull((Object)headers);
        bufferedSink.writeDecimalLong((long)headers.size()).writeByte(10);
        ResponseHeaderRecord responseHeaderRecord = this;
        boolean bl = false;
        boolean bl2 = false;
        ResponseHeaderRecord $this$run = responseHeaderRecord;
        boolean bl3 = false;
        Headers headers2 = $this$run.varyHeaders;
        Intrinsics.checkNotNull((Object)headers2);
        int size = headers2.size();
        for (int i = 0; i < size; ++i) {
            String string = $this$run.varyHeaders.name(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"varyHeaders.name(i)");
            BufferedSink bufferedSink2 = bufferedSink.writeUtf8(string).writeUtf8(": ");
            String string2 = $this$run.varyHeaders.value(i);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"varyHeaders.value(i)");
            bufferedSink2.writeUtf8(string2).writeByte(10);
        }
        bufferedSink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
        bufferedSink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
        int size2 = this.responseHeaders.size();
        for (int i = 0; i < size2; ++i) {
            String string = this.responseHeaders.name(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.name(i)");
            BufferedSink bufferedSink3 = bufferedSink.writeUtf8(string).writeUtf8(": ");
            String string3 = this.responseHeaders.value(i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"responseHeaders.value(i)");
            bufferedSink3.writeUtf8(string3).writeByte(10);
        }
        bufferedSink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
        bufferedSink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
        if (this.isHttps()) {
            bufferedSink.writeByte(10);
            Handshake handshake = this.handshake;
            Intrinsics.checkNotNull((Object)handshake);
            String string = handshake.cipherSuite().javaName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handshake!!.cipherSuite().javaName()");
            bufferedSink.writeUtf8(string).writeByte(10);
            List list = this.handshake.peerCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"handshake.peerCertificates()");
            this.writeCertList(bufferedSink, list);
            List list2 = this.handshake.localCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"handshake.localCertificates()");
            this.writeCertList(bufferedSink, list2);
            if (this.handshake.tlsVersion() != null) {
                String string4 = this.handshake.tlsVersion().javaName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"handshake.tlsVersion().javaName()");
                bufferedSink.writeUtf8(string4).writeByte(10);
            }
        }
        bufferedSink.close();
    }

    private final boolean isHttps() {
        return StringsKt.startsWith$default((String)this.url, (String)"https://", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Certificate> readCertificateList(BufferedSource source) throws IOException {
        List list;
        int length = ResponseHeaderRecord.Companion.readInt(source);
        if (length == -1) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                List result = new ArrayList(length);
                int n = 0;
                int n2 = length;
                while (n < n2) {
                    void i;
                    String line = source.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) != null) {
                        ByteString byteString;
                        boolean bl = false;
                        boolean bl2 = false;
                        ByteString it = byteString;
                        boolean bl3 = false;
                        bytes.write(it);
                    }
                    Certificate certificate = certificateFactory.generateCertificate(bytes.inputStream());
                    Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"certificateFactory.gener\u2026cate(bytes.inputStream())");
                    result.add(certificate);
                    ++i;
                }
                list2 = result;
            }
            catch (CertificateException e) {
                throw (Throwable)new IOException(e.getMessage());
            }
            list = list2;
        }
        return list;
    }

    private final void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
        try {
            sink.writeDecimalLong((long)certificates.size()).writeByte(10);
            int size = certificates.size();
            for (int i = 0; i < size; ++i) {
                byte[] bytes = certificates.get(i).getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null).base64();
                sink.writeUtf8(line).writeByte(10);
            }
        }
        catch (CertificateEncodingException e) {
            throw (Throwable)new IOException(e.getMessage());
        }
    }

    @NotNull
    public final Response response() {
        RequestBody body = null;
        if (HttpMethod.permitsRequestBody((String)this.requestMethod)) {
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        }
        Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, body).headers(this.varyHeaders).build();
        Response response = new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"Response.Builder()\n     \u2026eMillis)\n        .build()");
        return response;
    }

    private final void addHeaderLenient(Headers.Builder headersBuilder, String line) {
        int index = StringsKt.indexOf$default((CharSequence)line, (String)":", (int)1, (boolean)false, (int)4, null);
        if (index != -1) {
            String string = line;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = line;
            n = index + 1;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            headersBuilder.add(string3, string5);
        } else if (StringsKt.startsWith$default((String)line, (String)":", (boolean)false, (int)2, null)) {
            String string = line;
            int n = 1;
            boolean bl = false;
            String string6 = string;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            headersBuilder.add("", string7);
        } else {
            headersBuilder.add("", line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ResponseHeaderRecord(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Closeable closeable = (Closeable)source;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Handshake handshake;
            Source it = (Source)closeable;
            boolean bl3 = false;
            BufferedSource buffer = Okio.buffer((Source)it);
            this.url = buffer.readUtf8LineStrict();
            this.requestMethod = buffer.readUtf8LineStrict();
            Headers.Builder varyHeadersBuilder = new Headers.Builder();
            int varyRequestHeaderLineCount = ResponseHeaderRecord.Companion.readInt(buffer);
            int n = 0;
            int n2 = varyRequestHeaderLineCount;
            while (n < n2) {
                void i;
                this.addHeaderLenient(varyHeadersBuilder, buffer.readUtf8LineStrict());
                ++i;
            }
            this.varyHeaders = varyHeadersBuilder.build();
            StatusLine statusLine = StatusLine.Companion.parse(buffer.readUtf8LineStrict());
            this.protocol = statusLine.getProtocol();
            this.code = statusLine.getCode();
            this.message = statusLine.getMessage();
            Headers.Builder responseHeadersBuilder = new Headers.Builder();
            int responseHeaderLineCount = ResponseHeaderRecord.Companion.readInt(buffer);
            int n3 = 0;
            int n4 = responseHeaderLineCount;
            while (n3 < n4) {
                void i;
                this.addHeaderLenient(responseHeadersBuilder, buffer.readUtf8LineStrict());
                ++i;
            }
            String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
            String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
            responseHeadersBuilder.removeAll(SENT_MILLIS);
            responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
            String string = sendRequestMillisString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sendRequestMillisString");
            String string2 = string;
            boolean bl4 = false;
            this.sentRequestMillis = Long.parseLong(string2);
            String string3 = receivedResponseMillisString;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"receivedResponseMillisString");
            string2 = string3;
            bl4 = false;
            this.receivedResponseMillis = Long.parseLong(string2);
            Headers headers = responseHeadersBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"responseHeadersBuilder.build()");
            this.responseHeaders = headers;
            if (this.isHttps()) {
                String blank = buffer.readUtf8LineStrict();
                CharSequence charSequence = blank;
                boolean bl5 = false;
                if (charSequence.length() > 0) {
                    throw (Throwable)new IOException("expected \"\" but was \"" + blank + '\"');
                }
                String cipherSuiteString = buffer.readUtf8LineStrict();
                CipherSuite cipherSuite = CipherSuite.forJavaName((String)cipherSuiteString);
                List<Certificate> peerCertificates = this.readCertificateList(buffer);
                List<Certificate> localCertificates = this.readCertificateList(buffer);
                TlsVersion tlsVersion = !buffer.exhausted() ? TlsVersion.forJavaName((String)buffer.readUtf8LineStrict()) : null;
                handshake = Handshake.get((TlsVersion)tlsVersion, (CipherSuite)cipherSuite, peerCertificates, localCertificates);
            } else {
                handshake = null;
            }
            this.handshake = handshake;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public ResponseHeaderRecord(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = response.request().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.request().url().toString()");
        this.url = string;
        this.varyHeaders = Utils.INSTANCE.varyHeaders(response);
        String string2 = response.request().method();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.request().method()");
        this.requestMethod = string2;
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        Headers headers = response.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"response.headers()");
        this.responseHeaders = headers;
        this.handshake = response.handshake();
        this.sentRequestMillis = response.sentRequestAtMillis();
        this.receivedResponseMillis = response.receivedResponseAtMillis();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseHeaderRecord$Companion;", "", "()V", "RECEIVED_MILLIS", "", "SENT_MILLIS", "readInt", "", "source", "Lokio/BufferedSource;", "apollo-http-cache"})
    public static final class Companion {
        private final int readInt(BufferedSource source) throws IOException {
            int n;
            try {
                long result;
                block5: {
                    String line;
                    block4: {
                        result = source.readDecimalLong();
                        line = source.readUtf8LineStrict();
                        if (result < 0L || result > (long)Integer.MAX_VALUE) break block4;
                        CharSequence charSequence = line;
                        boolean bl = false;
                        if (!(charSequence.length() > 0)) break block5;
                    }
                    throw (Throwable)new IOException("expected an int but was \"" + result + line + '\"');
                }
                n = (int)result;
            }
            catch (NumberFormatException e) {
                throw (Throwable)new IOException(e.getMessage());
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

