/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http.internal;

import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.apollographql.apollo3.cache.http.internal.FaultHidingSink;
import com.apollographql.apollo3.cache.http.internal.FileSystem;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\u0007\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0004`abcB7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020>H\u0016J\u001a\u0010@\u001a\u00020>2\b\u0010A\u001a\u0004\u0018\u00010\u00012\b\u0010B\u001a\u0004\u0018\u00010+J\u001a\u0010C\u001a\u00020>2\n\u0010D\u001a\u00060ER\u00020\u00002\u0006\u0010F\u001a\u00020\u0016J\u0006\u0010G\u001a\u00020>J\u0014\u0010H\u001a\b\u0018\u00010ER\u00020\u00002\u0006\u0010I\u001a\u00020+J\u001c\u0010H\u001a\b\u0018\u00010ER\u00020\u00002\u0006\u0010I\u001a\u00020+2\u0006\u0010J\u001a\u00020\u000bJ\u0006\u0010K\u001a\u00020>J\b\u0010L\u001a\u00020>H\u0016J\u0017\u0010M\u001a\b\u0018\u00010NR\u00020\u00002\u0006\u0010I\u001a\u00020+H\u0086\u0002J\u0006\u0010O\u001a\u00020\u000bJ\u0006\u0010P\u001a\u00020>J\u0006\u0010Q\u001a\u00020\u0016J\b\u0010R\u001a\u00020$H\u0002J\b\u0010S\u001a\u00020>H\u0002J\b\u0010T\u001a\u00020>H\u0002J\u0010\u0010U\u001a\u00020>2\u0006\u0010V\u001a\u00020+H\u0002J\u0006\u0010W\u001a\u00020>J\u000e\u0010X\u001a\u00020\u00162\u0006\u0010I\u001a\u00020+J\u0014\u0010Y\u001a\u00020\u00162\f\u0010Z\u001a\b\u0018\u00010,R\u00020\u0000J\u000e\u0010[\u001a\u00020>2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010;\u001a\u00020\u000bJ\u0010\u0010\\\u001a\f\u0012\b\u0012\u00060NR\u00020\u00000]J\u0006\u0010^\u001a\u00020>J\u0010\u0010_\u001a\u00020>2\u0006\u0010I\u001a\u00020+H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001c\u0010\u001e\u001a\u00020\u00168FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u000e\u0010 \u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R#\u0010)\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0018\u00010,R\u00020\u00000*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0018\"\u0004\b1\u0010\u001aR\u001a\u00102\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0018\"\u0004\b4\u0010\u001aR\u000e\u00105\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00108\u00a8\u0006d"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/apollographql/apollo3/cache/http/internal/FileSystem;Ljava/io/File;IIJLjava/util/concurrent/Executor;)V", "cleanupRunnable", "Ljava/lang/Runnable;", "getDirectory", "()Ljava/io/File;", "getFileSystem", "()Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "hasJournalErrors", "", "getHasJournalErrors", "()Z", "setHasJournalErrors", "(Z)V", "initialized", "getInitialized", "setInitialized", "isClosed", "setClosed", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "getJournalWriter", "()Lokio/BufferedSink;", "setJournalWriter", "(Lokio/BufferedSink;)V", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "getLruEntries", "()Ljava/util/LinkedHashMap;", "mostRecentRebuildFailed", "getMostRecentRebuildFailed", "setMostRecentRebuildFailed", "mostRecentTrimFailed", "getMostRecentTrimFailed", "setMostRecentTrimFailed", "nextSequenceNumber", "redundantOpCount", "getRedundantOpCount", "()I", "setRedundantOpCount", "(I)V", "size", "getValueCount", "checkNotClosed", "", "close", "closeQuietly", "closeable", "name", "completeEdit", "editor", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "success", "delete", "edit", "key", "expectedSequenceNumber", "evictAll", "flush", "get", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "getMaxSize", "initialize", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "remove", "removeEntry", "entry", "setMaxSize", "snapshots", "", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "apollo-http-cache"})
public final class DiskLruCache
implements Closeable,
Flushable {
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private long maxSize;
    private final int valueCount;
    private long size;
    @Nullable
    private BufferedSink journalWriter;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean isClosed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final Executor executor;
    private final Runnable cleanupRunnable;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final int appVersion;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION_1 = "1";
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final Pattern LEGAL_KEY_PATTERN;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    @NotNull
    public static final Companion Companion;

    public final int getValueCount() {
        return this.valueCount;
    }

    @Nullable
    public final BufferedSink getJournalWriter() {
        return this.journalWriter;
    }

    public final void setJournalWriter(@Nullable BufferedSink bufferedSink) {
        this.journalWriter = bufferedSink;
    }

    @NotNull
    public final LinkedHashMap<String, Entry> getLruEntries() {
        return this.lruEntries;
    }

    public final int getRedundantOpCount() {
        return this.redundantOpCount;
    }

    public final void setRedundantOpCount(int n) {
        this.redundantOpCount = n;
    }

    public final boolean getHasJournalErrors() {
        return this.hasJournalErrors;
    }

    public final void setHasJournalErrors(boolean bl) {
        this.hasJournalErrors = bl;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public final synchronized boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final boolean getMostRecentTrimFailed() {
        return this.mostRecentTrimFailed;
    }

    public final void setMostRecentTrimFailed(boolean bl) {
        this.mostRecentTrimFailed = bl;
    }

    public final boolean getMostRecentRebuildFailed() {
        return this.mostRecentRebuildFailed;
    }

    public final void setMostRecentRebuildFailed(boolean bl) {
        this.mostRecentRebuildFailed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize() throws IOException {
        boolean bl = Thread.holdsLock(this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                try {
                    this.delete();
                }
                finally {
                    this.isClosed = false;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() throws IOException {
        Closeable closeable = (Closeable)Okio.buffer((Source)this.fileSystem.source(this.journalFile));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedSource source = (BufferedSource)closeable;
            boolean bl3 = false;
            String magic = source.readUtf8LineStrict();
            String version = source.readUtf8LineStrict();
            String appVersionString = source.readUtf8LineStrict();
            String valueCountString = source.readUtf8LineStrict();
            String blank = source.readUtf8LineStrict();
            if (Intrinsics.areEqual((Object)MAGIC, (Object)magic) ^ true) throw (Throwable)new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (Intrinsics.areEqual((Object)VERSION_1, (Object)version) ^ true) throw (Throwable)new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (Intrinsics.areEqual((Object)Integer.toString(this.appVersion), (Object)appVersionString) ^ true) throw (Throwable)new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (Intrinsics.areEqual((Object)Integer.toString(this.valueCount), (Object)valueCountString) ^ true) throw (Throwable)new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            if (Intrinsics.areEqual((Object)"", (Object)blank) ^ true) {
                throw (Throwable)new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(source.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException endOfJournal) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                if (!source.exhausted()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                Unit unit = Unit.INSTANCE;
                return;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        Sink faultHidingSink2 = (Sink)new FaultHidingSink(this, fileSink, fileSink){
            final /* synthetic */ DiskLruCache this$0;
            final /* synthetic */ Sink $fileSink;

            protected void onException(@Nullable IOException e) {
                boolean bl = Thread.holdsLock(this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.this$0.setHasJournalErrors(true);
            }
            {
                this.this$0 = this$0;
                this.$fileSink = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        return Okio.buffer((Sink)faultHidingSink2);
    }

    private final void readJournalLine(String line) throws IOException {
        Entry entry;
        boolean bl;
        String string;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw (Throwable)new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            string = line;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            key = string3;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            string = line;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            key = string5;
        }
        if ((entry = this.lruEntries.get(key)) == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string6 = line;
            int n = secondSpace + 1;
            boolean bl2 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string8, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] parts = stringArray;
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw (Throwable)new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            Entry entry;
            Entry entry2 = entry = i.next();
            Intrinsics.checkNotNull((Object)entry2);
            if (entry2.getCurrentEditor() == null) {
                int n2 = 0;
                n = this.valueCount;
                while (n2 < n) {
                    this.size += entry.getLengths()[t];
                    ++t;
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n = this.valueCount;
            for (t = 0; t < n; ++t) {
                this.fileSystem.delete(entry.getCleanFiles()[t]);
                this.fileSystem.delete(entry.getDirtyFiles()[t]);
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
        }
        Closeable closeable = (Closeable)Okio.buffer((Sink)this.fileSystem.sink(this.journalFileTmp));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedSink writer = (BufferedSink)closeable;
            boolean bl3 = false;
            writer.writeUtf8(MAGIC).writeByte(10);
            writer.writeUtf8(VERSION_1).writeByte(10);
            writer.writeDecimalLong((long)this.appVersion).writeByte(10);
            writer.writeDecimalLong((long)this.valueCount).writeByte(10);
            writer.writeByte(10);
            Iterator<Entry> iterator = this.lruEntries.values().iterator();
            while (iterator.hasNext()) {
                Entry entry;
                Entry entry2 = entry = iterator.next();
                Intrinsics.checkNotNull((Object)entry2);
                if (entry2.getCurrentEditor() != null) {
                    writer.writeUtf8(DIRTY).writeByte(32);
                    writer.writeUtf8(entry.getKey());
                    writer.writeByte(10);
                    continue;
                }
                writer.writeUtf8(CLEAN).writeByte(32);
                writer.writeUtf8(entry.getKey());
                entry.writeLengths(writer);
                writer.writeByte(10);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    @Nullable
    public final synchronized Snapshot get(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null || !entry.getReadable()) {
            return null;
        }
        Snapshot snapshot = entry.snapshot();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8(key).writeByte(10);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return snapshot2;
    }

    @Nullable
    public final Editor edit(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.edit(key, -1L);
    }

    @Nullable
    public final synchronized Editor edit(@NotNull String key, long expectedSequenceNumber) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != -1L && (entry == null || entry.getSequenceNumber() != expectedSequenceNumber)) {
            return null;
        }
        if (entry != null && entry.getCurrentEditor() != null) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.executor.execute(this.cleanupRunnable);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink2);
        bufferedSink2.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(entry);
        entry.setCurrentEditor(editor);
        return editor;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.size;
    }

    public final synchronized void completeEdit(@NotNull Editor editor, boolean success) throws IOException {
        int i;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Entry entry = editor.getEntry();
        int n = Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor);
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (success && !entry.getReadable()) {
            n = 0;
            n2 = this.valueCount;
            while (n < n2) {
                boolean[] blArray = editor.getWritten();
                Intrinsics.checkNotNull((Object)blArray);
                if (!blArray[i]) {
                    editor.abort();
                    throw (Throwable)new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (!this.fileSystem.exists(entry.getDirtyFiles()[i])) {
                    editor.abort();
                    return;
                }
                ++i;
            }
        }
        n2 = this.valueCount;
        for (i = 0; i < n2; ++i) {
            File dirty = entry.getDirtyFiles()[i];
            if (success) {
                long newLength;
                if (!this.fileSystem.exists(dirty)) continue;
                File clean = entry.getCleanFiles()[i];
                this.fileSystem.rename(dirty, clean);
                long oldLength = entry.getLengths()[i];
                entry.getLengths()[i] = newLength = this.fileSystem.size(clean);
                this.size = this.size - oldLength + newLength;
                continue;
            }
            this.fileSystem.delete(dirty);
        }
        n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        entry.setCurrentEditor(null);
        if (entry.getReadable() || success) {
            entry.setReadable(true);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.writeUtf8(CLEAN).writeByte(32);
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            bufferedSink2.writeUtf8(entry.getKey());
            entry.writeLengths(this.journalWriter);
            BufferedSink bufferedSink3 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink3);
            bufferedSink3.writeByte(10);
            if (success) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                entry.setSequenceNumber(l);
            }
        } else {
            this.lruEntries.remove(entry.getKey());
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.writeUtf8(REMOVE).writeByte(32);
            BufferedSink bufferedSink4 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink4);
            bufferedSink4.writeUtf8(entry.getKey());
            BufferedSink bufferedSink5 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink5);
            bufferedSink5.writeByte(10);
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= redundantOpCompactThreshold && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"lruEntries[key] ?: return false");
        Entry entry2 = entry;
        boolean removed = this.removeEntry(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeEntry(@Nullable Entry entry) throws IOException {
        Entry entry2 = entry;
        Intrinsics.checkNotNull((Object)entry2);
        if (entry2.getCurrentEditor() != null) {
            Editor editor = entry.getCurrentEditor();
            Intrinsics.checkNotNull((Object)editor);
            editor.detach();
        }
        int n = 0;
        int n2 = this.valueCount;
        while (n < n2) {
            void i;
            this.fileSystem.delete(entry.getCleanFiles()[i]);
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
            ++i;
        }
        n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.getKey()).writeByte(10);
        this.lruEntries.remove(entry.getKey());
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        boolean bl = !this.isClosed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cache is closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.initialized || this.isClosed) {
            this.isClosed = true;
            return;
        }
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lruEntries.values");
        Collection<Entry> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Entry[] entryArray2 = entryArray;
        int n = entryArray2.length;
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry entry2 = entry = entryArray2[i];
            if ((entry2 != null ? entry2.getCurrentEditor() : null) == null) continue;
            Editor editor = entry.getCurrentEditor();
            Intrinsics.checkNotNull((Object)editor);
            editor.abort();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.isClosed = true;
    }

    public final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            Entry toEvict = this.lruEntries.values().iterator().next();
            this.removeEntry(toEvict);
        }
        this.mostRecentTrimFailed = false;
    }

    public final void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lruEntries.values");
        Collection<Entry> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (Entry entry : entryArray) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final void validateKey(String key) {
        Matcher matcher = LEGAL_KEY_PATTERN.matcher(key);
        boolean bl = matcher.matches();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(this){
            @NotNull
            private final Iterator<Entry> delegate;
            @Nullable
            private Snapshot nextSnapshot;
            @Nullable
            private Snapshot removeSnapshot;
            final /* synthetic */ DiskLruCache this$0;

            @NotNull
            public final Iterator<Entry> getDelegate() {
                return this.delegate;
            }

            @Nullable
            public final Snapshot getNextSnapshot() {
                return this.nextSnapshot;
            }

            public final void setNextSnapshot(@Nullable Snapshot snapshot) {
                this.nextSnapshot = snapshot;
            }

            @Nullable
            public final Snapshot getRemoveSnapshot() {
                return this.removeSnapshot;
            }

            public final void setRemoveSnapshot(@Nullable Snapshot snapshot) {
                this.removeSnapshot = snapshot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                DiskLruCache diskLruCache = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (diskLruCache) {
                    block8: {
                        boolean bl3 = false;
                        if (!this.this$0.isClosed()) break block8;
                        boolean bl4 = false;
                        return bl4;
                    }
                    while (this.delegate.hasNext()) {
                        Snapshot snapshot;
                        Entry entry;
                        Entry entry2 = entry = this.delegate.next();
                        Intrinsics.checkNotNull((Object)entry2);
                        Snapshot snapshot2 = entry2.snapshot();
                        if (snapshot2 == null) {
                            continue;
                        }
                        this.nextSnapshot = snapshot = snapshot2;
                        boolean bl5 = true;
                        return bl5;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                return false;
            }

            @NotNull
            public Snapshot next() {
                if (!this.hasNext()) {
                    throw (Throwable)new NoSuchElementException();
                }
                this.removeSnapshot = this.nextSnapshot;
                this.nextSnapshot = null;
                Snapshot snapshot = this.removeSnapshot;
                Intrinsics.checkNotNull((Object)snapshot);
                return snapshot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Snapshot snapshot = this.removeSnapshot;
                boolean bl = false;
                boolean bl2 = false;
                if (snapshot == null) {
                    boolean bl3 = false;
                    String string = "remove() before next()";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                try {
                    Snapshot snapshot2 = this.removeSnapshot;
                    Intrinsics.checkNotNull((Object)snapshot2);
                    this.this$0.remove(snapshot2.getKey());
                }
                catch (IOException iOException) {
                }
                finally {
                    this.removeSnapshot = null;
                }
            }
            {
                this.this$0 = this$0;
                Iterator<Entry> iterator = new ArrayList<Entry>(this$0.getLruEntries().values()).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"ArrayList(lruEntries.values).iterator()");
                this.delegate = iterator;
            }
        };
    }

    public final void closeQuietly(@Nullable Closeable closeable, @Nullable String name) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final File getDirectory() {
        return this.directory;
    }

    public DiskLruCache(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.appVersion = appVersion;
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupRunnable = new Runnable(this){
            final /* synthetic */ DiskLruCache this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DiskLruCache diskLruCache = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (diskLruCache) {
                    boolean bl3 = false;
                    if (!this.this$0.getInitialized() || this.this$0.isClosed()) {
                        return;
                    }
                    try {
                        this.this$0.trimToSize();
                    }
                    catch (IOException ignored) {
                        this.this$0.setMostRecentTrimFailed(true);
                    }
                    try {
                        if (this.this$0.journalRebuildRequired()) {
                            this.this$0.rebuildJournal();
                            this.this$0.setRedundantOpCount(0);
                        }
                    }
                    catch (IOException e) {
                        this.this$0.setMostRecentRebuildFailed(true);
                        this.this$0.setJournalWriter(Okio.buffer((Sink)Okio.blackhole()));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.journalFile = new File(this.directory, JOURNAL_FILE);
        this.journalFileTmp = new File(this.directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(this.directory, JOURNAL_FILE_BACKUP);
        this.valueCount = valueCount;
        this.maxSize = maxSize;
        this.executor = executor2;
    }

    static {
        Companion = new Companion(null);
        LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    }

    @JvmStatic
    @NotNull
    public static final DiskLruCache create(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize) {
        return Companion.create(fileSystem, directory, appVersion, valueCount, maxSize);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "key", "", "sequenceNumber", "", "sources", "", "Lokio/Source;", "lengths", "", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Ljava/lang/String;J[Lokio/Source;[J)V", "getKey", "()Ljava/lang/String;", "[Lokio/Source;", "close", "", "edit", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "getLength", "index", "", "getSource", "apollo-http-cache"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final String key;
        private final long sequenceNumber;
        private final Source[] sources;
        private final long[] lengths;

        @NotNull
        public final String key() {
            return this.key;
        }

        @Nullable
        public final Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        @NotNull
        public final Source getSource(int index) {
            return this.sources[index];
        }

        public final long getLength(int index) {
            return this.lengths[index];
        }

        @Override
        public void close() {
            for (Source in : this.sources) {
                DiskLruCache.this.closeQuietly((Closeable)in, "source");
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public Snapshot(String key, @NotNull long sequenceNumber, @NotNull Source[] sources, long[] lengths) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            this.key = key;
            this.sequenceNumber = sequenceNumber;
            this.sources = sources;
            this.lengths = lengths;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "", "entry", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;)V", "done", "", "getEntry", "()Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "written", "", "getWritten", "()[Z", "abort", "", "abortUnlessCommitted", "commit", "detach", "newSink", "Lokio/Sink;", "index", "", "newSource", "Lokio/Source;", "apollo-http-cache"})
    public final class Editor {
        @Nullable
        private final boolean[] written;
        private boolean done;
        @NotNull
        private final Entry entry;

        @Nullable
        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - void declaration
         */
        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                int n = 0;
                int n2 = DiskLruCache.this.getValueCount();
                while (n < n2) {
                    void i;
                    try {
                        DiskLruCache.this.getFileSystem().delete(this.entry.getDirtyFiles()[i]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.entry.setCurrentEditor(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Source newSource(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                Source source;
                boolean bl3 = false;
                boolean bl4 = !this.done;
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl7 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (!this.entry.getReadable() || Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this) ^ true) {
                    source = null;
                } else {
                    Source source2;
                    try {
                        source2 = DiskLruCache.this.getFileSystem().source(this.entry.getCleanFiles()[index]);
                    }
                    catch (FileNotFoundException e) {
                        source2 = null;
                    }
                    source = source2;
                }
                Source source3 = source;
                return source3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Sink newSink(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                Sink sink;
                block9: {
                    boolean bl3 = false;
                    boolean bl4 = !this.done;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    bl6 = false;
                    boolean bl7 = false;
                    if (!bl4) {
                        boolean bl8 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    if (!(Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this) ^ true)) break block9;
                    Sink sink2 = Okio.blackhole();
                    return sink2;
                }
                if (!this.entry.getReadable()) {
                    Intrinsics.checkNotNull((Object)this.written);
                    this.written[index] = true;
                }
                File dirtyFile = this.entry.getDirtyFiles()[index];
                Sink sink3 = null;
                try {
                    sink = DiskLruCache.this.getFileSystem().sink(dirtyFile);
                }
                catch (FileNotFoundException e) {
                    Sink sink4 = Okio.blackhole();
                    return sink4;
                }
                sink3 = sink;
                Sink sink5 = (Sink)new FaultHidingSink(sink3, sink3, this, index){
                    final /* synthetic */ Sink $sink;
                    final /* synthetic */ Editor this$0;
                    final /* synthetic */ int $index$inlined;
                    {
                        this.$sink = $captured_local_variable$1;
                        this.this$0 = editor;
                        this.$index$inlined = n;
                        super($super_call_param$2);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onException(@Nullable IOException e) {
                        DiskLruCache diskLruCache = this.this$0.DiskLruCache.this;
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (diskLruCache) {
                            boolean bl3 = false;
                            this.this$0.detach();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                };
                return sink5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                boolean bl4 = !this.done;
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl7 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    DiskLruCache.this.completeEdit(this, true);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                boolean bl4 = !this.done;
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl7 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    DiskLruCache.this.completeEdit(this, false);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abortUnlessCommitted() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                if (!this.done && Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    try {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    catch (IOException iOException) {
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.written = this.entry.getReadable() ? null : new boolean[DiskLruCache.this.getValueCount()];
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020+2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u0010\u0010/\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u000101R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Entry;", "", "key", "", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "", "Ljava/io/File;", "getCleanFiles", "()[Ljava/io/File;", "[Ljava/io/File;", "currentEditor", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "getCurrentEditor", "()Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "setCurrentEditor", "(Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "sequenceNumber", "", "getSequenceNumber", "()J", "setSequenceNumber", "(J)V", "invalidLengths", "Ljava/io/IOException;", "strings", "([Ljava/lang/String;)Ljava/io/IOException;", "setLengths", "", "([Ljava/lang/String;)V", "snapshot", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "apollo-http-cache"})
    public final class Entry {
        @NotNull
        private final long[] lengths;
        @NotNull
        private final File[] cleanFiles;
        @NotNull
        private final File[] dirtyFiles;
        private boolean readable;
        @Nullable
        private Editor currentEditor;
        private long sequenceNumber;
        @NotNull
        private final String key;

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final File[] getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final File[] getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(long l) {
            this.sequenceNumber = l;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths(@NotNull String[] strings) throws IOException {
            Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
            if (strings.length != DiskLruCache.this.getValueCount()) {
                throw (Throwable)this.invalidLengths(strings);
            }
            try {
                int n = 0;
                int n2 = strings.length;
                while (n < n2) {
                    void i;
                    String string = strings[i];
                    boolean bl = false;
                    this.lengths[i] = Long.parseLong(string);
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw (Throwable)this.invalidLengths(strings);
            }
        }

        public final void writeLengths(@Nullable BufferedSink writer) throws IOException {
            for (long length : this.lengths) {
                BufferedSink bufferedSink = writer;
                Intrinsics.checkNotNull((Object)bufferedSink);
                bufferedSink.writeByte(32).writeDecimalLong(length);
            }
        }

        private final IOException invalidLengths(String[] strings) throws IOException {
            throw (Throwable)new IOException("unexpected journal line: " + Arrays.toString(strings));
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            Snapshot snapshot;
            if (!Thread.holdsLock(DiskLruCache.this)) {
                throw (Throwable)((Object)new AssertionError());
            }
            Source[] sources = new Source[DiskLruCache.this.getValueCount()];
            long[] lengths = (long[])this.lengths.clone();
            try {
                int n = 0;
                int n2 = DiskLruCache.this.getValueCount();
                while (n < n2) {
                    void i;
                    sources[i] = DiskLruCache.this.getFileSystem().source(this.cleanFiles[i]);
                    ++i;
                }
                snapshot = new Snapshot(this.key, this.sequenceNumber, sources, lengths);
            }
            catch (FileNotFoundException e) {
                for (int i = 0; i < DiskLruCache.this.getValueCount() && sources[i] != null; ++i) {
                    DiskLruCache.this.closeQuietly((Closeable)sources[i], "file");
                }
                try {
                    DiskLruCache.this.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                snapshot = null;
            }
            return snapshot;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        /*
         * WARNING - void declaration
         */
        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount()];
            boolean bl = false;
            List tmpCleanFiles = new ArrayList();
            boolean bl2 = false;
            List tmpDirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = 0;
            int n2 = DiskLruCache.this.getValueCount();
            while (n < n2) {
                void i;
                fileBuilder.append((int)i);
                tmpCleanFiles.add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.append(".tmp");
                tmpDirtyFiles.add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
                ++i;
            }
            Collection $this$toTypedArray$iv = tmpCleanFiles;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            if (fileArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.cleanFiles = fileArray;
            $this$toTypedArray$iv = tmpDirtyFiles;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray2 = thisCollection$iv.toArray(new File[0]);
            if (fileArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.dirtyFiles = fileArray2;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Companion;", "", "()V", "ANY_SEQUENCE_NUMBER", "", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TEMP", "LEGAL_KEY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getLEGAL_KEY_PATTERN", "()Ljava/util/regex/Pattern;", "MAGIC", "READ", "REMOVE", "VERSION_1", "create", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "fileSystem", "Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "apollo-http-cache"})
    public static final class Companion {
        public final Pattern getLEGAL_KEY_PATTERN() {
            return LEGAL_KEY_PATTERN;
        }

        @JvmStatic
        @NotNull
        public final DiskLruCache create(@NotNull FileSystem fileSystem, @NotNull File directory, int appVersion, int valueCount, long maxSize) {
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            boolean bl = maxSize > 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "maxSize <= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = valueCount > 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "valueCount <= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Executor executor2 = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), create.executor.1.INSTANCE);
            return new DiskLruCache(fileSystem, directory, appVersion, valueCount, maxSize, executor2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

