/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.http.ResponseBodyCacheSink;
import com.apollographql.apollo3.cache.http.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

final class ResponseBodyProxy
extends ResponseBody {
    private final String contentType;
    private final String contentLength;
    private final BufferedSource responseBodySource;

    ResponseBodyProxy(@NotNull HttpCacheRecordEditor cacheRecordEditor, @NotNull Response sourceResponse, @NotNull ApolloLogger logger) {
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)cacheRecordEditor, (Object)"cacheRecordEditor == null");
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)sourceResponse, (Object)"sourceResponse == null");
        com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.contentType = sourceResponse.header("Content-Type");
        this.contentLength = sourceResponse.header("Content-Length");
        this.responseBodySource = Okio.buffer((Source)new ProxySource(cacheRecordEditor, sourceResponse.body().source(), logger));
    }

    public MediaType contentType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    public long contentLength() {
        try {
            return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @NotNull
    public BufferedSource source() {
        return this.responseBodySource;
    }

    private static class ProxySource
    implements Source {
        private final HttpCacheRecordEditor cacheRecordEditor;
        private final ResponseBodyCacheSink responseBodyCacheSink;
        private final BufferedSource responseBodySource;
        private final ApolloLogger logger;
        private boolean closed;

        ProxySource(HttpCacheRecordEditor cacheRecordEditor, BufferedSource responseBodySource, final ApolloLogger logger) {
            this.cacheRecordEditor = cacheRecordEditor;
            this.responseBodySource = responseBodySource;
            this.logger = logger;
            this.responseBodyCacheSink = new ResponseBodyCacheSink(Okio.buffer((Sink)cacheRecordEditor.bodySink())){

                @Override
                void onException(Exception e) {
                    this.abortCacheQuietly();
                    logger.w((Throwable)e, "Operation failed", new Object[0]);
                }
            };
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            long bytesRead;
            try {
                bytesRead = this.responseBodySource.read(sink, byteCount);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.closed = true;
                    this.abortCacheQuietly();
                }
                throw e;
            }
            if (bytesRead == -1L) {
                if (!this.closed) {
                    this.closed = true;
                    this.commitCache();
                }
                return -1L;
            }
            this.responseBodyCacheSink.copyFrom(sink, sink.size() - bytesRead, bytesRead);
            return bytesRead;
        }

        @NotNull
        public Timeout timeout() {
            return this.responseBodySource.timeout();
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (Utils.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.commitCache();
            } else {
                this.abortCacheQuietly();
            }
        }

        private void commitCache() {
            Utils.closeQuietly((Closeable)this.responseBodySource);
            try {
                this.responseBodyCacheSink.close();
                this.cacheRecordEditor.commit();
            }
            catch (Exception e) {
                Utils.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
                this.abortCacheQuietly();
                this.logger.e((Throwable)e, "Failed to commit cache changes", new Object[0]);
            }
        }

        void abortCacheQuietly() {
            Utils.closeQuietly((Closeable)this.responseBodySource);
            Utils.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
            try {
                this.cacheRecordEditor.abort();
            }
            catch (Exception e) {
                this.logger.w((Throwable)e, "Failed to abort cache edit", new Object[0]);
            }
        }
    }
}

