/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpHeaders;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.CachingHttpEngine;
import com.apollographql.apollo3.cache.http.DiskLruHttpCache;
import com.apollographql.apollo3.exception.HttpCacheMissException;
import com.apollographql.apollo3.network.http.HttpEngine;
import com.apollographql.apollo3.network.http.OkHttpEngineKt;
import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0019\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/cache/http/CachingHttpEngine;", "Lcom/apollographql/apollo3/network/http/HttpEngine;", "directory", "Ljava/io/File;", "maxSize", "", "fileSystem", "Lokio/FileSystem;", "delegate", "(Ljava/io/File;JLokio/FileSystem;Lcom/apollographql/apollo3/network/http/HttpEngine;)V", "store", "Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "cacheMightThrow", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "request", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "cacheKey", "", "delete", "", "dispose", "execute", "(Lcom/apollographql/apollo3/api/http/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "networkMightThrow", "(Lcom/apollographql/apollo3/api/http/HttpRequest;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remove", "key", "Companion", "apollo-http-cache"})
public final class CachingHttpEngine
implements HttpEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpEngine delegate;
    @NotNull
    private final DiskLruHttpCache store;
    @NotNull
    public static final String CACHE_KEY_HEADER = "X-APOLLO-CACHE-KEY";
    @NotNull
    public static final String CACHE_FETCH_POLICY_HEADER = "X-APOLLO-CACHE-FETCH-POLICY";
    @NotNull
    public static final String CACHE_ONLY = "CACHE_ONLY";
    @NotNull
    public static final String NETWORK_ONLY = "NETWORK_ONLY";
    @NotNull
    public static final String CACHE_FIRST = "CACHE_FIRST";
    @NotNull
    public static final String NETWORK_FIRST = "NETWORK_FIRST";
    @NotNull
    public static final String CACHE_SERVED_DATE_HEADER = "X-APOLLO-SERVED-DATE";
    @NotNull
    public static final String CACHE_EXPIRE_TIMEOUT_HEADER = "X-APOLLO-EXPIRE-TIMEOUT";
    @NotNull
    public static final String CACHE_EXPIRE_AFTER_READ_HEADER = "X-APOLLO-EXPIRE-AFTER-READ";
    @NotNull
    public static final String CACHE_DO_NOT_STORE = "X-APOLLO-CACHE-DO-NOT-STORE";
    @NotNull
    public static final String FROM_CACHE = "X-APOLLO-FROM-CACHE";

    public CachingHttpEngine(@NotNull File directory, long maxSize, @NotNull FileSystem fileSystem, @NotNull HttpEngine delegate) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.store = new DiskLruHttpCache(fileSystem, directory, maxSize);
    }

    public /* synthetic */ CachingHttpEngine(File file, long l, FileSystem fileSystem, HttpEngine httpEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileSystem = FileSystem.SYSTEM;
        }
        if ((n & 8) != 0) {
            httpEngine = OkHttpEngineKt.HttpEngine$default((long)0L, (int)1, null);
        }
        this(file, l, fileSystem, httpEngine);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Object execute(@NotNull HttpRequest var1_1, @NotNull Continuation<? super HttpResponse> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dispose() {
    }

    /*
     * Unable to fully structure code
     */
    private final Object networkMightThrow(HttpRequest var1_1, String var2_2, Continuation<? super HttpResponse> var3_3) {
        if (!(var3_3 instanceof networkMightThrow.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ CachingHttpEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CachingHttpEngine.access$networkMightThrow(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = cacheKey;
                $continuation.label = 1;
                v0 = this.delegate.execute(request, (Continuation)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                cacheKey = (String)$continuation.L$2;
                request = (HttpRequest)$continuation.L$1;
                this = (CachingHttpEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                response = (HttpResponse)v0;
                var6_8 = HttpHeaders.valueOf((List)request.getHeaders(), (String)"X-APOLLO-CACHE-DO-NOT-STORE");
                if (var6_8 == null) {
                    v1 = null;
                } else {
                    var8_11 = var6_8.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)var8_11, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    v1 = var8_11;
                }
                doNotStore = Intrinsics.areEqual(v1, (Object)"true");
                var6_9 = response.getStatusCode();
                v2 = 200 <= var6_9 ? var6_9 < 300 : false;
                if (v2 && !doNotStore) {
                    v3 = response.newBuilder();
                    var6_10 = new HttpHeader[2];
                    var6_10[0] = new HttpHeader("X-APOLLO-CACHE-KEY", cacheKey);
                    var7_13 = Instant.now().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_13, (String)"now().toString()");
                    var6_10[1] = new HttpHeader("X-APOLLO-SERVED-DATE", var7_13);
                    this.store.write(v3.addHeaders(CollectionsKt.listOf((Object[])var6_10)).build(), cacheKey);
                    return this.store.read(cacheKey);
                }
                return response;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final HttpResponse cacheMightThrow(HttpRequest request, String cacheKey) {
        long l;
        long l2;
        String string;
        HttpHeader[] httpHeaderArray;
        String operationName = HttpHeaders.valueOf((List)request.getHeaders(), (String)"X-APOLLO-OPERATION-NAME");
        try {
            httpHeaderArray = new HttpHeader[]{new HttpHeader(FROM_CACHE, "true"), new HttpHeader(CACHE_KEY_HEADER, cacheKey)};
            httpHeaderArray = this.store.read(cacheKey).newBuilder().addHeaders(CollectionsKt.listOf((Object[])httpHeaderArray)).build();
        }
        catch (Exception e) {
            throw new HttpCacheMissException(Intrinsics.stringPlus((String)"HTTP Cache miss for ", (Object)operationName), e);
        }
        HttpHeader[] response = httpHeaderArray;
        String e = HttpHeaders.valueOf((List)request.getHeaders(), (String)CACHE_EXPIRE_AFTER_READ_HEADER);
        if (e == null) {
            string = null;
        } else {
            String string2 = e.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string2;
        }
        boolean expireAfterRead = Intrinsics.areEqual(string, (Object)"true");
        if (expireAfterRead) {
            this.store.remove(cacheKey);
        }
        String string3 = HttpHeaders.valueOf((List)request.getHeaders(), (String)CACHE_EXPIRE_TIMEOUT_HEADER);
        if (string3 == null) {
            l2 = 0L;
        } else {
            Long l3 = StringsKt.toLongOrNull((String)string3);
            l2 = l3 == null ? 0L : l3;
        }
        long timeoutMillis = l2;
        try {
            l = Instant.parse(HttpHeaders.valueOf((List)response.getHeaders(), (String)CACHE_SERVED_DATE_HEADER)).toEpochMilli();
        }
        catch (DateTimeParseException e2) {
            l = 0L;
        }
        long servedDateMillis = l;
        long nowMillis = Instant.now().toEpochMilli();
        if (timeoutMillis > 0L && servedDateMillis > 0L && nowMillis - servedDateMillis > timeoutMillis) {
            throw new HttpCacheMissException("HTTP Cache stale response for " + operationName + " (served " + HttpHeaders.valueOf((List)response.getHeaders(), (String)CACHE_SERVED_DATE_HEADER) + ')', null, 2, null);
        }
        return response;
    }

    public final void delete() {
        this.store.delete();
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.store.remove(key);
    }

    public static final /* synthetic */ Object access$networkMightThrow(CachingHttpEngine $this, HttpRequest request, String cacheKey, Continuation $completion) {
        return $this.networkMightThrow(request, cacheKey, (Continuation<? super HttpResponse>)$completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/cache/http/CachingHttpEngine$Companion;", "", "()V", "CACHE_DO_NOT_STORE", "", "CACHE_EXPIRE_AFTER_READ_HEADER", "CACHE_EXPIRE_TIMEOUT_HEADER", "CACHE_FETCH_POLICY_HEADER", "CACHE_FIRST", "CACHE_KEY_HEADER", "CACHE_ONLY", "CACHE_SERVED_DATE_HEADER", "FROM_CACHE", "NETWORK_FIRST", "NETWORK_ONLY", "cacheKey", "httpRequest", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String cacheKey(@NotNull HttpRequest httpRequest) {
            String string;
            Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
            switch (WhenMappings.$EnumSwitchMapping$0[httpRequest.getMethod().ordinal()]) {
                case 1: {
                    String string2 = Intrinsics.stringPlus((String)"Get", (Object)httpRequest.getUrl());
                    byte[] byArray = string2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    string = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).md5().hex();
                    break;
                }
                case 2: {
                    Buffer buffer = new Buffer();
                    buffer.writeUtf8("Post");
                    HttpBody httpBody = httpRequest.getBody();
                    Intrinsics.checkNotNull((Object)httpBody);
                    httpBody.writeTo((BufferedSink)buffer);
                    string = buffer.md5().hex();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HttpMethod.values().length];
                nArray[HttpMethod.Get.ordinal()] = 1;
                nArray[HttpMethod.Post.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

