/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.apollographql.apollo3.cache.http.internal.FileSystem;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "", "fileSystem", "Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "directory", "Ljava/io/File;", "maxSize", "", "(Lcom/apollographql/apollo3/cache/http/internal/FileSystem;Ljava/io/File;J)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "kotlin.jvm.PlatformType", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createDiskLruCache", "delete", "", "read", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "cacheKey", "", "remove", "write", "response", "Companion", "apollo-http-cache"})
public final class DiskLruHttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final long maxSize;
    @NotNull
    private DiskLruCache cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final JsonAdapter<Object> adapter;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public DiskLruHttpCache(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
        this.cacheLock = new ReentrantReadWriteLock();
        this.adapter = new Moshi.Builder().build().adapter(Object.class);
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HttpResponse read(@NotNull String cacheKey) {
        Object object;
        String string;
        List list;
        Map map;
        Closeable $i$a$-read-DiskLruHttpCache$read$snapshot$22;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object2 = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        Object object3 = ((ReentrantReadWriteLock)object2).readLock();
        ((ReentrantReadWriteLock.ReadLock)object3).lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$read$snapshot$22 = false;
            $i$a$-read-DiskLruHttpCache$read$snapshot$22 = this.cache.get(cacheKey);
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object3).unlock();
        }
        DiskLruCache.Snapshot snapshot = $i$a$-read-DiskLruHttpCache$read$snapshot$22;
        if (snapshot == null) {
            object2 = "HTTP cache: no snapshot";
            bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        DiskLruCache.Snapshot snapshot2 = snapshot;
        Source source = snapshot2.getSource(0);
        $i$a$-read-DiskLruHttpCache$read$snapshot$22 = (Closeable)Okio.buffer((Source)source);
        boolean bl3 = false;
        boolean bl4 = false;
        Object object4 = null;
        try {
            Object it = (BufferedSource)$i$a$-read-DiskLruHttpCache$read$snapshot$22;
            boolean bl5 = false;
            it = this.adapter.fromJson(it);
        }
        catch (Throwable it) {
            object4 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-read-DiskLruHttpCache$read$snapshot$22, (Throwable)object4);
        }
        object3 = it;
        Map map2 = map = object3 instanceof Map ? (Map)object3 : null;
        if (map == null) {
            object3 = "HTTP cache: no map";
            boolean $i$a$-read-DiskLruHttpCache$read$snapshot$22 = false;
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        Map map3 = map;
        $i$a$-read-DiskLruHttpCache$read$snapshot$22 = map3.get("headers");
        Object object5 = object3 = $i$a$-read-DiskLruHttpCache$read$snapshot$22 instanceof List ? (List)((Object)$i$a$-read-DiskLruHttpCache$read$snapshot$22) : null;
        if (object3 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object3;
            boolean $i$f$map = false;
            object4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map map4 = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                Map.Entry entry = (Map.Entry)CollectionsKt.single((Iterable)it.entrySet());
                HttpHeader httpHeader = new HttpHeader((String)entry.getKey(), (String)entry.getValue());
                collection.add(httpHeader);
            }
            list = (List)destination$iv$iv;
        }
        List headers = list;
        Object object6 = map3.get("statusCode");
        String string2 = string = object6 instanceof String ? (String)object6 : null;
        if (string == null) {
            object = null;
        } else {
            object6 = string;
            boolean bl7 = false;
            object = object3 = Integer.valueOf(Integer.parseInt(object6));
        }
        if (object3 == null) {
            string = "HTTP cache: no statusCode";
            boolean bl8 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        HttpResponse.Builder builder = new HttpResponse.Builder(((Integer)object3).intValue());
        object3 = headers;
        if (object3 == null) {
            string = "HTTP cache: no headers";
            boolean bl9 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return builder.body(Okio.buffer((Source)snapshot2.getSource(1))).addHeaders((List)object3).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull HttpResponse response, @NotNull String cacheKey) {
        DiskLruCache.Editor $i$a$-read-DiskLruHttpCache$write$editor$22;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$write$editor$22 = false;
            $i$a$-read-DiskLruHttpCache$write$editor$22 = this.cache.edit(cacheKey);
        }
        finally {
            readLock.unlock();
        }
        DiskLruCache.Editor editor = $i$a$-read-DiskLruHttpCache$write$editor$22;
        if (editor == null) {
            return;
        }
        try {
            BufferedSink it2;
            object = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            bl = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                Collection<Map> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it2 = (BufferedSink)object;
                boolean bl4 = false;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)String.valueOf(response.getStatusCode()));
                Iterable iterable = response.getHeaders();
                String string = "headers";
                int n = 1;
                Pair[] pairArray2 = pairArray;
                boolean $i$f$map = false;
                void var15_27 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void httpHeader;
                    HttpHeader httpHeader2 = (HttpHeader)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)httpHeader.getName(), (Object)httpHeader.getValue()));
                    collection.add(map);
                }
                collection = (List)destination$iv$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
                Map map = MapsKt.mapOf((Pair[])pairArray);
                this.adapter.toJson(it2, (Object)map);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = (Closeable)Okio.buffer((Sink)editor.newSink(1));
            bl = false;
            boolean bl6 = false;
            Throwable throwable2 = null;
            try {
                it2 = (BufferedSink)object;
                boolean bl7 = false;
                BufferedSource responseBody = response.getBody();
                if (responseBody != null) {
                    it2.writeAll((Source)responseBody);
                    responseBody.close();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            editor.commit();
        }
        catch (Exception e) {
            editor.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        DiskLruCache diskLruCache;
        DiskLruCache diskLruCache2;
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        DiskLruHttpCache diskLruHttpCache = this;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            this.cache.delete();
            diskLruCache2 = this.createDiskLruCache();
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        diskLruHttpCache.cache = diskLruCache = diskLruCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            boolean bl4 = this.cache.remove(cacheKey);
        }
        finally {
            readLock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

