/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.apollographql.apollo3.cache.http.internal.FileSystem;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "", "directory", "Ljava/io/File;", "maxSize", "", "(Ljava/io/File;J)V", "fileSystem", "Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "(Lcom/apollographql/apollo3/cache/http/internal/FileSystem;Ljava/io/File;J)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "kotlin.jvm.PlatformType", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createDiskLruCache", "delete", "", "read", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "cacheKey", "", "remove", "write", "response", "Companion", "apollo-http-cache"})
public final class DiskLruHttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final long maxSize;
    @NotNull
    private DiskLruCache cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final JsonAdapter<Object> adapter;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public DiskLruHttpCache(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
        this.cacheLock = new ReentrantReadWriteLock();
        this.adapter = new Moshi.Builder().build().adapter(Object.class);
    }

    public DiskLruHttpCache(@NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(FileSystem.SYSTEM, directory, maxSize);
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HttpResponse read(@NotNull String cacheKey) {
        Object object;
        Map map;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object4 = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        Object object5 = ((ReentrantReadWriteLock)object4).readLock();
        ((ReentrantReadWriteLock.ReadLock)object5).lock();
        try {
            boolean bl3 = false;
            object3 = this.cache.get(cacheKey);
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object5).unlock();
        }
        DiskLruCache.Snapshot snapshot = object3;
        if (snapshot == null) {
            object4 = "HTTP cache: no snapshot";
            bl = false;
            throw (Throwable)new IllegalStateException(object4.toString());
        }
        DiskLruCache.Snapshot snapshot2 = snapshot;
        Source source = snapshot2.getSource(0);
        object3 = (Closeable)Okio.buffer((Source)source);
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)object3;
            boolean bl6 = false;
            object2 = this.adapter.fromJson(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
        }
        object5 = object2;
        Map map2 = map = object5 instanceof Map ? (Map)object5 : null;
        if (map == null) {
            object5 = "HTTP cache: no map";
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(object5.toString());
        }
        Map map3 = map;
        object3 = map3.get("statusCode");
        Object object6 = object5 = object3 instanceof String ? (String)object3 : null;
        if (object5 == null) {
            object = null;
        } else {
            object3 = object5;
            bl4 = false;
            object = map = Integer.valueOf(Integer.parseInt((String)object3));
        }
        if (map == null) {
            object5 = "HTTP cache: no statusCode";
            boolean bl8 = false;
            throw (Throwable)new IllegalStateException(object5.toString());
        }
        int n = (Integer)((Object)map);
        object5 = map3.get("headers");
        Map map4 = map = object5 instanceof Map ? (Map)object5 : null;
        if (map == null) {
            object5 = "HTTP cache: no headers";
            boolean bl9 = false;
            throw (Throwable)new IllegalStateException(object5.toString());
        }
        return new HttpResponse(n, map, Okio.buffer((Source)snapshot2.getSource(1)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull HttpResponse response, @NotNull String cacheKey) {
        DiskLruCache.Editor $i$a$-read-DiskLruHttpCache$write$editor$22;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$write$editor$22 = false;
            $i$a$-read-DiskLruHttpCache$write$editor$22 = this.cache.edit(cacheKey);
        }
        finally {
            readLock.unlock();
        }
        DiskLruCache.Editor editor = $i$a$-read-DiskLruHttpCache$write$editor$22;
        if (editor == null) {
            return;
        }
        try {
            Map map;
            Pair[] pairArray;
            BufferedSink it2;
            object = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            bl = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                it2 = (BufferedSink)object;
                boolean bl4 = false;
                pairArray = new Pair[]{TuplesKt.to((Object)"statusCode", (Object)String.valueOf(response.getStatusCode())), TuplesKt.to((Object)"headers", (Object)response.getHeaders())};
                map = MapsKt.mapOf((Pair[])pairArray);
                this.adapter.toJson(it2, (Object)map);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = (Closeable)Okio.buffer((Sink)editor.newSink(1));
            bl = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                it2 = (BufferedSink)object;
                boolean bl6 = false;
                pairArray = new Pair[]{TuplesKt.to((Object)"statusCode", (Object)response.getStatusCode()), TuplesKt.to((Object)"headers", (Object)response.getHeaders())};
                map = MapsKt.mapOf((Pair[])pairArray);
                BufferedSource responseBody = response.getBody();
                if (responseBody != null) {
                    it2.writeAll((Source)responseBody);
                    responseBody.close();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            editor.commit();
        }
        catch (Exception e) {
            editor.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        DiskLruCache diskLruCache;
        DiskLruCache diskLruCache2;
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        DiskLruHttpCache diskLruHttpCache = this;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            this.cache.delete();
            diskLruCache2 = this.createDiskLruCache();
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        diskLruHttpCache.cache = diskLruCache = diskLruCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            boolean bl4 = this.cache.remove(cacheKey);
        }
        finally {
            readLock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

