/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.kotlinx.serialization.json;

import com.apollographql.apollo3.relocated.kotlin.ULong;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Reflection;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringNumberConversionsKt;
import com.apollographql.apollo3.relocated.kotlin.text.UStringsKt;
import com.apollographql.apollo3.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo3.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo3.relocated.kotlinx.serialization.descriptors.SerialDescriptorsKt;
import com.apollographql.apollo3.relocated.kotlinx.serialization.encoding.Decoder;
import com.apollographql.apollo3.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo3.relocated.kotlinx.serialization.internal.PrimitiveSerialDescriptor;
import com.apollographql.apollo3.relocated.kotlinx.serialization.internal.ULongSerializer;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.JsonElementSerializersKt;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.JsonLiteral;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.JsonExceptionsKt;

public final class JsonLiteralSerializer
implements KSerializer {
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    public static final PrimitiveSerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("kotlinx.serialization.json.JsonLiteral");

    @Override
    public final SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public final void serialize(Encoder encoder, Object object) {
        JsonLiteral jsonLiteral = (JsonLiteral)object;
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(jsonLiteral, "value");
        JsonElementSerializersKt.access$verify(encoder);
        if (jsonLiteral.isString) {
            encoder.encodeString(jsonLiteral.content);
        } else {
            object = jsonLiteral.coerceToInlineType;
            if (object != null) {
                encoder.encodeInline((SerialDescriptor)object).encodeString(jsonLiteral.content);
            } else {
                object = StringsKt__StringNumberConversionsKt.toLongOrNull(jsonLiteral.content);
                if (object != null) {
                    encoder.encodeLong(((Number)object).longValue());
                } else {
                    object = UStringsKt.toULongOrNull(jsonLiteral.content);
                    if (object != null) {
                        long l = ((ULong)object).data;
                        encoder.encodeInline(ULongSerializer.descriptor).encodeLong(l);
                    } else {
                        object = StringsKt__StringNumberConversionsKt.toDoubleOrNull(jsonLiteral.content);
                        if (object != null) {
                            encoder.encodeDouble(((Number)object).doubleValue());
                        } else {
                            object = jsonLiteral.content;
                            Intrinsics.checkNotNullParameter(object, "<this>");
                            object = Intrinsics.areEqual(object, "true") ? Boolean.TRUE : (Intrinsics.areEqual(object, "false") ? Boolean.FALSE : null);
                            if (object != null) {
                                encoder.encodeBoolean((Boolean)object);
                            } else {
                                encoder.encodeString(jsonLiteral.content);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final Object deserialize(Decoder object) {
        Decoder decoder = object;
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Object object2 = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (object2 instanceof JsonLiteral) {
            return (JsonLiteral)object2;
        }
        Object object3 = object2;
        object2 = "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(object2.getClass());
        object = object3.toString();
        throw JsonExceptionsKt.JsonDecodingException(-1, (String)object2, (String)object);
    }
}

