/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.org.objectweb.asm;

import com.apollographql.apollo3.relocated.org.objectweb.asm.ByteVector;
import com.apollographql.apollo3.relocated.org.objectweb.asm.ClassReader;
import com.apollographql.apollo3.relocated.org.objectweb.asm.ClassWriter;
import com.apollographql.apollo3.relocated.org.objectweb.asm.ConstantDynamic;
import com.apollographql.apollo3.relocated.org.objectweb.asm.Handle;
import com.apollographql.apollo3.relocated.org.objectweb.asm.SymbolTable$Entry;
import com.apollographql.apollo3.relocated.org.objectweb.asm.Type;

public final class SymbolTable {
    public final ClassWriter classWriter;
    public final ClassReader sourceClassReader;
    public int majorVersion;
    public String className;
    public int entryCount;
    public SymbolTable$Entry[] entries;
    public int constantPoolCount;
    public final ByteVector constantPool;
    public int bootstrapMethodCount;
    public ByteVector bootstrapMethods;
    public int typeCount;
    public SymbolTable$Entry[] typeTable;

    public SymbolTable(ClassWriter classWriter) {
        SymbolTable symbolTable = this;
        symbolTable.classWriter = classWriter;
        symbolTable.sourceClassReader = null;
        symbolTable.entries = new SymbolTable$Entry[256];
        symbolTable.constantPoolCount = 1;
        symbolTable.constantPool = new ByteVector();
    }

    public final SymbolTable$Entry get(int n) {
        return this.entries[n % this.entries.length];
    }

    public final SymbolTable$Entry put(SymbolTable$Entry symbolTable$Entry) {
        SymbolTable$Entry[] symbolTable$EntryArray = this.entries;
        if (this.entryCount > this.entries.length * 3 / 4) {
            int n = symbolTable$EntryArray.length * 2 + 1;
            SymbolTable$Entry[] symbolTable$EntryArray2 = new SymbolTable$Entry[n];
            for (int i = (v739687) - 1; i >= 0; --i) {
                SymbolTable$Entry symbolTable$Entry2 = this.entries[i];
                while (symbolTable$Entry2 != null) {
                    SymbolTable$Entry symbolTable$Entry3 = symbolTable$Entry2;
                    int n2 = symbolTable$Entry3.hashCode % n;
                    SymbolTable$Entry symbolTable$Entry4 = symbolTable$Entry3.next;
                    symbolTable$Entry2.next = symbolTable$EntryArray2[n2];
                    symbolTable$EntryArray2[n2] = symbolTable$Entry2;
                    symbolTable$Entry2 = symbolTable$Entry4;
                }
            }
            this.entries = symbolTable$EntryArray2;
        }
        ++this.entryCount;
        int n = symbolTable$Entry.hashCode;
        symbolTable$EntryArray = this.entries;
        symbolTable$Entry.next = symbolTable$EntryArray[n %= symbolTable$EntryArray.length];
        this.entries[n] = symbolTable$Entry;
        return symbolTable$Entry;
    }

    public final SymbolTable$Entry addConstantMemberReference(int n, String string, String string2, String string3) {
        int n2 = string.hashCode();
        n2 = string2.hashCode() * n2;
        n2 = string3.hashCode() * n2 + n & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = this;
        int n3 = this.addConstantUtf8Reference((int)7, (String)string).index;
        symbolTable.constantPool.put122(n, n3, this.addConstantNameAndType(string2, string3));
        int n4 = this.constantPoolCount;
        this.constantPoolCount = n4 + 1;
        return symbolTable.put(new SymbolTable$Entry(n4, n, string, string2, string3, 0L, n2));
    }

    public final int addConstantNameAndType(String string, String string2) {
        int n = string.hashCode();
        n = string2.hashCode() * n + 12 & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 12 && symbolTable$Entry.hashCode == n && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = this;
        int n2 = this.addConstantUtf8(string);
        int n3 = this.addConstantUtf8(string2);
        symbolTable.constantPool.put122(12, n2, n3);
        int n4 = this.constantPoolCount;
        this.constantPoolCount = n4 + 1;
        return symbolTable.put((SymbolTable$Entry)new SymbolTable$Entry((int)n4, (String)string, (String)string2, (int)n)).index;
    }

    public final int addConstantUtf8(String string) {
        int n = 1;
        n = string.hashCode() + n & Integer.MAX_VALUE;
        Object object = this.get(n);
        while (object != null) {
            if (((SymbolTable$Entry)object).tag == 1 && ((SymbolTable$Entry)object).hashCode == n && ((SymbolTable$Entry)object).value.equals(string)) {
                return ((SymbolTable$Entry)object).index;
            }
            object = ((SymbolTable$Entry)object).next;
        }
        object = this.constantPool.putByte(1);
        int n2 = string.length();
        if (n2 <= 65535) {
            block6: {
                int n3 = ((ByteVector)object).length;
                if (n3 + 2 + n2 > ((ByteVector)object).data.length) {
                    ((ByteVector)object).enlarge(n2 + 2);
                }
                byte[] byArray = ((ByteVector)object).data;
                byArray[n3++] = (byte)(n2 >>> 8);
                int n4 = n3 + 1;
                ((ByteVector)object).data[n3] = (byte)n2;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n5 = string.charAt(n3);
                    if (n5 >= 1 && n5 <= 127) {
                        int n6 = n5;
                        n5 = n4 + 1;
                        byArray[n4] = (byte)n6;
                        n4 = n5;
                        continue;
                    }
                    ((ByteVector)object).length = n4;
                    ((ByteVector)object).encodeUtf8(n3, 65535, string);
                    break block6;
                }
                ((ByteVector)object).length = n4;
            }
            int n7 = this.constantPoolCount;
            this.constantPoolCount = n7 + 1;
            return this.put((SymbolTable$Entry)new SymbolTable$Entry((int)n7, (int)1, (int)n, (String)string)).index;
        }
        throw new IllegalArgumentException("UTF8 string too large");
    }

    public final int addType(String symbolTable$EntryArray) {
        SymbolTable$Entry symbolTable$Entry;
        int n = symbolTable$EntryArray.hashCode() + 128 & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry2 = this.get(n);
        while (symbolTable$Entry2 != null) {
            if (symbolTable$Entry2.tag == 128 && symbolTable$Entry2.hashCode == n && symbolTable$Entry2.value.equals(symbolTable$EntryArray)) {
                return symbolTable$Entry2.index;
            }
            symbolTable$Entry2 = symbolTable$Entry2.next;
        }
        symbolTable$Entry2 = symbolTable$Entry;
        int n2 = this.typeCount;
        symbolTable$Entry = new SymbolTable$Entry(n2, 128, n, (String)symbolTable$EntryArray);
        if (this.typeTable == null) {
            this.typeTable = new SymbolTable$Entry[16];
        }
        symbolTable$EntryArray = this.typeTable;
        if (n2 == this.typeTable.length) {
            symbolTable$EntryArray = new SymbolTable$Entry[symbolTable$EntryArray.length * 2];
            n = symbolTable$EntryArray.length;
            System.arraycopy(symbolTable$EntryArray, 0, symbolTable$EntryArray, 0, n);
            this.typeTable = symbolTable$EntryArray;
        }
        int n3 = this.typeCount;
        this.typeCount = n3 + 1;
        this.typeTable[n3] = symbolTable$Entry2;
        return this.put((SymbolTable$Entry)symbolTable$Entry2).index;
    }

    public final SymbolTable$Entry addConstantIntegerOrFloat(int n, int n2) {
        int n3 = n + n2 & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n2) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = this;
        symbolTable.constantPool.putByte(n).putInt(n2);
        int n4 = this.constantPoolCount;
        this.constantPoolCount = n4 + 1;
        long l = n2;
        return symbolTable.put(new SymbolTable$Entry(n4, n, l, n3));
    }

    public final SymbolTable$Entry addConstantLongOrDouble(int n, long l) {
        int n2 = (int)l;
        int n3 = (int)(l >>> 32);
        int n4 = n + n2 + n3 & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = ((SymbolTable)object).get(n4);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n4 && symbolTable$Entry.data == l) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = object;
        int n5 = symbolTable.constantPoolCount;
        ByteVector byteVector = symbolTable.constantPool.putByte(n);
        int n6 = byteVector.length;
        if (n6 + 8 > byteVector.data.length) {
            byteVector.enlarge(8);
        }
        SymbolTable symbolTable2 = object;
        ByteVector byteVector2 = byteVector;
        Object object = byteVector2.data;
        int n7 = n2;
        int n8 = n2;
        int n9 = n2;
        int n10 = n2;
        int n11 = n6 + 1;
        object[n6] = (byte)(n3 >>> 24);
        n2 = n11 + 1;
        object[n11] = (byte)(n3 >>> 16);
        n11 = n2 + 1;
        object[n2] = (byte)(n3 >>> 8);
        n2 = n11 + 1;
        object[n11] = (byte)n3;
        n11 = n2 + 1;
        object[n2] = (byte)(n10 >>> 24);
        n2 = n11 + 1;
        object[n11] = (byte)(n9 >>> 16);
        n11 = n2 + 1;
        object[n2] = (byte)(n8 >>> 8);
        n2 = n11 + 1;
        byteVector2.data[n11] = (byte)n7;
        byteVector2.length = n2;
        symbolTable2.constantPoolCount += 2;
        return symbolTable2.put(new SymbolTable$Entry(n5, n, l, n4));
    }

    public final SymbolTable$Entry addConstantUtf8Reference(int n, String string) {
        int n2 = string.hashCode() + n & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = this;
        symbolTable.constantPool.put12(n, this.addConstantUtf8(string));
        int n3 = this.constantPoolCount;
        this.constantPoolCount = n3 + 1;
        return symbolTable.put(new SymbolTable$Entry(n3, n, n2, string));
    }

    public final SymbolTable$Entry addConstant(Object object) {
        if (object instanceof Integer) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(3, (Integer)object);
        }
        if (object instanceof Byte) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(3, ((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(3, ((Character)object).charValue());
        }
        if (object instanceof Short) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(3, ((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(3, ((Boolean)object).booleanValue() ? 1 : 0);
        }
        if (object instanceof Float) {
            return ((SymbolTable)((Object)string)).addConstantIntegerOrFloat(4, Float.floatToRawIntBits(((Float)object).floatValue()));
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return ((SymbolTable)((Object)string)).addConstantLongOrDouble(5, l);
        }
        if (object instanceof Double) {
            long l = Double.doubleToRawLongBits((Double)object);
            return ((SymbolTable)((Object)string)).addConstantLongOrDouble(6, l);
        }
        if (object instanceof String) {
            return ((SymbolTable)((Object)string)).addConstantUtf8Reference(8, (String)object);
        }
        if (object instanceof Type) {
            object = (Type)object;
            int n = ((Type)object).sort;
            if (n == 12) {
                n = 10;
            }
            if (n == 10) {
                Object object2 = object;
                int n2 = ((Type)object2).valueBegin;
                return ((SymbolTable)((Object)string)).addConstantUtf8Reference(7, ((Type)object).valueBuffer.substring(n2, ((Type)object2).valueEnd));
            }
            if (n == 11) {
                return ((SymbolTable)((Object)string)).addConstantUtf8Reference(16, ((Type)object).getDescriptor());
            }
            return ((SymbolTable)((Object)string)).addConstantUtf8Reference(7, ((Type)object).getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            int n = handle.tag;
            object = handle.owner;
            String string = handle.name;
            String string2 = handle.descriptor;
            boolean bl = handle.isInterface;
            return ((SymbolTable)((Object)string)).addConstantMethodHandle(n, (String)object, string, string2, bl);
        }
        if (object instanceof ConstantDynamic) {
            SymbolTable symbolTable = string;
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            String string = constantDynamic.name;
            object = constantDynamic.descriptor;
            Handle handle = constantDynamic.bootstrapMethod;
            return symbolTable.addConstantDynamicOrInvokeDynamicReference(17, symbolTable.addBootstrapMethod((Handle)handle, (Object[])constantDynamic.bootstrapMethodArguments).index, string, (String)object);
        }
        throw new IllegalArgumentException("value " + object);
    }

    public final SymbolTable$Entry addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    public final SymbolTable$Entry addConstantMethodHandle(int n, String string, String string2, String string3, boolean bl) {
        int n2 = string.hashCode();
        n2 = string2.hashCode() * n2;
        n2 = string3.hashCode() * n2 * n + 15 & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 15 && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.data == (long)n && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        if (n <= 4) {
            this.constantPool.put112(n, this.addConstantMemberReference((int)9, (String)string, (String)string2, (String)string3).index);
        } else {
            ByteVector byteVector = this.constantPool;
            int n3 = bl ? 11 : 10;
            byteVector.put112(n, this.addConstantMemberReference((int)n3, (String)string, (String)string2, (String)string3).index);
        }
        int n4 = this.constantPoolCount;
        this.constantPoolCount = n4 + 1;
        long l = n;
        return this.put(new SymbolTable$Entry(n4, 15, string, string2, string3, l, n2));
    }

    public final SymbolTable$Entry addBootstrapMethod(Handle handle, Object ... objectArray) {
        SymbolTable$Entry symbolTable$Entry;
        block8: {
            int n;
            int n2;
            ByteVector byteVector = this.bootstrapMethods;
            if (byteVector == null) {
                ByteVector byteVector2;
                byteVector = byteVector2;
                byteVector2 = new ByteVector();
                this.bootstrapMethods = byteVector;
            }
            int n3 = objectArray.length;
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.addConstant((Object)objectArray[n2]).index;
            }
            Handle handle2 = handle;
            n2 = byteVector.length;
            int n4 = handle2.tag;
            String string = handle2.owner;
            String string2 = handle2.name;
            String string3 = handle2.descriptor;
            boolean bl = handle2.isInterface;
            byteVector.putShort(this.addConstantMethodHandle((int)n4, (String)string, (String)string2, (String)string3, (boolean)bl).index);
            byteVector.putShort(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                byteVector.putShort(nArray[n4]);
            }
            int n5 = byteVector.length - n2;
            int n6 = handle.hashCode();
            n3 = objectArray.length;
            for (n = 0; n < n3; ++n) {
                n6 ^= objectArray[n].hashCode();
            }
            int n7 = n6 & Integer.MAX_VALUE;
            byte[] byArray = this.bootstrapMethods.data;
            symbolTable$Entry = this.get(n7);
            while (symbolTable$Entry != null) {
                if (symbolTable$Entry.tag == 64 && symbolTable$Entry.hashCode == n7) {
                    n = (int)symbolTable$Entry.data;
                    n4 = 1;
                    for (int i = 0; i < n5; ++i) {
                        if (byArray[n2 + i] == byArray[n + i]) continue;
                        n4 = 0;
                        break;
                    }
                    if (n4 != 0) {
                        this.bootstrapMethods.length = n2;
                        break block8;
                    }
                }
                symbolTable$Entry = symbolTable$Entry.next;
            }
            int n8 = this.bootstrapMethodCount;
            this.bootstrapMethodCount = n8 + 1;
            long l = n2;
            symbolTable$Entry = this.put(new SymbolTable$Entry(n8, 64, l, n7));
        }
        return symbolTable$Entry;
    }

    public final int addUninitializedType(int n, String string) {
        SymbolTable$Entry symbolTable$Entry;
        int n2 = string.hashCode() + 129 + n & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry2 = this.get(n2);
        while (symbolTable$Entry2 != null) {
            if (symbolTable$Entry2.tag == 129 && symbolTable$Entry2.hashCode == n2 && symbolTable$Entry2.data == (long)n && symbolTable$Entry2.value.equals(string)) {
                return symbolTable$Entry2.index;
            }
            symbolTable$Entry2 = symbolTable$Entry2.next;
        }
        symbolTable$Entry2 = symbolTable$Entry;
        int n3 = n;
        n = this.typeCount;
        long l = n3;
        symbolTable$Entry = new SymbolTable$Entry(n, string, l, n2);
        if (this.typeTable == null) {
            this.typeTable = new SymbolTable$Entry[16];
        }
        SymbolTable$Entry[] symbolTable$EntryArray = this.typeTable;
        if (n == this.typeTable.length) {
            symbolTable$EntryArray = new SymbolTable$Entry[symbolTable$EntryArray.length * 2];
            int n4 = symbolTable$EntryArray.length;
            System.arraycopy(symbolTable$EntryArray, 0, symbolTable$EntryArray, 0, n4);
            this.typeTable = symbolTable$EntryArray;
        }
        int n5 = this.typeCount;
        this.typeCount = n5 + 1;
        this.typeTable[n5] = symbolTable$Entry2;
        return this.put((SymbolTable$Entry)symbolTable$Entry2).index;
    }

    public final SymbolTable$Entry addConstantDynamicOrInvokeDynamicReference(int n, int n2, String string, String string2) {
        int n3 = string.hashCode();
        n3 = string2.hashCode() * n3;
        n3 = (n2 + 1) * n3 + n & Integer.MAX_VALUE;
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n2 && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        SymbolTable symbolTable = this;
        symbolTable.constantPool.put122(n, n2, this.addConstantNameAndType(string, string2));
        int n4 = this.constantPoolCount;
        this.constantPoolCount = n4 + 1;
        long l = n2;
        return symbolTable.put(new SymbolTable$Entry(n4, n, null, string, string2, l, n3));
    }
}

