/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.platform;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.OpenJSSEPlatform$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform$Companion;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

public final class OpenJSSEPlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider = (Provider)new OpenJSSE();

    static {
        boolean bl;
        String string = "org.openjsse.net.ssl.OpenJSSE";
        try {
            Class.forName(string, false, OpenJSSEPlatform$Companion.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), ((OpenJSSEPlatform)object).provider);
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        String string = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
        object = Intrinsics.stringPlus(string, "Unexpected default trust managers: ");
        throw new IllegalStateException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void configureTlsExtensions(javax.net.ssl.SSLSocket object, String string, List stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "protocols");
        if (object instanceof SSLSocket) {
            OpenJSSEPlatform openJSSEPlatform = (SSLSocket)object;
            if (!((object = openJSSEPlatform.getSSLParameters()) instanceof org.openjsse.javax.net.ssl.SSLParameters)) return;
            string = (org.openjsse.javax.net.ssl.SSLParameters)object;
            if ((stringArray = Platform$Companion.alpnProtocolNames((List)stringArray).toArray(new String[0])) == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            string.setApplicationProtocols(stringArray);
            openJSSEPlatform.setSSLParameters((SSLParameters)object);
            return;
        } else {
            super.configureTlsExtensions((javax.net.ssl.SSLSocket)object, string, (List)stringArray);
        }
    }

    @Override
    public final String getSelectedProtocol(javax.net.ssl.SSLSocket sSLSocket) {
        if (!(sSLSocket instanceof SSLSocket) || ((object = ((SSLSocket)sSLSocket).getApplicationProtocol()) == null ? true : Intrinsics.areEqual(object, ""))) {
            Object object = null;
        }
        return object;
    }
}

