/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.kotlin.enums;

import com.apollographql.apollo3.relocated.kotlin.collections.AbstractList;
import com.apollographql.apollo3.relocated.kotlin.enums.EnumEntries;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import java.io.Serializable;

public final class EnumEntriesList
extends AbstractList
implements EnumEntries,
Serializable {
    public final Enum[] entries;

    public EnumEntriesList(Enum[] enumArray) {
        Intrinsics.checkNotNullParameter(enumArray, "entries");
        this.entries = enumArray;
    }

    @Override
    public final int getSize() {
        return this.entries.length;
    }

    @Override
    public final Object get(int n) {
        Enum[] enumArray = enumArray.entries;
        int n2 = enumArray.entries.length;
        if (n >= 0 && n < n2) {
            return enumArray[n];
        }
        throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
    }

    @Override
    public final boolean contains(Object object) {
        if (!(object instanceof Enum)) {
            return false;
        }
        object = (Enum)object;
        Intrinsics.checkNotNullParameter(object, "element");
        Object object2 = object2.entries;
        int n = ((Enum)object).ordinal();
        Intrinsics.checkNotNullParameter(object2, "<this>");
        object2 = n >= 0 && n <= ((Enum[])object2).length - 1 ? object2[n] : null;
        return object2 == object;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Enum)) {
            return -1;
        }
        object = (Enum)object;
        Intrinsics.checkNotNullParameter(object, "element");
        int n = ((Enum)object).ordinal();
        Object object2 = object2.entries;
        Intrinsics.checkNotNullParameter(object2.entries, "<this>");
        object2 = n >= 0 && n <= ((Enum[])object2).length - 1 ? object2[n] : null;
        if (object2 != object) {
            n = -1;
        }
        return n;
    }

    @Override
    public final int lastIndexOf(Object object) {
        if (!(object instanceof Enum)) {
            return -1;
        }
        Enum enum_ = (Enum)object;
        Intrinsics.checkNotNullParameter(enum_, "element");
        return this.indexOf(enum_);
    }
}

