/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.org.objectweb.asm;

public final class ByteVector {
    public byte[] data;
    public int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n) {
        this.data = new byte[n];
    }

    public final ByteVector putByte(int n) {
        int n2 = this.length;
        int n3 = n2 + 1;
        if (n3 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n2] = (byte)n;
        this.length = n3;
        return this;
    }

    public final void put11(int n, int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        ByteVector byteVector = this;
        int n4 = n3 + 1;
        byteVector.data[n3] = (byte)n;
        n = n4 + 1;
        byteVector.data[n4] = (byte)n2;
        byteVector.length = n;
    }

    public final ByteVector putShort(int n) {
        int n2 = this.length;
        if (n2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        ByteVector byteVector = this;
        int n3 = n2 + 1;
        byteVector.data[n2] = (byte)(n >>> 8);
        n = n3 + 1;
        byteVector.data[n3] = (byte)n;
        byteVector.length = n;
        return byteVector;
    }

    public final ByteVector put12(int n, int n2) {
        int n3 = ((ByteVector)object).length;
        if (n3 + 3 > ((ByteVector)object).data.length) {
            ((ByteVector)object).enlarge(3);
        }
        ByteVector byteVector = object;
        Object object = byteVector.data;
        int n4 = n3 + 1;
        object[n3] = (byte)n;
        n = n4 + 1;
        object[n4] = (byte)(n2 >>> 8);
        n4 = n + 1;
        byteVector.data[n] = (byte)n2;
        byteVector.length = n4;
        return byteVector;
    }

    public final void put112(int n, int n2) {
        int n3 = 15;
        int n4 = ((ByteVector)object).length;
        if (n4 + 4 > ((ByteVector)object).data.length) {
            ((ByteVector)object).enlarge(4);
        }
        ByteVector byteVector = object;
        Object object = byteVector.data;
        int n5 = n;
        int n6 = n4 + 1;
        object[n4] = (byte)n3;
        n = n6 + 1;
        object[n6] = (byte)n5;
        n6 = n + 1;
        object[n] = (byte)(n2 >>> 8);
        n = n6 + 1;
        byteVector.data[n6] = (byte)n2;
        byteVector.length = n;
    }

    public final ByteVector putInt(int n) {
        int n2 = ((ByteVector)object).length;
        if (n2 + 4 > ((ByteVector)object).data.length) {
            ((ByteVector)object).enlarge(4);
        }
        ByteVector byteVector = object;
        Object object = byteVector.data;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n2 + 1;
        object[n2] = (byte)(n >>> 24);
        n = n6 + 1;
        object[n6] = (byte)(n5 >>> 16);
        n6 = n + 1;
        object[n] = (byte)(n4 >>> 8);
        n = n6 + 1;
        byteVector.data[n6] = (byte)n3;
        byteVector.length = n;
        return byteVector;
    }

    public final void put122(int n, int n2, int n3) {
        int n4 = ((ByteVector)object).length;
        if (n4 + 5 > ((ByteVector)object).data.length) {
            ((ByteVector)object).enlarge(5);
        }
        ByteVector byteVector = object;
        Object object = byteVector.data;
        int n5 = n4 + 1;
        object[n4] = (byte)n;
        n = n5 + 1;
        object[n5] = (byte)(n2 >>> 8);
        n5 = n + 1;
        object[n] = (byte)n2;
        n = n5 + 1;
        object[n5] = (byte)(n3 >>> 8);
        n5 = n + 1;
        byteVector.data[n] = (byte)n3;
        byteVector.length = n5;
    }

    public final ByteVector encodeUtf8(int n, int n2, String string) {
        int n3;
        int n4 = string.length();
        int n5 = n;
        for (n3 = n; n3 < n4; ++n3) {
            char c = string.charAt(n3);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n5;
                continue;
            }
            if (c <= '\u07ff') {
                n5 += 2;
                continue;
            }
            n5 += 3;
        }
        if (n5 <= n2) {
            n2 = this.length;
            n3 = n2 - n - 2;
            if (n3 >= 0) {
                this.data[n3] = (byte)(n5 >>> 8);
                this.data[++n3] = (byte)n5;
            }
            if (n2 + n5 - n > this.data.length) {
                this.enlarge(n5 - n);
            }
            n2 = this.length;
            while (n < n4) {
                char c = string.charAt(n);
                n3 = c;
                if (c >= '\u0001' && n3 <= 127) {
                    this.data[n2++] = (byte)n3;
                } else if (n3 <= 2047) {
                    this.data[n2++] = (byte)(n3 >> 6 & 0x1F | 0xC0);
                    n3 = n2 + 1;
                    this.data[n2] = (byte)(n3 & 0x3F | 0x80);
                    n2 = n3;
                } else {
                    byte[] byArray = this.data;
                    int n6 = n3;
                    int n7 = n3;
                    byArray[n2++] = (byte)(n3 >> 12 & 0xF | 0xE0);
                    n3 = n2 + 1;
                    byArray[n2] = (byte)(n7 >> 6 & 0x3F | 0x80);
                    n2 = n3 + 1;
                    this.data[n3] = (byte)(n6 & 0x3F | 0x80);
                }
                ++n;
            }
            this.length = n2;
            return this;
        }
        throw new IllegalArgumentException("UTF8 string too large");
    }

    public final ByteVector putByteArray(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.data.length) {
            this.enlarge(n2);
        }
        if (byArray != null) {
            byte[] byArray2 = byArray;
            ByteVector byteVector = this;
            byArray = byteVector.data;
            int n3 = byteVector.length;
            System.arraycopy(byArray2, n, byArray, n3, n2);
        }
        ByteVector byteVector = this;
        byteVector.length += n2;
        return byteVector;
    }

    public final void enlarge(int n) {
        int n2 = ((ByteVector)object).length;
        byte[] byArray = ((ByteVector)object).data;
        if (n2 <= ((ByteVector)object).data.length) {
            int n3 = byArray.length * 2;
            if (n3 <= (n = n2 + n)) {
                n3 = n;
            }
            ByteVector byteVector = object;
            Object object = new byte[n3];
            System.arraycopy(byArray, 0, object, 0, n2);
            byteVector.data = (byte[])object;
            return;
        }
        throw new AssertionError((Object)"Internal error");
    }
}

