/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.platform;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.BouncyCastlePlatform$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform$Companion;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public final class BouncyCastlePlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider = (Provider)new BouncyCastleJsseProvider();

    static {
        boolean bl;
        String string = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
        try {
            Class.forName(string, false, BouncyCastlePlatform$Companion.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        String string = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
        object = Intrinsics.stringPlus(string, "Unexpected default trust managers: ");
        throw new IllegalStateException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String stringArray, List list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (sSLSocket instanceof BCSSLSocket) {
            BouncyCastlePlatform bouncyCastlePlatform = (BCSSLSocket)sSLSocket;
            sSLSocket = bouncyCastlePlatform.getParameters();
            stringArray = Platform$Companion.alpnProtocolNames(list).toArray(new String[0]);
            if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            SSLSocket sSLSocket2 = sSLSocket;
            sSLSocket2.setApplicationProtocols(stringArray);
            bouncyCastlePlatform.setParameters((BCSSLParameters)sSLSocket2);
            return;
        } else {
            super.configureTlsExtensions(sSLSocket, (String)stringArray, list);
        }
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        if (!(sSLSocket instanceof BCSSLSocket) || ((object = ((BCSSLSocket)sSLSocket).getApplicationProtocol()) == null ? true : Intrinsics.areEqual(object, ""))) {
            Object object = null;
        }
        return object;
    }
}

