/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.Headers;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Stream$FramingSink;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Stream$FramingSource;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Stream$StreamTimeout;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;

public final class Http2Stream {
    public final int id;
    public final Http2Connection connection;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    public long writeBytesMaximum;
    public final ArrayDeque headersQueue;
    public boolean hasResponseHeaders;
    public final Http2Stream$FramingSource source;
    public final Http2Stream$FramingSink sink;
    public final Http2Stream$StreamTimeout readTimeout;
    public final Http2Stream$StreamTimeout writeTimeout;
    public ErrorCode errorCode;
    public IOException errorException;

    public final boolean closeInternal(ErrorCode errorCode, IOException iOException) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            block8: {
                block7: {
                    if (http2Stream.getErrorCode$okhttp() == null) break block7;
                    return false;
                }
                if (!this.source.getFinished$okhttp()) break block8;
                if (!this.sink.getFinished()) break block8;
                // ** MonitorExit[this] (shouldn't be in output)
                return false;
            }
            Http2Stream http2Stream2 = this;
            Http2Stream http2Stream3 = http2Stream2;
            Http2Stream http2Stream4 = http2Stream2;
            this.errorCode = errorCode;
            http2Stream2.errorException = iOException;
            http2Stream2.notifyAll();
            http2Stream4.connection.removeStream$okhttp(this.id);
            return true;
        }
    }

    public final int getId() {
        return this.id;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final void setReadBytesTotal$okhttp(long l) {
        this.readBytesTotal = l;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final void setReadBytesAcknowledged$okhttp(long l) {
        this.readBytesAcknowledged = l;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final void setWriteBytesTotal$okhttp(long l) {
        this.writeBytesTotal = l;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Http2Stream$FramingSink getSink$okhttp() {
        return this.sink;
    }

    public final Http2Stream$StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    public final Http2Stream$StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    public final synchronized ErrorCode getErrorCode$okhttp() {
        return this.errorCode;
    }

    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        Closeable closeable = this.source;
        if (closeable.finished || closeable.closed) {
            closeable = this.sink;
            if ((((Http2Stream$FramingSink)closeable).finished || ((Http2Stream$FramingSink)closeable).closed) && this.hasResponseHeaders) {
                return false;
            }
        }
        return true;
    }

    public final boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized Headers takeHeaders() {
        Object object;
        block4: {
            Object e;
            object.readTimeout.enter();
            try {
                while (object.headersQueue.isEmpty() && object.errorCode == null) {
                    object.waitForIo$okhttp();
                }
                Http2Stream http2Stream = object;
                http2Stream.readTimeout.exitAndThrowIfTimedOut();
                if (!(http2Stream.headersQueue.isEmpty() ^ true)) break block4;
                e = object.headersQueue.removeFirst();
            }
            catch (Throwable throwable) {
                object.readTimeout.exitAndThrowIfTimedOut();
                throw throwable;
            }
            Intrinsics.checkNotNullExpressionValue(e, "headersQueue.removeFirst()");
            return (Headers)e;
        }
        IOException iOException = object.errorException;
        if (iOException == null) {
            StreamResetException streamResetException;
            iOException = streamResetException;
            object = object.errorCode;
            Intrinsics.checkNotNull(object);
            streamResetException = new StreamResetException((ErrorCode)((Object)object));
        }
        throw iOException;
    }

    public final void close(ErrorCode errorCode, IOException iOException) {
        if (!this.closeInternal(errorCode, iOException)) {
            return;
        }
        Http2Connection http2Connection = this.connection;
        int n = this.id;
        http2Connection.getClass();
        http2Connection.writer.rstStream(n, errorCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, errorCode);
    }

    /*
     * Unable to fully structure code
     */
    public final void receiveHeaders(Headers var1_1, boolean var2_2) {
        Intrinsics.checkNotNullParameter(var1_1, "headers");
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        v0 = this;
        synchronized (v0) {
            block9: {
                block8: {
                    if (!v0.hasResponseHeaders || !var2_2) break block8;
                    this.source.getClass();
                    break block9;
                }
                this.hasResponseHeaders = true;
                this.headersQueue.add(var1_1);
            }
            if (!var2_2) ** GOTO lbl24
            this.source.setFinished$okhttp();
lbl24:
            // 2 sources

            v2 = this.isOpen();
            v3 = this;
            v4 = v3;
            v3.notifyAll();
            if (!v2) {
                this.connection.removeStream$okhttp(this.id);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelStreamIfNecessary$okhttp() {
        if (Util.assertionsEnabled) {
            if (Thread.holdsLock(this)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl = !http2Stream.source.getFinished$okhttp() && this.source.getClosed$okhttp() && (this.sink.getFinished() || this.sink.getClosed());
            Http2Stream http2Stream2 = this;
            Http2Stream http2Stream3 = http2Stream2;
            boolean bl2 = http2Stream2.isOpen();
            if (bl) {
                this.close(ErrorCode.CANCEL, null);
                return;
            }
            if (bl2) return;
            this.connection.removeStream$okhttp(this.id);
            return;
        }
    }

    public final void addBytesToWriteWindow(long l) {
        this.writeBytesMaximum += l;
        if (l > 0L) {
            this.notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() {
        Object object = object2.sink;
        if (!((Http2Stream$FramingSink)object).closed) {
            if (!((Http2Stream$FramingSink)object).finished) {
                if (object2.errorCode != null) {
                    object = object2.errorException;
                    if (object == null) {
                        StreamResetException streamResetException;
                        object = streamResetException;
                        Object object2 = object2.errorCode;
                        Intrinsics.checkNotNull(object2);
                        streamResetException = new StreamResetException((ErrorCode)((Object)object2));
                    }
                    throw object;
                }
                return;
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    public final void waitForIo$okhttp() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    public final Http2Stream$FramingSink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl;
            block9: {
                block8: {
                    if (http2Stream.hasResponseHeaders) break block8;
                    if (this.isLocallyInitiated()) break block8;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl) {
                Http2Stream http2Stream2 = this;
                Http2Stream http2Stream3 = http2Stream2;
                Http2Stream http2Stream4 = http2Stream2;
                return http2Stream4.sink;
            }
            String string = "reply before requesting the sink";
            throw new IllegalStateException(string.toString());
        }
    }

    public final synchronized void receiveRstStream() {
        ErrorCode errorCode = ErrorCode.REFUSED_STREAM;
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    public Http2Stream(int n, Http2Connection http2Connection, boolean bl, boolean bl2, Headers headers) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        ArrayDeque<Headers> arrayDeque;
                        Http2Stream http2Stream = this;
                        Intrinsics.checkNotNullParameter(http2Connection, "connection");
                        this.id = n;
                        this.connection = http2Connection;
                        http2Stream.writeBytesMaximum = http2Connection.getPeerSettings().getInitialWindowSize();
                        ArrayDeque<Headers> arrayDeque2 = arrayDeque;
                        http2Stream.headersQueue = new ArrayDeque<Headers>();
                        http2Stream.source = new Http2Stream$FramingSource(this, http2Connection.getOkHttpSettings().getInitialWindowSize(), bl2);
                        http2Stream.sink = new Http2Stream$FramingSink(this, bl);
                        http2Stream.readTimeout = new Http2Stream$StreamTimeout(this);
                        http2Stream.writeTimeout = new Http2Stream$StreamTimeout(this);
                        if (headers == null) break block2;
                        if (!(this.isLocallyInitiated() ^ true)) break block3;
                        arrayDeque2.add(headers);
                        break block4;
                    }
                    throw new IllegalStateException("locally-initiated streams shouldn't have headers yet".toString());
                }
                if (!this.isLocallyInitiated()) break block5;
            }
            return;
        }
        throw new IllegalStateException("remotely-initiated streams should have headers".toString());
    }
}

