/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Ref$IntRef;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$Builder;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$Listener;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$ReaderRunnable;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$pushHeadersLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$sendDegradedPingLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$special$$inlined$schedule$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$writeSynResetLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Reader;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Stream;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Writer;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.PushObserver$Companion$PushObserverCancel;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Settings;
import com.apollographql.apollo3.relocated.okio.Buffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    public static final Settings DEFAULT_SETTINGS;
    public final boolean client;
    public final Http2Connection$Listener listener;
    public final LinkedHashMap streams;
    public final String connectionName;
    public int lastGoodStreamId;
    public int nextStreamId;
    public boolean isShutdown;
    public final TaskRunner taskRunner;
    public final TaskQueue writerQueue;
    public final TaskQueue pushQueue;
    public final TaskQueue settingsListenerQueue;
    public final PushObserver$Companion$PushObserverCancel pushObserver;
    public long intervalPingsSent;
    public long intervalPongsReceived;
    public long degradedPingsSent;
    public long degradedPongsReceived;
    public long awaitPongsReceived;
    public long degradedPongDeadlineNs;
    public final Settings okHttpSettings;
    public Settings peerSettings;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    public long writeBytesMaximum;
    public final Socket socket;
    public final Http2Writer writer;
    public final Http2Connection$ReaderRunnable readerRunnable;
    public final LinkedHashSet currentPushRequests;

    public Http2Connection(Http2Connection$Builder object) {
        Http2Reader http2Reader;
        Settings settings;
        TaskQueue taskQueue;
        String string;
        boolean bl;
        Http2Connection http2Connection = this;
        this.client = bl = ((Http2Connection$Builder)object).getClient$okhttp();
        http2Connection.listener = ((Http2Connection$Builder)object).getListener$okhttp();
        http2Connection.streams = new LinkedHashMap();
        this.connectionName = string = ((Http2Connection$Builder)object).getConnectionName$okhttp();
        int n = ((Http2Connection$Builder)object).getClient$okhttp() ? 3 : 2;
        Http2Connection http2Connection2 = this;
        this.nextStreamId = n;
        Object object2 = ((Http2Connection$Builder)object).getTaskRunner$okhttp();
        this.taskRunner = object2;
        http2Connection2.writerQueue = taskQueue = ((TaskRunner)object2).newQueue();
        http2Connection2.pushQueue = ((TaskRunner)object2).newQueue();
        http2Connection2.settingsListenerQueue = ((TaskRunner)object2).newQueue();
        this.pushObserver = ((Http2Connection$Builder)object).getPushObserver$okhttp();
        object2 = settings;
        settings = new Settings();
        if (((Http2Connection$Builder)object).getClient$okhttp()) {
            ((Settings)object2).set(7, 0x1000000);
        }
        Http2Connection http2Connection3 = this;
        Http2Connection http2Connection4 = this;
        http2Connection4.okHttpSettings = object2;
        object2 = DEFAULT_SETTINGS;
        http2Connection4.peerSettings = object2;
        http2Connection4.writeBytesMaximum = ((Settings)object2).getInitialWindowSize();
        http2Connection3.socket = ((Http2Connection$Builder)object).getSocket$okhttp();
        http2Connection3.writer = new Http2Writer(((Http2Connection$Builder)object).getSink$okhttp(), bl);
        object2 = http2Reader;
        http2Reader = new Http2Reader(((Http2Connection$Builder)object).getSource$okhttp(), bl);
        http2Connection3.readerRunnable = new Http2Connection$ReaderRunnable(this, (Http2Reader)object2);
        http2Connection3.currentPushRequests = new LinkedHashSet();
        if (((Http2Connection$Builder)object).getPingIntervalMillis$okhttp() != 0) {
            long l = TimeUnit.MILLISECONDS.toNanos(((Http2Connection$Builder)object).getPingIntervalMillis$okhttp());
            object = Intrinsics.stringPlus(" ping", string);
            taskQueue.schedule(new Http2Connection$special$$inlined$schedule$1((String)object, this, l), l);
        }
    }

    public static final /* synthetic */ TaskQueue access$getWriterQueue$p(Http2Connection http2Connection) {
        return http2Connection.writerQueue;
    }

    public static final /* synthetic */ boolean access$isShutdown$p(Http2Connection http2Connection) {
        return http2Connection.isShutdown;
    }

    public static final /* synthetic */ TaskRunner access$getTaskRunner$p(Http2Connection http2Connection) {
        return http2Connection.taskRunner;
    }

    public static final /* synthetic */ TaskQueue access$getSettingsListenerQueue$p(Http2Connection http2Connection) {
        return http2Connection.settingsListenerQueue;
    }

    public static final void access$failConnection(Http2Connection http2Connection, IOException iOException) {
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        http2Connection.close$okhttp(errorCode, errorCode, iOException);
    }

    public static final /* synthetic */ long access$getIntervalPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.intervalPongsReceived;
    }

    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.intervalPongsReceived = l;
    }

    public static final /* synthetic */ long access$getDegradedPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.degradedPongsReceived;
    }

    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.degradedPongsReceived = l;
    }

    public static final /* synthetic */ long access$getAwaitPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.awaitPongsReceived;
    }

    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.awaitPongsReceived = l;
    }

    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection http2Connection, long l) {
        http2Connection.writeBytesMaximum = l;
    }

    static {
        Settings settings = new Settings();
        settings.set(7, 65535);
        settings.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public static final /* synthetic */ void access$setShutdown$p(Http2Connection http2Connection) {
        http2Connection.isShutdown = true;
    }

    public static final /* synthetic */ LinkedHashSet access$getCurrentPushRequests$p(Http2Connection http2Connection) {
        return http2Connection.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver$Companion$PushObserverCancel access$getPushObserver$p(Http2Connection http2Connection) {
        return http2Connection.pushObserver;
    }

    public static boolean pushedStream$okhttp(int n) {
        return n != 0 && (n & 1) == 0;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "<set-?>");
        this.peerSettings = settings;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    public final synchronized Http2Stream getStream(int n) {
        return (Http2Stream)this.streams.get(n);
    }

    public final synchronized Http2Stream removeStream$okhttp(int n) {
        Http2Stream http2Stream = (Http2Stream)this.streams.remove(n);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long l) {
        this.readBytesTotal = l = this.readBytesTotal + l;
        if ((l -= this.readBytesAcknowledged) >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            Http2Connection http2Connection = this;
            http2Connection.writeWindowUpdateLater$okhttp(0, l);
            http2Connection.readBytesAcknowledged += l;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void writeData(int n, boolean bl, Buffer buffer, long l) {
        if (l == 0L) {
            this.writer.data(bl, n, buffer, 0);
            return;
        }
        while (l > 0L) {
            long l2;
            long l3;
            // MONITORENTER : this
            while ((l3 = this.writeBytesTotal) >= (l2 = this.writeBytesMaximum)) {
                if (!this.streams.containsKey(n)) throw new IOException("stream closed");
                this.wait();
            }
            Http2Connection http2Connection = this;
            int n2 = Math.min((int)Math.min(l, l2 - l3), this.writer.maxDataLength());
            long l4 = http2Connection.writeBytesTotal;
            l3 = n2;
            http2Connection.writeBytesTotal = l4 + l3;
            l3 = l - l3;
            Http2Writer http2Writer = this.writer;
            boolean bl2 = bl && l3 == 0L;
            http2Writer.data(bl2, n, buffer, n2);
            l = l3;
        }
        return;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (InterruptedException interruptedException) {}
            {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    public final void writeSynResetLater$okhttp(int n, ErrorCode errorCode) {
        String string = this.connectionName + '[' + n + "] writeSynReset";
        this.writerQueue.schedule(new Http2Connection$writeSynResetLater$$inlined$execute$default$1(string, this, n, errorCode), 0L);
    }

    public final void writeWindowUpdateLater$okhttp(int n, long l) {
        String string = this.connectionName + '[' + n + "] windowUpdate";
        this.writerQueue.schedule(new Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1(string, this, n, l), 0L);
    }

    public final void flush() {
        this.writer.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown(ErrorCode errorCode) {
        Http2Connection http2Connection = this;
        Http2Writer http2Writer = http2Connection.writer;
        synchronized (http2Writer) {
            Ref$IntRef ref$IntRef;
            Ref$IntRef ref$IntRef2 = ref$IntRef;
            ref$IntRef = new Ref$IntRef();
            synchronized (http2Connection) {
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    Http2Connection http2Connection2;
                    block11: {
                        if (!http2Connection.isShutdown) break block11;
                        {
                            // ** MonitorExit[this] (shouldn't be in output)
                            return;
                        }
                    }
                    try {
                        Http2Writer http2Writer2 = http2Writer;
                        Http2Connection http2Connection3 = this;
                        Http2Connection http2Connection4 = http2Connection3;
                        http2Connection2 = http2Connection3;
                        this.isShutdown = true;
                        ref$IntRef2.element = this.lastGoodStreamId;
                    }
                    catch (Throwable throwable) {}
                    {
                        // ** MonitorExit[this] (shouldn't be in output)
                        throw throwable;
                    }
                    {
                        // ** MonitorExit[v5] (shouldn't be in output)
                        http2Connection2.writer.goAway(ref$IntRef2.element, errorCode, Util.EMPTY_BYTE_ARRAY);
                    }
                    // ** MonitorExit[v3] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close$okhttp(ErrorCode http2StreamArray, ErrorCode errorCode, IOException iOException) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        try {
            this.shutdown((ErrorCode)http2StreamArray);
        }
        catch (IOException iOException2) {}
        Http2Connection http2Connection = this;
        http2StreamArray = null;
        synchronized (http2Connection) {
            block18: {
                if (http2Connection.streams.isEmpty() ^ true) {
                    http2StreamArray = this.streams.values().toArray(new Http2Stream[0]);
                    if (http2StreamArray != null) {
                        this.streams.clear();
                    } else {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                }
                Http2Stream[] http2StreamArray2 = http2StreamArray;
                Http2Connection http2Connection2 = this;
                http2StreamArray = http2StreamArray2;
                if (http2StreamArray2 == null) break block18;
                int n = http2StreamArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        http2StreamArray[i].close(errorCode, iOException);
                        continue;
                    }
                    catch (IOException iOException3) {}
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException4) {}
            try {
                this.socket.close();
            }
            catch (IOException iOException5) {}
            Http2Connection http2Connection3 = this;
            http2Connection3.writerQueue.shutdown();
            http2Connection3.pushQueue.shutdown();
            http2Connection3.settingsListenerQueue.shutdown();
            return;
        }
    }

    public final synchronized boolean isHealthy(long l) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l < this.degradedPongDeadlineNs;
    }

    public final void sendDegradedPingLater$okhttp() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l;
            block5: {
                l = this.degradedPingsSent;
                if (http2Connection.degradedPongsReceived >= l) break block5;
                return;
            }
            Http2Connection http2Connection2 = this;
            http2Connection2.degradedPingsSent = l + 1L;
            long l2 = System.nanoTime();
            http2Connection2.degradedPongDeadlineNs = l2 + (long)1000000000;
            String string = Intrinsics.stringPlus(" ping", this.connectionName);
            http2Connection2.writerQueue.schedule(new Http2Connection$sendDegradedPingLater$$inlined$execute$default$1(string, this), 0L);
            return;
        }
    }

    public final void pushHeadersLater$okhttp(int n, List list, boolean bl) {
        String string = this.connectionName + '[' + n + "] onHeaders";
        this.pushQueue.schedule(new Http2Connection$pushHeadersLater$$inlined$execute$default$1(string, this, n, list, bl), 0L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Http2Stream newStream(ArrayList arrayList, boolean bl) {
        Http2Connection http2Connection = this;
        boolean bl2 = bl ^ true;
        boolean bl3 = false;
        Http2Writer http2Writer = http2Connection.writer;
        synchronized (http2Writer) {
            synchronized (http2Connection) {
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    block14: {
                        Http2Connection http2Connection2;
                        boolean bl4;
                        Http2Stream http2Stream;
                        block15: {
                            Http2Stream http2Stream2;
                            if (http2Connection.nextStreamId > 0x3FFFFFFF) {
                                this.shutdown(ErrorCode.REFUSED_STREAM);
                            }
                            if (this.isShutdown) break block14;
                            boolean bl5 = bl;
                            bl = this.nextStreamId;
                            this.nextStreamId = bl + 2;
                            http2Stream = http2Stream2;
                            http2Stream2 = new Http2Stream(bl ? 1 : 0, this, bl2, bl3, null);
                            bl3 = !bl5 || this.writeBytesTotal >= this.writeBytesMaximum || http2Stream.getWriteBytesTotal() >= http2Stream.getWriteBytesMaximum();
                            if (!http2Stream.isOpen()) break block15;
                            this.streams.put(bl ? 1 : 0, http2Stream);
                        }
                        try {
                            bl4 = bl3;
                            Http2Writer http2Writer2 = http2Writer;
                            Http2Connection http2Connection3 = this;
                            Http2Connection http2Connection4 = http2Connection3;
                            http2Connection2 = http2Connection3;
                        }
                        catch (Throwable throwable) {}
                        {
                            // ** MonitorExit[this] (shouldn't be in output)
                            throw throwable;
                        }
                        {
                            // ** MonitorExit[v6] (shouldn't be in output)
                            http2Connection2.writer.headers(bl ? 1 : 0, arrayList, bl2);
                        }
                        // ** MonitorExit[v4] (shouldn't be in output)
                        if (bl4) {
                            this.writer.flush();
                        }
                        return http2Stream;
                    }
                    throw new ConnectionShutdownException();
                }
            }
        }
    }

    public final LinkedHashMap getStreams$okhttp() {
        return this.streams;
    }
}

