/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.gradle.internal.ApolloPlugin;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.tooling.SchemaDownloader;
import com.apollographql.apollo3.relocated.kotlin.Pair;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.apollo3.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo3.relocated.kotlin.collections.MapsKt___MapsJvmKt;
import com.apollographql.apollo3.relocated.kotlin.io.FilesKt__UtilsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.functions.Function1;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt___StringsJvmKt;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0007J\u001e\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050(*\b\u0012\u0004\u0012\u00020\u00050\rH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0014\u0010\u0018\u001a\u00020\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloDownloadSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "graph", "getGraph", "graphVariant", "getGraphVariant", "<set-?>", "", "header", "getHeader", "()Ljava/util/List;", "setHeader", "(Ljava/util/List;)V", "insecure", "", "getInsecure", "key", "getKey", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "projectRootDir", "getProjectRootDir", "()Ljava/lang/String;", "setProjectRootDir", "(Ljava/lang/String;)V", "registryUrl", "getRegistryUrl", "schema", "getSchema", "taskAction", "", "toMap", "", "apollo-gradle-plugin-external"})
public abstract class ApolloDownloadSchemaTask
extends DefaultTask {
    private List<String> header;

    public ApolloDownloadSchemaTask() {
        ApolloDownloadSchemaTask apolloDownloadSchemaTask = this;
        apolloDownloadSchemaTask.header = EmptyList.INSTANCE;
        apolloDownloadSchemaTask.getOutputs().upToDateWhen(arg_0 -> ApolloDownloadSchemaTask._init_$lambda$0(1.INSTANCE, arg_0));
        apolloDownloadSchemaTask.getOutputs().cacheIf(arg_0 -> ApolloDownloadSchemaTask._init_$lambda$1(2.INSTANCE, arg_0));
    }

    private final Map<String, String> toMap(List<String> object) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(CollectionsKt__IterablesKt.collectionSizeOrDefault(object));
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n = StringsKt___StringsJvmKt.indexOf$default((CharSequence)string, ':', 0, false, 6);
            if (n > 0 && n < string.length() - 1) {
                String string2 = string;
                String string3 = string2.substring(0, n);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                string = ((Object)StringsKt___StringsJvmKt.trim(string3)).toString();
                String string4 = string2.substring(++n, string2.length());
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                String string5 = ((Object)StringsKt___StringsJvmKt.trim(string4)).toString();
                arrayList2.add(new Pair(string, string5));
                continue;
            }
            throw new IllegalStateException("header should be in the form 'Name: Value'".toString());
        }
        return MapsKt___MapsJvmKt.toMap(arrayList2);
    }

    private static final boolean _init_$lambda$0(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter(function1, "$tmp0");
        return (Boolean)function1.invoke(object);
    }

    private static final boolean _init_$lambda$1(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter(function1, "$tmp0");
        return (Boolean)function1.invoke(object);
    }

    @Optional
    @Input
    @Option(option="endpoint", description="url of the GraphQL endpoint for introspection.")
    public abstract Property<String> getEndpoint();

    @Optional
    @Input
    @Option(option="graph", description="[Apollo Studio users only] The identifier of the Apollo graph used to download the schema.")
    public abstract Property<String> getGraph();

    @Optional
    @Input
    @Option(option="key", description="[Apollo Studio users only] The Apollo API key. See https://www.apollographql.com/docs/studio/api-keys/ for more information on how to get your API key.")
    public abstract Property<String> getKey();

    @Optional
    @Input
    @Option(option="graphVariant", description="[Apollo Studio users only] The variant of the Apollo graph used to download the schema.")
    public abstract Property<String> getGraphVariant();

    @Optional
    @Input
    @Option(option="registryUrl", description="[Apollo Studio users only] The registry url of the registry instance used to download the schema. Defaults to \"https://graphql.api.apollographql.com/api/graphql\"")
    public abstract Property<String> getRegistryUrl();

    @Input
    @Optional
    @Option(option="schema", description="path where the schema will be downloaded, relative to the root project directory")
    public abstract Property<String> getSchema();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getOutputFile();

    @Internal
    public abstract String getProjectRootDir();

    public abstract void setProjectRootDir(String var1);

    @Optional
    @Input
    public final List<String> getHeader() {
        return this.header;
    }

    @Option(option="header", description="HTTP headers in the form 'Name: Value'")
    public final void setHeader(List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.header = list;
    }

    @Optional
    @Input
    @Option(option="insecure", description="if set to true, TLS/SSL certificates will not be checked when downloading")
    public abstract Property<Boolean> getInsecure();

    @TaskAction
    public final void taskAction() {
        block4: {
            File file;
            block3: {
                block2: {
                    if (!object.getOutputFile().isPresent()) break block2;
                    file = (File)object.getOutputFile().getAsFile().get();
                    break block3;
                }
                if (!object.getSchema().isPresent()) break block4;
                File file2 = new File(object.getProjectRootDir());
                Object object = object.getSchema().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                file = FilesKt__UtilsKt.resolve(file2, (String)object);
            }
            String string = (String)object.getEndpoint().getOrNull();
            String string2 = (String)object.getGraph().getOrNull();
            ApolloDownloadSchemaTask apolloDownloadSchemaTask = object;
            String string3 = (String)apolloDownloadSchemaTask.getGraphVariant().getOrElse((Object)"current");
            String string4 = (String)apolloDownloadSchemaTask.getKey().getOrNull();
            String string5 = (String)apolloDownloadSchemaTask.getRegistryUrl().getOrElse((Object)"https://api.apollographql.com/graphql");
            Boolean bl = (Boolean)apolloDownloadSchemaTask.getInsecure().getOrElse((Object)Boolean.FALSE);
            ApolloDownloadSchemaTask apolloDownloadSchemaTask2 = object;
            Object object = MapsKt___MapsJvmKt.plus(apolloDownloadSchemaTask2.toMap(apolloDownloadSchemaTask2.header), ApolloPlugin.Companion.getExtraHeaders$apollo_gradle_plugin_external());
            Intrinsics.checkNotNull(string3);
            Intrinsics.checkNotNull(string5);
            Intrinsics.checkNotNull(file);
            Intrinsics.checkNotNull(bl);
            boolean bl2 = bl;
            SchemaDownloader.download(string, string2, string4, string3, string5, file, bl2, (LinkedHashMap)object);
            return;
        }
        throw new IllegalStateException("--schema is mandatory".toString());
    }
}

