/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.kotlinx.serialization.internal;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Reflection;
import com.apollographql.apollo3.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo3.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo3.relocated.kotlinx.serialization.encoding.Decoder;
import com.apollographql.apollo3.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo3.relocated.kotlinx.serialization.internal.SerialDescriptorForNullable;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.Composer;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.JsonToStringWriter;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.StreamingJsonEncoder;

public final class NullableSerializer
implements KSerializer {
    public final KSerializer serializer;
    public final SerialDescriptorForNullable descriptor;

    public NullableSerializer(KSerializer kSerializer) {
        NullableSerializer nullableSerializer = this;
        Intrinsics.checkNotNullParameter(kSerializer, "serializer");
        nullableSerializer.serializer = kSerializer;
        nullableSerializer.descriptor = new SerialDescriptorForNullable(kSerializer.getDescriptor());
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(Encoder encoder, Object object) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        if (object != null) {
            KSerializer kSerializer = kSerializer.serializer;
            ((StreamingJsonEncoder)encoder).encodeSerializableValue(kSerializer, object);
        } else {
            Composer composer = ((StreamingJsonEncoder)encoder).composer;
            composer.getClass();
            ((JsonToStringWriter)composer.writer).write("null");
        }
    }

    @Override
    public final Object deserialize(Decoder decoder) {
        Object object;
        Decoder decoder2 = decoder;
        Intrinsics.checkNotNullParameter(decoder2, "decoder");
        if (decoder2.decodeNotNullMark()) {
            object = decoder.decodeSerializableValue$1(this.serializer);
        } else {
            decoder.decodeNull();
            object = null;
        }
        return object;
    }

    public final boolean equals(Object object) {
        if (nullableSerializer2 == object) {
            return true;
        }
        if (object != null && Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(NullableSerializer.class), Reflection.getOrCreateKotlinClass(object.getClass()))) {
            NullableSerializer nullableSerializer = nullableSerializer2;
            NullableSerializer nullableSerializer2 = (NullableSerializer)object;
            return Intrinsics.areEqual(nullableSerializer.serializer, nullableSerializer2.serializer);
        }
        return false;
    }

    public final int hashCode() {
        return this.serializer.hashCode();
    }
}

