/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero0;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero1;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo3.relocated.okhttp3.Headers;
import com.apollographql.apollo3.relocated.okhttp3.Headers$Builder;
import com.apollographql.apollo3.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo3.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo3.relocated.okhttp3.Protocol;
import com.apollographql.apollo3.relocated.okhttp3.Request;
import com.apollographql.apollo3.relocated.okhttp3.Response;
import com.apollographql.apollo3.relocated.okhttp3.Response$Builder;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.HttpHeaders;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.StatusLine$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Stream;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Writer;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import com.apollographql.apollo3.relocated.okio.ByteString;
import com.apollographql.apollo3.relocated.okio.Sink;
import com.apollographql.apollo3.relocated.okio.Source;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final List HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    public static final List HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    public volatile Http2Stream stream;
    public final Protocol protocol;
    public volatile boolean canceled;
    public final RealConnection connection;
    public final RealInterceptorChain chain;
    public final Http2Connection http2Connection;

    public Http2ExchangeCodec(OkHttpClient object, RealConnection realConnection, RealInterceptorChain realInterceptorChain, Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        this.connection = realConnection;
        this.chain = realInterceptorChain;
        this.http2Connection = http2Connection;
        List list = object.protocols();
        object = Protocol.H2_PRIOR_KNOWLEDGE;
        if (!list.contains(object)) {
            object = Protocol.HTTP_2;
        }
        this.protocol = object;
    }

    @Override
    public final Sink createRequestBody(Request request, long l) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) {
        int n;
        ArrayList<Object> arrayList;
        if (((Http2ExchangeCodec)((Object)http2Stream)).stream != null) {
            return;
        }
        boolean bl = ((Request)object).body != null;
        Request request = object;
        Headers headers = request.headers;
        ArrayList<Object> arrayList2 = arrayList;
        Object object2 = Header.TARGET_METHOD;
        new ArrayList<Object>(headers.size() + 4).add(new Header(((Request)object).method, (ByteString)object2));
        Object object3 = Header.TARGET_PATH;
        HttpUrl httpUrl = request.url;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Object object4 = httpUrl.encodedPath();
        String string = httpUrl.encodedQuery();
        if (string != null) {
            object4 = (String)object4 + '?' + string;
        }
        Object object5 = object2;
        ((Header)object5)((String)object4, (ByteString)object3);
        arrayList2.add(object5);
        object2 = ((Request)object).headers.get("Host");
        if (object2 != null) {
            Header header;
            object3 = header;
            header = new Header((String)object2, Header.TARGET_AUTHORITY);
            arrayList2.add(object3);
        }
        Request request2 = object;
        object = Header.TARGET_SCHEME;
        arrayList2.add(new Header(request2.url.scheme, (ByteString)object));
        int n2 = headers.size();
        for (n = 0; n < n2; ++n) {
            object3 = headers.name(n);
            object4 = Locale.US;
            Intrinsics.checkNotNullExpressionValue(object4, "Locale.US");
            if (object3 != null) {
                Header header;
                object3 = ((String)object3).toLowerCase((Locale)object4);
                Intrinsics.checkNotNullExpressionValue(object3, "(this as java.lang.String).toLowerCase(locale)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(object3) && (!Intrinsics.areEqual(object3, "te") || !Intrinsics.areEqual(headers.value(n), "trailers"))) continue;
                object4 = header;
                header = new Header((String)object3, headers.value(n));
                arrayList2.add(object4);
                continue;
            }
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        Http2ExchangeCodec http2ExchangeCodec = http2Stream;
        Http2Connection http2Connection = http2ExchangeCodec.http2Connection;
        http2Connection.getClass();
        http2ExchangeCodec.stream = http2Connection.newStream(arrayList2, bl);
        if (!http2ExchangeCodec.canceled) {
            Http2ExchangeCodec http2ExchangeCodec2 = http2Stream;
            Http2Stream http2Stream = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream);
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            http2Stream.readTimeout.timeout(((Http2ExchangeCodec)((Object)http2Stream)).chain.readTimeoutMillis, timeUnit);
            Http2Stream http2Stream2 = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream2);
            http2Stream2.writeTimeout.timeout(((Http2ExchangeCodec)((Object)http2Stream)).chain.writeTimeoutMillis, timeUnit);
            return;
        }
        Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
        Intrinsics.checkNotNull(http2Stream);
        n = 9;
        Intrinsics$$ExternalSyntheticCheckNotZero0.m(9, "errorCode");
        if (http2Stream.closeInternal$enumunboxing$(9, null)) {
            http2Stream.connection.writeSynResetLater$okhttp$enumunboxing$(http2Stream.id, n);
        }
        throw new IOException("Canceled");
    }

    @Override
    public final void flushRequest() {
        Http2Writer http2Writer = ((Http2ExchangeCodec)((Object)http2Writer)).http2Connection.writer;
        synchronized (http2Writer) {
            block5: {
                if (http2Writer.closed) break block5;
                Http2Writer http2Writer2 = http2Writer;
                http2Writer2.sink.flush();
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
            throw new IOException("closed");
        }
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.getSink().close();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final Response$Builder readResponseHeaders(boolean var1_2) {
        var2_3 = this.stream;
        Intrinsics.checkNotNull(var2_3);
        synchronized (var2_3) {
            var2_3.readTimeout.enter();
            while (true) {
                if (!var2_3.headersQueue.isEmpty()) break;
                {
                    catch (Throwable var0_1) {
                        ** GOTO lbl80
                    }
                }
                if (var2_3.errorCode != 0) break;
                try {
                    var2_3.wait();
                }
                catch (InterruptedException v0) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            v1 = var2_3;
            v1.readTimeout.exitAndThrowIfTimedOut();
            if (!(v1.headersQueue.isEmpty() ^ true)) ** break block21
            v2 = var2_3.headersQueue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(v2, "headersQueue.removeFirst()");
            var3_4 = (Headers)v2;
        }
        this = this.protocol;
        Intrinsics.checkNotNullParameter(this, "protocol");
        var2_3 = null;
        var4_5 = v3;
        v3 = new ArrayList<String>(20);
        var6_7 = var3_4.size();
        for (var5_6 = 0; var5_6 < var6_7; ++var5_6) {
            var7_8 = var3_4.name(var5_6);
            var8_9 = var3_4.value(var5_6);
            if (Intrinsics.areEqual(var7_8, ":status")) {
                var2_3 = StatusLine$Companion.parse("HTTP/1.1 " + var8_9);
                continue;
            }
            if (Http2ExchangeCodec.HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(var7_8)) continue;
            Intrinsics.checkNotNullParameter(var7_8, "name");
            Intrinsics.checkNotNullParameter(var8_9, "value");
            var4_5.add(var7_8);
            var4_5.add(StringsKt__StringsKt.trim(var8_9).toString());
        }
        if (var2_3 != null) {
            var3_4 = v4;
            var3_4();
            var3_4.protocol = this;
            var3_4.code = var2_3.code;
            v5 = var2_3.message;
            Intrinsics.checkNotNullParameter(v5, "message");
            v4.message = v5;
            this = var4_5.toArray(new String[0]);
            if (this != null) {
                v6 = new Headers$Builder();
                CollectionsKt__MutableCollectionsKt.addAll(v6.namesAndValues, this);
                var3_4.headers = v6;
                if (var1_2 && var3_4.code == 100) {
                    var3_4 = null;
                }
                return var3_4;
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        throw new ProtocolException("Expected ':status' header not present");
        {
            this = var2_3.errorException;
            if (this != null) ** GOTO lbl79
            this = v8;
            var1_2 = var2_3.errorCode;
            Intrinsics$$ExternalSyntheticCheckNotZero1.m((int)var1_2);
            v8 = new StreamResetException((int)var1_2);
lbl79:
            // 2 sources

            throw this;
lbl80:
            // 1 sources

            var2_3.readTimeout.exitAndThrowIfTimedOut();
            throw var0_1;
        }
    }

    @Override
    public final long reportedContentLength(Response response) {
        return !HttpHeaders.promisesBody(response) ? 0L : Util.headersContentLength(response);
    }

    @Override
    public final Source openResponseBodySource(Response response) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.source;
    }

    @Override
    public final void cancel() {
        ((Http2ExchangeCodec)((Object)http2Stream)).canceled = true;
        Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
        if (http2Stream != null) {
            int n = 9;
            Intrinsics$$ExternalSyntheticCheckNotZero0.m(9, "errorCode");
            if (http2Stream.closeInternal$enumunboxing$(9, null)) {
                http2Stream.connection.writeSynResetLater$okhttp$enumunboxing$(http2Stream.id, n);
            }
        }
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }
}

