/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.CipherSuite;
import com.apollographql.apollo3.relocated.okhttp3.ConnectionSpec;
import com.apollographql.apollo3.relocated.okhttp3.TlsVersion;
import java.util.ArrayList;
import java.util.Arrays;

public final class ConnectionSpec$Builder {
    public final boolean tls;
    public String[] cipherSuites;
    public String[] tlsVersions;
    public boolean supportsTlsExtensions;

    public ConnectionSpec$Builder() {
        this.tls = true;
    }

    public ConnectionSpec$Builder(ConnectionSpec connectionSpec) {
        this.tls = connectionSpec.isTls();
        this.cipherSuites = ConnectionSpec.access$getCipherSuitesAsString$p(connectionSpec);
        this.tlsVersions = ConnectionSpec.access$getTlsVersionsAsString$p(connectionSpec);
        this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions();
    }

    public final ConnectionSpec$Builder cipherSuites(CipherSuite ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "cipherSuites");
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName);
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.cipherSuites(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder cipherSuites(String ... object) {
        Intrinsics.checkNotNullParameter(object, "cipherSuites");
        if (this.tls) {
            boolean bl = ((String[])object).length == 0;
            if (bl ^ true) {
                if ((object = object.clone()) != null) {
                    this.cipherSuites = object;
                    return this;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            }
            throw new IllegalArgumentException("At least one cipher suite is required".toString());
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(TlsVersion ... objectArray) {
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName);
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.tlsVersions(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(String ... object) {
        Intrinsics.checkNotNullParameter(object, "tlsVersions");
        if (this.tls) {
            boolean bl = ((String[])object).length == 0;
            if (bl ^ true) {
                if ((object = object.clone()) != null) {
                    this.tlsVersions = object;
                    return this;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            }
            throw new IllegalArgumentException("At least one TLS version is required".toString());
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }
}

