/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.number;

import com.ibm.icu.impl.number.AffixPatternProvider;
import com.ibm.icu.impl.number.CurrencyPluralInfoAffixProvider;
import com.ibm.icu.impl.number.CustomSymbolCurrency;
import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.Grouper;
import com.ibm.icu.impl.number.MacroProps;
import com.ibm.icu.impl.number.MultiplierImpl;
import com.ibm.icu.impl.number.Padder;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import com.ibm.icu.impl.number.RoundingUtils;
import com.ibm.icu.number.CompactNotation;
import com.ibm.icu.number.CurrencyRounder;
import com.ibm.icu.number.FractionRounder;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Rounder;
import com.ibm.icu.number.ScientificNotation;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.MathContext;

final class NumberPropertyMapper {
    NumberPropertyMapper() {
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties properties2, DecimalFormatSymbols symbols) {
        MacroProps macros = NumberPropertyMapper.oldToNew(properties2, symbols, null);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macros);
    }

    public static UnlocalizedNumberFormatter create(String pattern, DecimalFormatSymbols symbols) {
        DecimalFormatProperties properties2 = PatternStringParser.parseToProperties(pattern);
        return NumberPropertyMapper.create(properties2, symbols);
    }

    public static MacroProps oldToNew(DecimalFormatProperties properties2, DecimalFormatSymbols symbols, DecimalFormatProperties exportedProperties) {
        boolean explicitMinMaxSig;
        boolean explicitCurrencyUsage;
        MacroProps macros = new MacroProps();
        ULocale locale = symbols.getULocale();
        macros.symbols = symbols;
        macros.rules = properties2.getPluralRules();
        AffixPatternProvider affixProvider = properties2.getCurrencyPluralInfo() == null ? new PropertiesAffixPatternProvider(properties2) : new CurrencyPluralInfoAffixProvider(properties2.getCurrencyPluralInfo());
        macros.affixProvider = affixProvider;
        boolean useCurrency = properties2.getCurrency() != null || properties2.getCurrencyPluralInfo() != null || properties2.getCurrencyUsage() != null || affixProvider.hasCurrencySign();
        Currency currency = CustomSymbolCurrency.resolve(properties2.getCurrency(), locale, symbols);
        Currency.CurrencyUsage currencyUsage = properties2.getCurrencyUsage();
        boolean bl = explicitCurrencyUsage = currencyUsage != null;
        if (!explicitCurrencyUsage) {
            currencyUsage = Currency.CurrencyUsage.STANDARD;
        }
        if (useCurrency) {
            macros.unit = currency;
        }
        int maxInt = properties2.getMaximumIntegerDigits();
        int minInt = properties2.getMinimumIntegerDigits();
        int maxFrac = properties2.getMaximumFractionDigits();
        int minFrac = properties2.getMinimumFractionDigits();
        int minSig = properties2.getMinimumSignificantDigits();
        int maxSig = properties2.getMaximumSignificantDigits();
        BigDecimal roundingIncrement = properties2.getRoundingIncrement();
        MathContext mathContext = RoundingUtils.getMathContextOrUnlimited(properties2);
        boolean explicitMinMaxFrac = minFrac != -1 || maxFrac != -1;
        boolean bl2 = explicitMinMaxSig = minSig != -1 || maxSig != -1;
        if (useCurrency) {
            if (minFrac == -1 && maxFrac == -1) {
                minFrac = currency.getDefaultFractionDigits(currencyUsage);
                maxFrac = currency.getDefaultFractionDigits(currencyUsage);
            } else if (minFrac == -1) {
                minFrac = Math.min(maxFrac, currency.getDefaultFractionDigits(currencyUsage));
            } else if (maxFrac == -1) {
                maxFrac = Math.max(minFrac, currency.getDefaultFractionDigits(currencyUsage));
            }
        }
        if (minInt == 0 && maxFrac != 0) {
            int n = minFrac = minFrac <= 0 ? 1 : minFrac;
            maxFrac = maxFrac < 0 ? Integer.MAX_VALUE : (maxFrac < minFrac ? minFrac : maxFrac);
            minInt = 0;
            maxInt = maxInt < 0 ? -1 : (maxInt > 999 ? -1 : maxInt);
        } else {
            int n = minFrac = minFrac < 0 ? 0 : minFrac;
            int n2 = maxFrac < 0 ? Integer.MAX_VALUE : (maxFrac = maxFrac < minFrac ? minFrac : maxFrac);
            int n3 = minInt <= 0 ? 1 : (minInt = minInt > 999 ? 1 : minInt);
            maxInt = maxInt < 0 ? -1 : (maxInt < minInt ? minInt : (maxInt > 999 ? -1 : maxInt));
        }
        Rounder rounding = null;
        if (explicitCurrencyUsage) {
            rounding = Rounder.constructCurrency(currencyUsage).withCurrency(currency);
        } else if (roundingIncrement != null) {
            rounding = Rounder.constructIncrement(roundingIncrement);
        } else if (explicitMinMaxSig) {
            int n = minSig < 1 ? 1 : (minSig = minSig > 999 ? 999 : minSig);
            maxSig = maxSig < 0 ? 999 : (maxSig < minSig ? minSig : (maxSig > 999 ? 999 : maxSig));
            rounding = Rounder.constructSignificant(minSig, maxSig);
        } else if (explicitMinMaxFrac) {
            rounding = Rounder.constructFraction(minFrac, maxFrac);
        } else if (useCurrency) {
            rounding = Rounder.constructCurrency(currencyUsage);
        }
        if (rounding != null) {
            macros.rounder = rounding = rounding.withMode(mathContext);
        }
        macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
        macros.grouping = Grouper.forProperties(properties2);
        if (properties2.getFormatWidth() != -1) {
            macros.padder = new Padder(properties2.getPadString(), properties2.getFormatWidth(), properties2.getPadPosition());
        }
        macros.decimal = properties2.getDecimalSeparatorAlwaysShown() ? NumberFormatter.DecimalSeparatorDisplay.ALWAYS : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        NumberFormatter.SignDisplay signDisplay = macros.sign = properties2.getSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO;
        if (properties2.getMinimumExponentDigits() != -1) {
            if (maxInt > 8) {
                maxInt = minInt;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            } else if (maxInt > minInt && minInt > 1) {
                minInt = 1;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            }
            int engineering = maxInt < 0 ? -1 : maxInt;
            macros.notation = new ScientificNotation(engineering, engineering == minInt, properties2.getMinimumExponentDigits(), properties2.getExponentSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO);
            if (macros.rounder instanceof FractionRounder) {
                int minInt_ = properties2.getMinimumIntegerDigits();
                int minFrac_ = properties2.getMinimumFractionDigits();
                int maxFrac_ = properties2.getMaximumFractionDigits();
                macros.rounder = minInt_ == 0 && maxFrac_ == 0 ? Rounder.constructInfinite().withMode(mathContext) : (minInt_ == 0 && minFrac_ == 0 ? Rounder.constructSignificant(1, maxFrac_ + 1).withMode(mathContext) : Rounder.constructSignificant(minInt_ + minFrac_, minInt_ + maxFrac_).withMode(mathContext));
            }
        }
        if (properties2.getCompactStyle() != null) {
            macros.notation = properties2.getCompactCustomData() != null ? new CompactNotation(properties2.getCompactCustomData()) : (properties2.getCompactStyle() == CompactDecimalFormat.CompactStyle.LONG ? Notation.compactLong() : Notation.compactShort());
            macros.affixProvider = null;
        }
        if (properties2.getMagnitudeMultiplier() != 0) {
            macros.multiplier = new MultiplierImpl(properties2.getMagnitudeMultiplier());
        } else if (properties2.getMultiplier() != null) {
            macros.multiplier = new MultiplierImpl(properties2.getMultiplier());
        }
        if (exportedProperties != null) {
            exportedProperties.setMathContext(mathContext);
            exportedProperties.setRoundingMode(mathContext.getRoundingMode());
            exportedProperties.setMinimumIntegerDigits(minInt);
            exportedProperties.setMaximumIntegerDigits(maxInt == -1 ? Integer.MAX_VALUE : maxInt);
            Rounder rounding_ = rounding instanceof CurrencyRounder ? ((CurrencyRounder)rounding).withCurrency(currency) : rounding;
            int minFrac_ = minFrac;
            int maxFrac_ = maxFrac;
            int minSig_ = minSig;
            int maxSig_ = maxSig;
            BigDecimal increment_ = null;
            if (rounding_ instanceof Rounder.FractionRounderImpl) {
                minFrac_ = ((Rounder.FractionRounderImpl)rounding_).minFrac;
                maxFrac_ = ((Rounder.FractionRounderImpl)rounding_).maxFrac;
            } else if (rounding_ instanceof Rounder.IncrementRounderImpl) {
                increment_ = ((Rounder.IncrementRounderImpl)rounding_).increment;
                minFrac_ = increment_.scale();
                maxFrac_ = increment_.scale();
            } else if (rounding_ instanceof Rounder.SignificantRounderImpl) {
                minSig_ = ((Rounder.SignificantRounderImpl)rounding_).minSig;
                maxSig_ = ((Rounder.SignificantRounderImpl)rounding_).maxSig;
            }
            exportedProperties.setMinimumFractionDigits(minFrac_);
            exportedProperties.setMaximumFractionDigits(maxFrac_);
            exportedProperties.setMinimumSignificantDigits(minSig_);
            exportedProperties.setMaximumSignificantDigits(maxSig_);
            exportedProperties.setRoundingIncrement(increment_);
        }
        return macros;
    }
}

