/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.Grouper;
import com.ibm.icu.impl.number.parse.DecimalMatcher;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.UnicodeSetStaticCache;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.UnicodeSet;

public class ScientificMatcher
implements NumberParseMatcher {
    private final String exponentSeparatorString;
    private final DecimalMatcher exponentMatcher;

    public static ScientificMatcher getInstance(DecimalFormatSymbols symbols, Grouper grouper) {
        return new ScientificMatcher(symbols, grouper);
    }

    private ScientificMatcher(DecimalFormatSymbols symbols, Grouper grouper) {
        this.exponentSeparatorString = symbols.getExponentSeparator();
        this.exponentMatcher = DecimalMatcher.getInstance(symbols, grouper, 80);
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        if (!result2.seenNumber()) {
            return false;
        }
        int overlap1 = segment.getCommonPrefixLength(this.exponentSeparatorString);
        if (overlap1 == this.exponentSeparatorString.length()) {
            segment.adjustOffset(overlap1);
            if (segment.length() == 0) {
                return true;
            }
            boolean minusSign = false;
            if (segment.startsWith(UnicodeSetStaticCache.get(UnicodeSetStaticCache.Key.MINUS_SIGN))) {
                minusSign = true;
                segment.adjustOffsetByCodePoint();
            } else if (segment.startsWith(UnicodeSetStaticCache.get(UnicodeSetStaticCache.Key.PLUS_SIGN))) {
                segment.adjustOffsetByCodePoint();
            }
            int digitsOffset = segment.getOffset();
            boolean digitsReturnValue = this.exponentMatcher.match(segment, result2, minusSign);
            if (segment.getOffset() != digitsOffset) {
                result2.flags |= 8;
            } else {
                segment.adjustOffset(-overlap1);
            }
            return digitsReturnValue;
        }
        return overlap1 == segment.length();
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        int leadCp = this.exponentSeparatorString.codePointAt(0);
        UnicodeSet s = UnicodeSetStaticCache.get(UnicodeSetStaticCache.Key.SCIENTIFIC_LEAD);
        if (s.contains(leadCp)) {
            return s;
        }
        return new UnicodeSet().add(leadCp).freeze();
    }

    @Override
    public void postProcess(ParsedNumber result2) {
    }

    public String toString() {
        return "<ScientificMatcher " + this.exponentSeparatorString + ">";
    }
}

