/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.number.parse.AnyMatcher;
import com.ibm.icu.impl.number.parse.CurrencyMatcher;
import com.ibm.icu.impl.number.parse.CurrencyTrieMatcher;
import com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import com.ibm.icu.impl.number.parse.MinusSignMatcher;
import com.ibm.icu.impl.number.parse.PercentMatcher;
import com.ibm.icu.impl.number.parse.PermilleMatcher;
import com.ibm.icu.impl.number.parse.PlusSignMatcher;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;

public class MatcherFactory {
    Currency currency;
    DecimalFormatSymbols symbols;
    IgnorablesMatcher ignorables;
    ULocale locale;

    public MinusSignMatcher minusSign(boolean allowTrailing) {
        return MinusSignMatcher.getInstance(this.symbols, allowTrailing);
    }

    public PlusSignMatcher plusSign(boolean allowTrailing) {
        return PlusSignMatcher.getInstance(this.symbols, allowTrailing);
    }

    public PercentMatcher percent() {
        return PercentMatcher.getInstance(this.symbols);
    }

    public PermilleMatcher permille() {
        return PermilleMatcher.getInstance(this.symbols);
    }

    public AnyMatcher currency() {
        AnyMatcher any2 = new AnyMatcher();
        any2.addMatcher(CurrencyMatcher.getInstance(this.currency, this.locale));
        any2.addMatcher(CurrencyTrieMatcher.getInstance(this.locale));
        any2.freeze();
        return any2;
    }

    public IgnorablesMatcher ignorables() {
        return this.ignorables;
    }
}

