/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.SymbolMatcher;
import com.ibm.icu.impl.number.parse.UnicodeSetStaticCache;
import com.ibm.icu.text.DecimalFormatSymbols;

public class InfinityMatcher
extends SymbolMatcher {
    private static final InfinityMatcher DEFAULT = new InfinityMatcher();

    public static InfinityMatcher getInstance(DecimalFormatSymbols symbols) {
        String symbolString = symbols.getInfinity();
        if (InfinityMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return DEFAULT;
        }
        return new InfinityMatcher(symbolString);
    }

    private InfinityMatcher(String symbolString) {
        super(symbolString, InfinityMatcher.DEFAULT.uniSet);
    }

    private InfinityMatcher() {
        super(UnicodeSetStaticCache.Key.INFINITY);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return 0 != (result2.flags & 0x80);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 0x80;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<PercentMatcher>";
    }
}

