/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.util.Freezable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Relation<K, V>
implements Freezable<Relation<K, V>> {
    private Map<K, Set<V>> data;
    Constructor<? extends Set<V>> setCreator;
    Object[] setComparatorParam;
    volatile boolean frozen = false;

    public static <K, V> Relation<K, V> of(Map<K, Set<V>> map2, Class<?> setCreator) {
        return new Relation<K, V>(map2, setCreator);
    }

    public static <K, V> Relation<K, V> of(Map<K, Set<V>> map2, Class<?> setCreator, Comparator<V> setComparator) {
        return new Relation<K, V>(map2, setCreator, setComparator);
    }

    public Relation(Map<K, Set<V>> map2, Class<?> setCreator) {
        this(map2, setCreator, null);
    }

    public Relation(Map<K, Set<V>> map2, Class<?> setCreator, Comparator<V> setComparator) {
        try {
            Object[] objectArray;
            if (setComparator == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = setComparator;
            }
            this.setComparatorParam = objectArray;
            if (setComparator == null) {
                this.setCreator = setCreator.getConstructor(new Class[0]);
                this.setCreator.newInstance(this.setComparatorParam);
            } else {
                this.setCreator = setCreator.getConstructor(Comparator.class);
                this.setCreator.newInstance(this.setComparatorParam);
            }
            this.data = map2 == null ? new HashMap() : map2;
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't create new set").initCause(e);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    public boolean containsValue(Object value) {
        for (Set<V> values2 : this.data.values()) {
            if (!values2.contains(value)) continue;
            return true;
        }
        return false;
    }

    public final Set<Map.Entry<K, V>> entrySet() {
        return this.keyValueSet();
    }

    public Set<Map.Entry<K, Set<V>>> keyValuesSet() {
        return this.data.entrySet();
    }

    public Set<Map.Entry<K, V>> keyValueSet() {
        LinkedHashSet<Map.Entry<K, V>> result2 = new LinkedHashSet<Map.Entry<K, V>>();
        for (K key : this.data.keySet()) {
            for (V value : this.data.get(key)) {
                result2.add(new SimpleEntry<K, V>(key, value));
            }
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.data.equals(((Relation)o).data);
    }

    public Set<V> getAll(Object key) {
        return this.data.get(key);
    }

    public Set<V> get(Object key) {
        return this.data.get(key);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public V put(K key, V value) {
        Set<V> set = this.data.get(key);
        if (set == null) {
            set = this.newSet();
            this.data.put(key, set);
        }
        set.add(value);
        return value;
    }

    public V putAll(K key, Collection<? extends V> values2) {
        Set<V> set = this.data.get(key);
        if (set == null) {
            set = this.newSet();
            this.data.put(key, set);
        }
        set.addAll(values2);
        return values2.size() == 0 ? null : (V)values2.iterator().next();
    }

    public V putAll(Collection<K> keys2, V value) {
        V result2 = null;
        for (K key : keys2) {
            result2 = this.put(key, value);
        }
        return result2;
    }

    private Set<V> newSet() {
        try {
            return this.setCreator.newInstance(this.setComparatorParam);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't create new set").initCause(e);
        }
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Relation<? extends K, ? extends V> t) {
        for (K key : t.keySet()) {
            for (V value : t.getAll(key)) {
                this.put(key, value);
            }
        }
    }

    public Set<V> removeAll(K key) {
        try {
            return this.data.remove(key);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public boolean remove(K key, V value) {
        try {
            Set<V> set = this.data.get(key);
            if (set == null) {
                return false;
            }
            boolean result2 = set.remove(value);
            if (set.size() == 0) {
                this.data.remove(key);
            }
            return result2;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public int size() {
        return this.data.size();
    }

    public Set<V> values() {
        return this.values(new LinkedHashSet());
    }

    public <C extends Collection<V>> C values(C result2) {
        for (Map.Entry<K, Set<V>> keyValue : this.data.entrySet()) {
            result2.addAll((Collection)keyValue.getValue());
        }
        return result2;
    }

    public String toString() {
        return this.data.toString();
    }

    public Relation<K, V> addAllInverted(Relation<V, K> source2) {
        for (K value : source2.data.keySet()) {
            for (V key : source2.data.get(value)) {
                this.put(key, value);
            }
        }
        return this;
    }

    public Relation<K, V> addAllInverted(Map<V, K> source2) {
        for (Map.Entry<V, K> entry : source2.entrySet()) {
            this.put(entry.getValue(), entry.getKey());
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Relation<K, V> freeze() {
        if (!this.frozen) {
            for (K key : this.data.keySet()) {
                this.data.put(key, Collections.unmodifiableSet(this.data.get(key)));
            }
            this.data = Collections.unmodifiableMap(this.data);
            this.frozen = true;
        }
        return this;
    }

    @Override
    public Relation<K, V> cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Relation<K, V> toBeRemoved) {
        boolean result2 = false;
        for (K key : toBeRemoved.keySet()) {
            try {
                Set<V> values2 = toBeRemoved.getAll(key);
                if (values2 == null) continue;
                result2 |= this.removeAll(key, (Iterable<V>)values2);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return result2;
    }

    public Set<V> removeAll(K ... keys2) {
        return this.removeAll((Collection<K>)Arrays.asList(keys2));
    }

    public boolean removeAll(K key, Iterable<V> toBeRemoved) {
        boolean result2 = false;
        for (V value : toBeRemoved) {
            result2 |= this.remove(key, value);
        }
        return result2;
    }

    public Set<V> removeAll(Collection<K> toBeRemoved) {
        LinkedHashSet<V> result2 = new LinkedHashSet<V>();
        for (K key : toBeRemoved) {
            try {
                Set<V> removals = this.data.remove(key);
                if (removals == null) continue;
                result2.addAll(removals);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return result2;
    }

    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

