/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.ir;

import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.ir.IrEnumType;
import com.apollographql.apollo3.compiler.ir.IrInputObjectType;
import com.apollographql.apollo3.compiler.ir.IrListType;
import com.apollographql.apollo3.compiler.ir.IrModelType;
import com.apollographql.apollo3.compiler.ir.IrNonNullType;
import com.apollographql.apollo3.compiler.ir.IrOptionalType;
import com.apollographql.apollo3.compiler.ir.IrScalarType;
import com.apollographql.apollo3.compiler.ir.IrType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"MODEL_FRAGMENT_DATA", "", "MODEL_FRAGMENT_INTERFACE", "MODEL_OPERATION_DATA", "MODEL_UNKNOWN", "isComposite", "", "Lcom/apollographql/apollo3/compiler/ir/IrType;", "isOptional", "makeNonNull", "makeNonOptional", "makeNullable", "makeOptional", "replacePlaceholder", "newPath", "toIr", "Lcom/apollographql/apollo3/ast/GQLType;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "apollo-compiler"})
public final class IrTypeKt {
    @NotNull
    public static final String MODEL_OPERATION_DATA = "operationData";
    @NotNull
    public static final String MODEL_FRAGMENT_DATA = "fragmentData";
    @NotNull
    public static final String MODEL_FRAGMENT_INTERFACE = "fragmentInterface";
    @NotNull
    public static final String MODEL_UNKNOWN = "?";

    @NotNull
    public static final IrType makeOptional(@NotNull IrType $this$makeOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$makeOptional, (String)"<this>");
        return new IrNonNullType(new IrOptionalType($this$makeOptional));
    }

    @NotNull
    public static final IrType makeNullable(@NotNull IrType $this$makeNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNullable, (String)"<this>");
        return $this$makeNullable instanceof IrNonNullType ? IrTypeKt.makeNullable(((IrNonNullType)$this$makeNullable).getOfType()) : $this$makeNullable;
    }

    @NotNull
    public static final IrType makeNonNull(@NotNull IrType $this$makeNonNull) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNonNull, (String)"<this>");
        return $this$makeNonNull instanceof IrNonNullType ? $this$makeNonNull : (IrType)new IrNonNullType($this$makeNonNull);
    }

    public static final boolean isOptional(@NotNull IrType $this$isOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$isOptional, (String)"<this>");
        return $this$isOptional instanceof IrNonNullType && ((IrNonNullType)$this$isOptional).getOfType() instanceof IrOptionalType;
    }

    @NotNull
    public static final IrType makeNonOptional(@NotNull IrType $this$makeNonOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNonOptional, (String)"<this>");
        IrNonNullType irNonNullType = $this$makeNonOptional instanceof IrNonNullType ? (IrNonNullType)$this$makeNonOptional : null;
        IrType irType = irNonNullType != null ? irNonNullType.getOfType() : null;
        IrType irType2 = irType instanceof IrOptionalType ? (IrOptionalType)irType : null;
        if (irType2 == null || (irType2 = irType2.getOfType()) == null) {
            throw new IllegalStateException("type is not an optional type".toString());
        }
        return irType2;
    }

    @NotNull
    public static final IrType replacePlaceholder(@NotNull IrType $this$replacePlaceholder, @NotNull String newPath) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$replacePlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        IrType irType2 = $this$replacePlaceholder;
        if (irType2 instanceof IrNonNullType) {
            irType = new IrNonNullType(IrTypeKt.replacePlaceholder(((IrNonNullType)$this$replacePlaceholder).getOfType(), newPath));
        } else if (irType2 instanceof IrListType) {
            irType = new IrListType(IrTypeKt.replacePlaceholder(((IrListType)$this$replacePlaceholder).getOfType(), newPath));
        } else if (irType2 instanceof IrModelType) {
            irType = ((IrModelType)$this$replacePlaceholder).copy(newPath);
        } else {
            throw new IllegalStateException("Not a compound type?".toString());
        }
        return irType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final IrType toIr(@NotNull GQLType $this$toIr, @NotNull Schema schema) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$toIr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        GQLType gQLType = $this$toIr;
        if (gQLType instanceof GQLNonNullType) {
            irType = new IrNonNullType(IrTypeKt.toIr(((GQLNonNullType)$this$toIr).getType(), schema));
            return irType;
        } else if (gQLType instanceof GQLListType) {
            irType = new IrListType(IrTypeKt.toIr(((GQLListType)$this$toIr).getType(), schema));
            return irType;
        } else {
            if (!(gQLType instanceof GQLNamedType)) throw new NoWhenBranchMatchedException();
            GQLTypeDefinition gQLTypeDefinition = schema.typeDefinition(((GQLNamedType)$this$toIr).getName());
            if (gQLTypeDefinition instanceof GQLScalarTypeDefinition) {
                irType = new IrScalarType(((GQLNamedType)$this$toIr).getName());
                return irType;
            } else if (gQLTypeDefinition instanceof GQLEnumTypeDefinition) {
                irType = new IrEnumType(((GQLNamedType)$this$toIr).getName());
                return irType;
            } else if (gQLTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                irType = new IrInputObjectType(((GQLNamedType)$this$toIr).getName());
                return irType;
            } else if (gQLTypeDefinition instanceof GQLObjectTypeDefinition) {
                irType = new IrModelType(MODEL_UNKNOWN);
                return irType;
            } else if (gQLTypeDefinition instanceof GQLInterfaceTypeDefinition) {
                irType = new IrModelType(MODEL_UNKNOWN);
                return irType;
            } else {
                if (!(gQLTypeDefinition instanceof GQLUnionTypeDefinition)) throw new NoWhenBranchMatchedException();
                irType = new IrModelType(MODEL_UNKNOWN);
            }
        }
        return irType;
    }

    public static final boolean isComposite(@NotNull IrType $this$isComposite) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposite, (String)"<this>");
        IrType irType = $this$isComposite;
        return irType instanceof IrScalarType ? false : !(irType instanceof IrEnumType);
    }
}

