/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\n"}, d2={"isFileSystemCaseSensitive", "", "outputDir", "Ljava/io/File;", "maybeMakeNamesUnique", "", "", "names", "", "resolveNameClashes", "apollo-compiler"})
public final class ApolloCompilerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> maybeMakeNamesUnique(@NotNull List<String> names, @NotNull File outputDir) {
        Map map;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        boolean isCaseSensitive = ApolloCompilerKt.isFileSystemCaseSensitive(outputDir);
        if (isCaseSensitive) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = names;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                String string = (String)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it, element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = ApolloCompilerKt.resolveNameClashes(names);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> resolveNameClashes(List<String> names) {
        void $this$mapTo$iv$iv;
        Set usedNames = new LinkedHashSet();
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)names);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int i = 1;
            String newName = it;
            while (true) {
                String string2 = newName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!usedNames.contains(string2)) break;
                newName = (String)it + i;
                ++i;
            }
            String string3 = newName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            usedNames.add(string3);
            collection.add(TuplesKt.to((Object)it, (Object)newName));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final boolean isFileSystemCaseSensitive(File outputDir) {
        boolean bl;
        File case1 = FilesKt.resolve((File)outputDir, (String)".casecheck");
        File case2 = FilesKt.resolve((File)outputDir, (String)".CASECHECK");
        case1.createNewFile();
        boolean it = bl = case2.exists();
        boolean bl2 = false;
        case1.delete();
        return !bl;
    }
}

