/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.Check_key_fieldsKt;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLResult;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.IssueKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.transformation.Add_required_fieldsKt;
import com.apollographql.apollo3.compiler.CheckNoConditionalFragmentKt;
import com.apollographql.apollo3.compiler.CompilerMetadata;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.Options;
import com.apollographql.apollo3.compiler.PackageNameGenerator;
import com.apollographql.apollo3.compiler.TargetLanguage;
import com.apollographql.apollo3.compiler.codegen.ResolverInfo;
import com.apollographql.apollo3.compiler.codegen.java.JavaCodeGen;
import com.apollographql.apollo3.compiler.codegen.kotlin.KotlinCodeGen;
import com.apollographql.apollo3.compiler.ir.Ir;
import com.apollographql.apollo3.compiler.ir.IrBuilder;
import com.apollographql.apollo3.compiler.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.ir.IrOperation;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/compiler/ApolloCompiler;", "", "()V", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "checkCustomScalars", "", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "customScalarsMapping", "", "", "write", "Lcom/apollographql/apollo3/compiler/CompilerMetadata;", "options", "Lcom/apollographql/apollo3/compiler/Options;", "Logger", "apollo-compiler"})
@ApolloExperimental
public final class ApolloCompiler {
    @NotNull
    public static final ApolloCompiler INSTANCE = new ApolloCompiler();
    @NotNull
    private static final Logger NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        }
    };

    private ApolloCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerMetadata write(@NotNull Options options) {
        ResolverInfo resolverInfo;
        boolean bl;
        List list;
        Object $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv22;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Object element$iv2;
        Issue it;
        Iterator $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object2;
        void $this$mapTo$iv$iv5;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set<File> executableFiles = options.getExecutableFiles();
        File outputDir = options.getOutputDir();
        File testDir = options.getTestDir();
        File debugDir = options.getDebugDir();
        Schema schema = options.getSchema();
        if (options.getTargetLanguage() == TargetLanguage.JAVA && !Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"operationBased")) {
            throw new IllegalStateException(("Java codegen does not support " + options.getCodegenModels() + ". Only operationBased is supported.").toString());
        }
        if (options.getTargetLanguage() == TargetLanguage.JAVA && !options.getFlattenModels()) {
            throw new IllegalStateException("Java codegen does not support nested models as it could trigger name clashes when a nested class has the same name as an enclosing one.".toString());
        }
        this.checkCustomScalars(schema, options.getCustomScalarsMapping());
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl2 = file == null ? null : Boolean.valueOf(FilesKt.deleteRecursively((File)file));
        File file2 = debugDir;
        Boolean bl3 = file2 == null ? null : Boolean.valueOf(file2.mkdirs());
        List definitions = new ArrayList();
        List parseIssues = new ArrayList();
        Iterable $this$map$iv3 = executableFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            boolean bl4;
            void file3;
            File file4 = (File)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            GQLResult parseResult = ApolloParser.parseAsGQLDocument((BufferedSource)Okio.buffer((Source)Okio.source((File)file3)), (String)file3.getPath());
            if (!((Collection)parseResult.getIssues()).isEmpty()) {
                bl4 = parseIssues.addAll(parseResult.getIssues());
            } else {
                Object object3 = parseResult.getValue();
                Intrinsics.checkNotNull((Object)object3);
                bl4 = definitions.addAll(((GQLDocument)object3).getDefinitions());
            }
            object2.add(bl4);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IssueKt.checkNoErrors((List)parseIssues);
        Iterable $this$flatMap$iv = options.getIncomingCompilerMetadata();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerMetadata it2 = (CompilerMetadata)element$iv$iv;
            boolean bl6 = false;
            Iterable list$iv$iv = it2.getFragments();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List incomingFragments = (List)destination$iv$iv3;
        GQLResult validationResult = ApolloParser.validateAsExecutable((GQLDocument)new GQLDocument(CollectionsKt.plus((Collection)definitions, (Iterable)incomingFragments), null), (Schema)options.getSchema());
        IssueKt.checkNoErrors((List)validationResult.getIssues());
        if (Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"responseBased")) {
            IssueKt.checkNoErrors(CheckNoConditionalFragmentKt.findConditionalFragments(definitions));
        }
        Iterable $this$filter$iv = validationResult.getIssues();
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator list$iv$iv = $this$filterTo$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv = list$iv$iv.next();
            it = (Issue)element$iv$iv;
            boolean bl7 = false;
            if (!(it.getSeverity() == Issue.Severity.WARNING && (!(it instanceof Issue.DeprecatedUsage) || options.getWarnOnDeprecatedUsages()))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List warnings = (List)destination$iv$iv4;
        Iterable $this$forEach$iv = warnings;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Issue it3 = (Issue)element$iv2;
            boolean bl8 = false;
            options.getLogger().warning("w: " + it3.getSourceLocation().pretty() + ": Apollo: " + it3.getMessage());
        }
        if (options.getFailOnWarnings() && !((Collection)warnings).isEmpty()) {
            throw new IllegalStateException("Apollo: Warnings found and 'failOnWarnings' is true, aborting.");
        }
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        element$iv2 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv5;
        boolean $i$f$map2 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it4;
            GQLFragmentDefinition bl7 = (GQLFragmentDefinition)item$iv$iv;
            object2 = destination$iv$iv5;
            boolean bl9 = false;
            object2.add(Add_required_fieldsKt.addRequiredFields((GQLFragmentDefinition)it4, (Schema)options.getSchema()));
        }
        List fragments = (List)destination$iv$iv5;
        Iterable $this$filterIsInstance$iv2 = definitions;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv5 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv6;
        boolean $i$f$map3 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it5;
            GQLOperationDefinition bl9 = (GQLOperationDefinition)item$iv$iv;
            object2 = destination$iv$iv6;
            boolean bl10 = false;
            object2.add(Add_required_fieldsKt.addRequiredFields((GQLOperationDefinition)it5, (Schema)options.getSchema()));
        }
        List operations = (List)destination$iv$iv6;
        Iterable $this$associateBy$iv = CollectionsKt.plus((Collection)fragments, (Iterable)incomingFragments);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo222 = $this$associateBy$iv;
        Map destination$iv$iv7 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Iterator it6;
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl11 = false;
            object2.put(it6.getName(), element$iv$iv);
        }
        Map allFragmentDefinitions = destination$iv$iv7;
        if (options.getSchema().hasTypeWithTypePolicy()) {
            Iterable $this$forEach$iv2 = operations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it = (GQLOperationDefinition)element$iv3;
                boolean bl12 = false;
                Check_key_fieldsKt.checkKeyFields((GQLOperationDefinition)it, (Schema)options.getSchema(), (Map)allFragmentDefinitions);
            }
            $this$forEach$iv2 = fragments;
            $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it = (GQLFragmentDefinition)element$iv3;
                boolean bl13 = false;
                Check_key_fieldsKt.checkKeyFields((GQLFragmentDefinition)it, (Schema)options.getSchema(), (Map)allFragmentDefinitions);
            }
        }
        Set alwaysGenerateTypesMatching = options.getAlwaysGenerateTypesMatching();
        if (options.getGenerateSchema()) {
            alwaysGenerateTypesMatching = SetsKt.plus(alwaysGenerateTypesMatching, (Object)".*");
        }
        Ir ir = new IrBuilder(options.getSchema(), operations, options.getGenerateTestBuilders(), fragments, allFragmentDefinitions, alwaysGenerateTypesMatching, options.getCustomScalarsMapping(), options.getCodegenModels(), options.getGenerateOptionalOperationVariables()).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Object $this$map$iv4 = ir.getOperations();
        boolean $i$f$map4 = false;
        Iterable bl13 = $this$map$iv4;
        Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo42 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it7;
            object = (IrOperation)item$iv$iv;
            object2 = destination$iv$iv8;
            boolean bl14 = false;
            object2.add(new OperationDescriptor(it7.getName(), QueryDocumentMinifier.minify((String)it7.getSourceWithFragments())));
        }
        List it8 = (List)destination$iv$iv8;
        boolean bl15 = false;
        Map<String, OperationDescriptor> operationOutput = options.getOperationOutputGenerator().generate(it8);
        if (!(operationOutput.size() == operations.size())) {
            boolean $i$a$-check-ApolloCompiler$write$62 = false;
            String $i$a$-check-ApolloCompiler$write$62 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw new IllegalStateException($i$a$-check-ApolloCompiler$write$62.toString());
        }
        if (options.getOperationOutputFile() != null) {
            void $this$toJson$iv;
            File file5 = options.getOperationOutputFile();
            $this$map$iv4 = operationOutput;
            String indent$iv = "  ";
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            String $i$f$mapTo42 = MoshiKt.getMOSHI().adapter(Map.class).indent(indent$iv).toJson((Object)$this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo42, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
            FilesKt.writeText$default((File)file5, (String)$i$f$mapTo42, null, (int)2, null);
        }
        if (WhenMappings.$EnumSwitchMapping$0[options.getTargetLanguage().ordinal()] == 1) {
            Iterable $this$map$iv222 = options.getIncomingCompilerMetadata();
            boolean $i$f$map222 = false;
            Iterable item$iv$iv = $this$map$iv222;
            destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv222, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it9;
                Object item$iv$iv2 = iterator.next();
                CompilerMetadata compilerMetadata = (CompilerMetadata)item$iv$iv2;
                object2 = destination$iv$iv22;
                boolean bl16 = false;
                object2.add(it9.getResolverInfo());
            }
            list = (List)destination$iv$iv22;
            boolean $this$map$iv222 = options.getUseSemanticNaming();
            PackageNameGenerator $i$f$map222 = options.getPackageNameGenerator();
            $this$mapTo$iv$iv = options.getSchemaPackageName();
            boolean destination$iv$iv22 = options.getGenerateFragmentImplementations();
            $i$f$mapTo = options.getGenerateQueryDocument();
            bl = options.getGenerateSchema();
            boolean item$iv$iv2 = options.getFlattenModels();
            resolverInfo = new JavaCodeGen(ir, list, $this$map$iv222, $i$f$map222, (String)$this$mapTo$iv$iv, operationOutput, destination$iv$iv22, $i$f$mapTo, bl, item$iv$iv2).write(outputDir);
        } else {
            Iterable $this$map$iv5 = options.getIncomingCompilerMetadata();
            boolean $i$f$map5 = false;
            $this$mapTo$iv$iv = $this$map$iv5;
            destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                CompilerMetadata it9 = (CompilerMetadata)item$iv$iv;
                object2 = destination$iv$iv22;
                boolean bl17 = false;
                object2.add(it9.getResolverInfo());
            }
            list = (List)destination$iv$iv22;
            boolean bl18 = options.getGenerateAsInternal();
            boolean bl19 = options.getUseSemanticNaming();
            PackageNameGenerator packageNameGenerator = options.getPackageNameGenerator();
            object = options.getSchemaPackageName();
            boolean bl20 = options.getGenerateFilterNotNull();
            bl = options.getGenerateFragmentImplementations();
            boolean bl21 = options.getGenerateQueryDocument();
            boolean bl22 = options.getGenerateSchema();
            boolean bl23 = options.getGenerateTestBuilders();
            boolean bl24 = options.getFlattenModels();
            List<String> list2 = options.getSealedClassesForEnumsMatching();
            TargetLanguage targetLanguage = options.getTargetLanguage();
            resolverInfo = new KotlinCodeGen(ir, list, bl18, bl19, packageNameGenerator, (String)object, operationOutput, bl20, bl, bl21, bl22, bl23, bl24, list2, targetLanguage).write(outputDir, testDir);
        }
        ResolverInfo outputResolverInfo = resolverInfo;
        return new CompilerMetadata(fragments, outputResolverInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(Schema schema, Map<String, String> customScalarsMapping) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GQLScalarTypeDefinition it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = schema.getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLScalarTypeDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBuiltIn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            it = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(type.getName());
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)customScalarsMapping.keySet(), (Iterable)schemaScalars);
        if (!unknownScalars.isEmpty()) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Apollo: unknown custom scalar(s) in customScalarsMapping: ", (Object)CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Logger getNoOpLogger() {
        return NoOpLogger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetLanguage.values().length];
            nArray[TargetLanguage.JAVA.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

