/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.ast.Add_typenameKt;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GqldocumentKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.IssueKt;
import com.apollographql.apollo3.ast.ParseKt;
import com.apollographql.apollo3.ast.ParseResult;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.MetadataFragment;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.PackageNameProvider;
import com.apollographql.apollo3.compiler.Roots;
import com.apollographql.apollo3.compiler.VersionKt;
import com.apollographql.apollo3.compiler.codegen.KotlinCodeGenerator;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.compiler.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo3.compiler.unified.ir.IntermediateRepresentation;
import com.apollographql.apollo3.compiler.unified.ir.IrBuilder;
import com.apollographql.apollo3.compiler.unified.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.unified.ir.IrEnum;
import com.apollographql.apollo3.compiler.unified.ir.IrInputObject;
import com.apollographql.apollo3.compiler.unified.ir.IrOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "()V", "checkCustomScalars", "", "incomingOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "write", "operationFiles", "", "Ljava/io/File;", "outputDir", "debugDir", "moduleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "Companion", "IncomingOptions", "Logger", "ModuleOptions", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        }
    };
    @NotNull
    private static final List<MetadataFragment> defaultMetadataFragments = CollectionsKt.emptyList();
    @NotNull
    private static final Set<String> defaultMetadataInputObjects = SetsKt.emptySet();
    @NotNull
    private static final Set<String> defaultMetadataEnums = SetsKt.emptySet();
    private static final boolean defaultMetadataCustomScalars;
    @NotNull
    private static final PackageNameProvider.Flat defaultPackageNameProvider;
    @NotNull
    private static final Set<String> defaultAlwaysGenerateTypesMatching;
    @Nullable
    private static final Void defaultOperationOutputFile;
    @NotNull
    private static final OperationOutputGenerator.Default defaultOperationOutputGenerator;
    @NotNull
    private static final Map<String, String> defaultCustomScalarsMapping;
    private static final boolean defaultUseSemanticNaming;
    private static final boolean defaultWarnOnDeprecatedUsages;
    private static final boolean defaultFailOnWarnings;
    @NotNull
    private static final Logger defaultLogger;
    private static final boolean defaultGenerateAsInternal;
    private static final boolean defaultGenerateFilterNotNull;
    private static final boolean defaultGenerateFragmentsAsInterfaces;
    private static final boolean defaultGenerateFragmentImplementations;
    private static final boolean defaultGenerateResponseFields;
    private static final boolean defaultGenerateQueryDocument;
    @NotNull
    private static final String defaultModuleName;
    @Nullable
    private static final Void defaultMetadataOutputFile;
    @NotNull
    private static final ModuleOptions DefaultModuleOptions;

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Set<? extends File> operationFiles, @NotNull File outputDir, @Nullable File debugDir, @NotNull IncomingOptions incomingOptions, @NotNull ModuleOptions moduleOptions) {
        boolean bl;
        void $this$mapTo$iv$iv6222;
        boolean bl2;
        Set<String> $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Collection<GQLFragmentDefinition> collection;
        void $this$mapTo$iv$iv4;
        void $this$map$iv3;
        Object object;
        Collection collection2;
        void $this$mapTo$iv$iv5;
        Intrinsics.checkParameterIsNotNull(operationFiles, (String)"operationFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)incomingOptions, (String)"incomingOptions");
        Intrinsics.checkParameterIsNotNull((Object)moduleOptions, (String)"moduleOptions");
        this.checkCustomScalars(incomingOptions);
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl3 = file == null ? null : Boolean.valueOf(FilesKt.deleteRecursively((File)file));
        file = debugDir;
        Boolean bl4 = file == null ? null : Boolean.valueOf(file.mkdirs());
        boolean bl5 = false;
        List definitions = new ArrayList();
        boolean bl6 = false;
        List parseIssues = new ArrayList();
        Iterable $this$map$iv4 = operationFiles;
        boolean $i$f$map232 = false;
        Iterable iterable = $this$map$iv4;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            boolean bl7;
            void file2;
            File file3 = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl8 = false;
            ParseResult parseResult = ParseKt.parseAsGQLDocument((File)file2);
            if (parseResult instanceof ParseResult.Success) {
                bl7 = definitions.addAll(((GQLDocument)((ParseResult.Success)parseResult).getValue()).getDefinitions());
            } else if (parseResult instanceof ParseResult.Error) {
                bl7 = parseIssues.addAll(((ParseResult.Error)parseResult).getIssues());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = bl7;
            collection2.add(object);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IssueKt.checkNoErrors((List)parseIssues);
        Iterable $i$f$map232 = incomingOptions.getMetadataFragments();
        Collection collection3 = definitions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            MetadataFragment bl8 = (MetadataFragment)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            GQLFragmentDefinition gQLFragmentDefinition = it.getDefinition();
            collection.add(gQLFragmentDefinition);
        }
        collection = (List)destination$iv$iv2;
        String string = null;
        List list = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
        List validationIssues = GqldocumentKt.validateAsOperations((GQLDocument)new GQLDocument(list, string), (Schema)incomingOptions.getSchema());
        IssueKt.checkNoErrors((List)validationIssues);
        if (moduleOptions.getWarnOnDeprecatedUsages()) {
            Object item$iv$iv;
            Iterable $this$filter$iv = validationIssues;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv = $this$filterTo$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                Object element$iv$iv = item$iv$iv.next();
                Issue issue = (Issue)element$iv$iv;
                boolean bl10 = false;
                if (!(issue.getSeverity() == Issue.Severity.WARNING)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List warnings = (List)destination$iv$iv3;
            Iterable $this$forEach$iv = warnings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Issue it = (Issue)element$iv;
                boolean bl11 = false;
                int column = it.getSourceLocation().getPosition() + 1;
                moduleOptions.getLogger().warning("w: " + it.getSourceLocation().getFilePath() + ':' + it.getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: " + it.getMessage());
            }
            if (moduleOptions.getFailOnWarnings()) {
                $this$forEach$iv = warnings;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv4;
        boolean $i$f$map3 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl12 = false;
            object = Add_typenameKt.withTypenameWhenNeeded((GQLFragmentDefinition)gQLFragmentDefinition, (Schema)incomingOptions.getSchema());
            collection2.add(object);
        }
        List fragments = (List)destination$iv$iv3;
        Iterable $this$filterIsInstance$iv2 = definitions;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv3 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof GQLOperationDefinition)) continue;
            destination$iv$iv5.add(t);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv5;
        boolean $i$f$map3232 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        Object destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2232 = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it232;
            GQLOperationDefinition bl12 = (GQLOperationDefinition)t;
            collection2 = destination$iv$iv6;
            bl2 = false;
            object = Add_typenameKt.withTypenameWhenNeeded((GQLOperationDefinition)it232, (Schema)incomingOptions.getSchema());
            collection2.add(object);
        }
        List operations = (List)destination$iv$iv6;
        Schema $i$f$map3232 = incomingOptions.getSchema();
        $this$mapTo$iv$iv2 = moduleOptions.getAlwaysGenerateTypesMatching();
        destination$iv$iv6 = incomingOptions.getCustomScalarsMapping();
        $i$f$mapTo2232 = incomingOptions.getGenerateFragmentsAsInterfaces();
        List<MetadataFragment> item$iv$iv = incomingOptions.getMetadataFragments();
        Set<String> set = incomingOptions.getMetadataEnums();
        Set<String> it232 = incomingOptions.getMetadataInputObjects();
        bl2 = incomingOptions.isFromMetadata();
        IntermediateRepresentation ir = new IrBuilder($i$f$map3232, operations, fragments, $this$mapTo$iv$iv2, (Map<String, String>)destination$iv$iv6, item$iv$iv, set, it232, $i$f$mapTo2232, bl2).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Iterable $this$map$iv222322 = ir.getOperations();
        boolean $i$f$map4 = false;
        Iterable $i$f$mapTo2232 = $this$map$iv222322;
        Collection destination$iv$iv62 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv222322, (int)10));
        boolean bl10 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv6222) {
            void it3;
            IrOperation irOperation = (IrOperation)item$iv$iv3;
            collection2 = destination$iv$iv62;
            bl = false;
            object = new OperationDescriptor(it3.getName(), QueryDocumentMinifier.minify((String)it3.getSourceWithFragments()));
            collection2.add(object);
        }
        $this$map$iv222322 = (List)destination$iv$iv62;
        $i$f$map4 = false;
        boolean $this$mapTo$iv$iv6222 = false;
        Iterable it = $this$map$iv222322;
        boolean bl11 = false;
        Map<String, OperationDescriptor> operationOutput = moduleOptions.getOperationOutputGenerator().generate((Collection)it);
        boolean $this$map$iv222322 = operationOutput.size() == operations.size();
        $i$f$map4 = false;
        $this$mapTo$iv$iv6222 = false;
        if (!$this$map$iv222322) {
            boolean bl14 = false;
            String $this$mapTo$iv$iv6222 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv6222.toString());
        }
        if (moduleOptions.getOperationOutputFile() != null) {
            void $this$toJson$iv;
            File file2 = moduleOptions.getOperationOutputFile();
            Map<String, OperationDescriptor> $this$map$iv222322 = operationOutput;
            String indent$iv = "  ";
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            String string2 = MoshiKt.getMOSHI().adapter(Map.class).indent(indent$iv).toJson((Object)$this$toJson$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
            FilesKt.writeText$default((File)file2, (String)string2, null, (int)2, null);
        }
        boolean $this$toJson$iv = moduleOptions.getGenerateAsInternal();
        boolean indent$iv = moduleOptions.getUseSemanticNaming();
        PackageNameProvider $i$f$toJson = moduleOptions.getPackageNameProvider();
        String $i$f$getJsonAdapter = Intrinsics.stringPlus((String)incomingOptions.getSchemaPackageName(), (Object)".type");
        boolean set2 = !incomingOptions.isFromMetadata();
        boolean it232 = moduleOptions.getGenerateFilterNotNull();
        boolean item$iv$iv3 = incomingOptions.getGenerateFragmentsAsInterfaces();
        boolean it3 = moduleOptions.getGenerateFragmentImplementations();
        bl = moduleOptions.getGenerateResponseFields();
        boolean bl12 = moduleOptions.getGenerateQueryDocument();
        new KotlinCodeGenerator(ir, $this$toJson$iv, indent$iv, $i$f$toJson, $i$f$getJsonAdapter, operationOutput, set2, it232, it3, bl, bl12, item$iv$iv3).write(outputDir);
        if (moduleOptions.getMetadataOutputFile() != null) {
            void $this$mapTo$iv$iv7;
            void $this$mapTo$iv$iv8;
            Object object2;
            moduleOptions.getMetadataOutputFile().getParentFile().mkdirs();
            Schema schema = incomingOptions.isFromMetadata() ? (Schema)null : incomingOptions.getSchema();
            Iterable $this$map$iv5 = fragments;
            boolean $i$f$map5 = false;
            Iterable iterable2 = $this$map$iv5;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo3232 = false;
            for (Object item$iv$iv4 : iterable2) {
                void it4;
                GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)item$iv$iv4;
                collection2 = destination$iv$iv7;
                boolean bl16 = false;
                object2 = it4.getName();
                PackageNameProvider packageNameProvider = moduleOptions.getPackageNameProvider();
                String string3 = it4.getSourceLocation().getFilePath();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = packageNameProvider.fragmentPackageName(string3);
                object = new MetadataFragment((String)object2, (GQLFragmentDefinition)it4, string4);
                collection2.add(object);
            }
            List outgoingMetadataFragments = (List)destination$iv$iv7;
            Map<String, String> map = incomingOptions.getCustomScalarsMapping();
            Iterable iterable3 = ir.getEnums();
            boolean $i$f$map6 = false;
            Iterable $i$f$mapTo3232 = iterable3;
            Iterable destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv8) {
                void it5;
                object2 = (IrEnum)item$iv$iv5;
                collection2 = destination$iv$iv8;
                boolean bl17 = false;
                object = it5.getName();
                collection2.add(object);
            }
            Set set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv8));
            Iterable $this$map$iv7 = ir.getInputObjects();
            boolean $i$f$map7 = false;
            destination$iv$iv8 = $this$map$iv7;
            Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
            boolean $i$f$mapTo6 = false;
            for (Object item$iv$iv6 : $this$mapTo$iv$iv7) {
                void it6;
                IrInputObject bl17 = (IrInputObject)item$iv$iv6;
                collection2 = destination$iv$iv9;
                boolean bl18 = false;
                object = it6.getName();
                collection2.add(object);
            }
            Set set4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv9));
            boolean bl13 = incomingOptions.getGenerateFragmentsAsInterfaces();
            String string5 = moduleOptions.getModuleName();
            String string6 = VersionKt.getVERSION();
            String string7 = incomingOptions.getSchemaPackageName();
            new ApolloMetadata(schema, outgoingMetadataFragments, set3, set4, string7, string5, string6, map, bl13).writeTo(moduleOptions.getMetadataOutputFile());
        }
    }

    public static /* synthetic */ void write$default(GraphQLCompiler graphQLCompiler, Set set, File file, File file2, IncomingOptions incomingOptions, ModuleOptions moduleOptions, int n, Object object) {
        if ((n & 4) != 0) {
            file2 = null;
        }
        graphQLCompiler.write(set, file, file2, incomingOptions, moduleOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(IncomingOptions incomingOptions) {
        void $this$mapTo$iv$iv;
        GQLScalarTypeDefinition it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = incomingOptions.getSchema().getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLScalarTypeDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBuiltIn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            it = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = type.getName();
            collection.add(string);
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)incomingOptions.getCustomScalarsMapping().keySet(), (Iterable)schemaScalars);
        boolean bl = unknownScalars.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"ApolloGraphQL: unknown custom scalar(s): ", (Object)CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    static {
        defaultPackageNameProvider = new PackageNameProvider.Flat("com.apollographql.generated");
        defaultAlwaysGenerateTypesMatching = SetsKt.emptySet();
        defaultOperationOutputGenerator = new OperationOutputGenerator.Default(OperationIdGenerator.Sha256.INSTANCE);
        defaultCustomScalarsMapping = MapsKt.emptyMap();
        defaultUseSemanticNaming = true;
        defaultWarnOnDeprecatedUsages = true;
        defaultLogger = NoOpLogger;
        defaultGenerateResponseFields = true;
        defaultGenerateQueryDocument = true;
        defaultModuleName = "apollographql";
        Set<String> set = defaultAlwaysGenerateTypesMatching;
        Void void_ = defaultOperationOutputFile;
        OperationOutputGenerator.Default default_ = defaultOperationOutputGenerator;
        boolean bl = defaultUseSemanticNaming;
        boolean bl2 = defaultWarnOnDeprecatedUsages;
        boolean bl3 = defaultFailOnWarnings;
        Logger logger = defaultLogger;
        boolean bl4 = defaultGenerateAsInternal;
        boolean bl5 = defaultGenerateFilterNotNull;
        boolean bl6 = defaultGenerateFragmentImplementations;
        boolean bl7 = defaultGenerateResponseFields;
        boolean bl8 = defaultGenerateQueryDocument;
        PackageNameProvider.Flat flat = defaultPackageNameProvider;
        Void void_2 = defaultMetadataOutputFile;
        String string = defaultModuleName;
        DefaultModuleOptions = new ModuleOptions(set, (File)((Object)void_2), flat, (File)((Object)void_), default_, bl, bl2, bl3, logger, bl4, bl5, bl6, bl7, bl8, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0006\u0010\r\u001a\u00020\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "schemaPackageName", "", "customScalarsMapping", "", "generateFragmentsAsInterfaces", "", "metadataInputObjects", "", "metadataEnums", "isFromMetadata", "metadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "(Lcom/apollographql/apollo3/ast/Schema;Ljava/lang/String;Ljava/util/Map;ZLjava/util/Set;Ljava/util/Set;ZLjava/util/List;)V", "getCustomScalarsMapping", "()Ljava/util/Map;", "getGenerateFragmentsAsInterfaces", "()Z", "getMetadataEnums", "()Ljava/util/Set;", "getMetadataFragments", "()Ljava/util/List;", "getMetadataInputObjects", "getSchema", "()Lcom/apollographql/apollo3/ast/Schema;", "getSchemaPackageName", "()Ljava/lang/String;", "Companion", "apollo-compiler"})
    public static final class IncomingOptions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Schema schema;
        @NotNull
        private final String schemaPackageName;
        @NotNull
        private final Map<String, String> customScalarsMapping;
        private final boolean generateFragmentsAsInterfaces;
        @NotNull
        private final Set<String> metadataInputObjects;
        @NotNull
        private final Set<String> metadataEnums;
        private final boolean isFromMetadata;
        @NotNull
        private final List<MetadataFragment> metadataFragments;

        public IncomingOptions(@NotNull Schema schema, @NotNull String schemaPackageName, @NotNull Map<String, String> customScalarsMapping, boolean generateFragmentsAsInterfaces, @NotNull Set<String> metadataInputObjects, @NotNull Set<String> metadataEnums, boolean isFromMetadata, @NotNull List<MetadataFragment> metadataFragments) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(metadataInputObjects, (String)"metadataInputObjects");
            Intrinsics.checkParameterIsNotNull(metadataEnums, (String)"metadataEnums");
            Intrinsics.checkParameterIsNotNull(metadataFragments, (String)"metadataFragments");
            this.schema = schema;
            this.schemaPackageName = schemaPackageName;
            this.customScalarsMapping = customScalarsMapping;
            this.generateFragmentsAsInterfaces = generateFragmentsAsInterfaces;
            this.metadataInputObjects = metadataInputObjects;
            this.metadataEnums = metadataEnums;
            this.isFromMetadata = isFromMetadata;
            this.metadataFragments = metadataFragments;
        }

        @NotNull
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final String getSchemaPackageName() {
            return this.schemaPackageName;
        }

        @NotNull
        public final Map<String, String> getCustomScalarsMapping() {
            return this.customScalarsMapping;
        }

        public final boolean getGenerateFragmentsAsInterfaces() {
            return this.generateFragmentsAsInterfaces;
        }

        @NotNull
        public final Set<String> getMetadataInputObjects() {
            return this.metadataInputObjects;
        }

        @NotNull
        public final Set<String> getMetadataEnums() {
            return this.metadataEnums;
        }

        public final boolean isFromMetadata() {
            return this.isFromMetadata;
        }

        @NotNull
        public final List<MetadataFragment> getMetadataFragments() {
            return this.metadataFragments;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions$Companion;", "", "()V", "from", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "schemaFile", "Ljava/io/File;", "extraSchemaFiles", "", "customScalarsMapping", "", "", "generateFragmentsAsInterfaces", "", "rootPackageName", "fromMetadata", "metadata", "Lcom/apollographql/apollo3/compiler/ApolloMetadata;", "toGQLDocument", "Lcom/apollographql/apollo3/ast/GQLDocument;", "apollo-compiler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IncomingOptions fromMetadata(@NotNull ApolloMetadata metadata) {
                Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
                Schema schema = metadata.getSchema();
                if (schema == null) {
                    Intrinsics.throwNpe();
                }
                return new IncomingOptions(schema, metadata.getSchemaPackageName(), metadata.getCustomScalarsMapping(), metadata.getGenerateFragmentsAsInterfaces(), metadata.getGeneratedInputObjects(), metadata.getGeneratedEnums(), true, metadata.getGeneratedFragments());
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IncomingOptions from(@NotNull Roots roots, @NotNull File schemaFile, @NotNull Set<? extends File> extraSchemaFiles, @NotNull Map<String, String> customScalarsMapping, boolean generateFragmentsAsInterfaces, @NotNull String rootPackageName) {
                void $this$flatMapTo$iv$iv;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
                Intrinsics.checkParameterIsNotNull((Object)schemaFile, (String)"schemaFile");
                Intrinsics.checkParameterIsNotNull(extraSchemaFiles, (String)"extraSchemaFiles");
                Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
                Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
                try {
                    string = schemaFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schemaFile.absolutePath");
                    string = roots.filePackageName(string);
                }
                catch (Exception e) {
                    string = "";
                }
                String relativeSchemaPackageName = string;
                GQLDocument document = this.toGQLDocument(schemaFile);
                Iterable $this$flatMap$iv = extraSchemaFiles;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ((GQLDocument)ParseKt.parseAsGQLDocument((File)it).getOrThrow()).getDefinitions();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List extraDefinitions = (List)destination$iv$iv;
                Schema schema = GqldocumentKt.toSchema((GQLDocument)new GQLDocument(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)document.getDefinitions(), (Iterable)extraDefinitions), (Iterable)GqldocumentKt.apolloDefinitions()), null));
                return new IncomingOptions(schema, StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(rootPackageName + '.' + relativeSchemaPackageName), (CharSequence)"."), (CharSequence)"."), customScalarsMapping, generateFragmentsAsInterfaces, SetsKt.emptySet(), SetsKt.emptySet(), false, CollectionsKt.emptyList());
            }

            private final GQLDocument toGQLDocument(File $this$toGQLDocument) {
                return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$toGQLDocument), (Object)"json") ? Introspection_to_schemaKt.toGQLDocument(IntrospectionSchemaKt.toIntrospectionSchema($this$toGQLDocument)) : (GQLDocument)ParseKt.parseAsGQLDocument((File)$this$toGQLDocument).getOrThrow();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\rH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\t\u00103\u001a\u00020\rH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\rH\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\t\u0010=\u001a\u00020\u0011H\u00c6\u0003J\u00a9\u0001\u0010>\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010?\u001a\u00020\r2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001c\u00a8\u0006D"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "", "alwaysGenerateTypesMatching", "", "", "metadataOutputFile", "Ljava/io/File;", "packageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "useSemanticNaming", "", "warnOnDeprecatedUsages", "failOnWarnings", "logger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "generateAsInternal", "generateFilterNotNull", "generateFragmentImplementations", "generateResponseFields", "generateQueryDocument", "moduleName", "(Ljava/util/Set;Ljava/io/File;Lcom/apollographql/apollo3/compiler/PackageNameProvider;Ljava/io/File;Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;ZZZLcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;ZZZZZLjava/lang/String;)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getFailOnWarnings", "()Z", "getGenerateAsInternal", "getGenerateFilterNotNull", "getGenerateFragmentImplementations", "getGenerateQueryDocument", "getGenerateResponseFields", "getLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "getPackageNameProvider", "()Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class ModuleOptions {
        @NotNull
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File metadataOutputFile;
        @NotNull
        private final PackageNameProvider packageNameProvider;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        private final boolean useSemanticNaming;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        @NotNull
        private final Logger logger;
        private final boolean generateAsInternal;
        private final boolean generateFilterNotNull;
        private final boolean generateFragmentImplementations;
        private final boolean generateResponseFields;
        private final boolean generateQueryDocument;
        @NotNull
        private final String moduleName;

        public ModuleOptions(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.metadataOutputFile = metadataOutputFile;
            this.packageNameProvider = packageNameProvider;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.useSemanticNaming = useSemanticNaming;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.logger = logger;
            this.generateAsInternal = generateAsInternal;
            this.generateFilterNotNull = generateFilterNotNull;
            this.generateFragmentImplementations = generateFragmentImplementations;
            this.generateResponseFields = generateResponseFields;
            this.generateQueryDocument = generateQueryDocument;
            this.moduleName = moduleName;
        }

        @NotNull
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider getPackageNameProvider() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getGenerateFilterNotNull() {
            return this.generateFilterNotNull;
        }

        public final boolean getGenerateFragmentImplementations() {
            return this.generateFragmentImplementations;
        }

        public final boolean getGenerateResponseFields() {
            return this.generateResponseFields;
        }

        public final boolean getGenerateQueryDocument() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final Set<String> component1() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component2() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider component3() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File component4() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component5() {
            return this.operationOutputGenerator;
        }

        public final boolean component6() {
            return this.useSemanticNaming;
        }

        public final boolean component7() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component8() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger component9() {
            return this.logger;
        }

        public final boolean component10() {
            return this.generateAsInternal;
        }

        public final boolean component11() {
            return this.generateFilterNotNull;
        }

        public final boolean component12() {
            return this.generateFragmentImplementations;
        }

        public final boolean component13() {
            return this.generateResponseFields;
        }

        public final boolean component14() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String component15() {
            return this.moduleName;
        }

        @NotNull
        public final ModuleOptions copy(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            return new ModuleOptions(alwaysGenerateTypesMatching, metadataOutputFile, packageNameProvider, operationOutputFile, operationOutputGenerator, useSemanticNaming, warnOnDeprecatedUsages, failOnWarnings, logger, generateAsInternal, generateFilterNotNull, generateFragmentImplementations, generateResponseFields, generateQueryDocument, moduleName);
        }

        public static /* synthetic */ ModuleOptions copy$default(ModuleOptions moduleOptions, Set set, File file, PackageNameProvider packageNameProvider, File file2, OperationOutputGenerator operationOutputGenerator, boolean bl, boolean bl2, boolean bl3, Logger logger, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String string, int n, Object object) {
            if ((n & 1) != 0) {
                set = moduleOptions.alwaysGenerateTypesMatching;
            }
            if ((n & 2) != 0) {
                file = moduleOptions.metadataOutputFile;
            }
            if ((n & 4) != 0) {
                packageNameProvider = moduleOptions.packageNameProvider;
            }
            if ((n & 8) != 0) {
                file2 = moduleOptions.operationOutputFile;
            }
            if ((n & 0x10) != 0) {
                operationOutputGenerator = moduleOptions.operationOutputGenerator;
            }
            if ((n & 0x20) != 0) {
                bl = moduleOptions.useSemanticNaming;
            }
            if ((n & 0x40) != 0) {
                bl2 = moduleOptions.warnOnDeprecatedUsages;
            }
            if ((n & 0x80) != 0) {
                bl3 = moduleOptions.failOnWarnings;
            }
            if ((n & 0x100) != 0) {
                logger = moduleOptions.logger;
            }
            if ((n & 0x200) != 0) {
                bl4 = moduleOptions.generateAsInternal;
            }
            if ((n & 0x400) != 0) {
                bl5 = moduleOptions.generateFilterNotNull;
            }
            if ((n & 0x800) != 0) {
                bl6 = moduleOptions.generateFragmentImplementations;
            }
            if ((n & 0x1000) != 0) {
                bl7 = moduleOptions.generateResponseFields;
            }
            if ((n & 0x2000) != 0) {
                bl8 = moduleOptions.generateQueryDocument;
            }
            if ((n & 0x4000) != 0) {
                string = moduleOptions.moduleName;
            }
            return moduleOptions.copy(set, file, packageNameProvider, file2, operationOutputGenerator, bl, bl2, bl3, logger, bl4, bl5, bl6, bl7, bl8, string);
        }

        @NotNull
        public String toString() {
            return "ModuleOptions(alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", metadataOutputFile=" + this.metadataOutputFile + ", packageNameProvider=" + this.packageNameProvider + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", useSemanticNaming=" + this.useSemanticNaming + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", logger=" + this.logger + ", generateAsInternal=" + this.generateAsInternal + ", generateFilterNotNull=" + this.generateFilterNotNull + ", generateFragmentImplementations=" + this.generateFragmentImplementations + ", generateResponseFields=" + this.generateResponseFields + ", generateQueryDocument=" + this.generateQueryDocument + ", moduleName=" + this.moduleName + ')';
        }

        public int hashCode() {
            int result = ((Object)this.alwaysGenerateTypesMatching).hashCode();
            result = result * 31 + (this.metadataOutputFile == null ? 0 : this.metadataOutputFile.hashCode());
            result = result * 31 + this.packageNameProvider.hashCode();
            result = result * 31 + (this.operationOutputFile == null ? 0 : this.operationOutputFile.hashCode());
            result = result * 31 + this.operationOutputGenerator.hashCode();
            int n = this.useSemanticNaming ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.failOnWarnings ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            result = result * 31 + this.logger.hashCode();
            int n4 = this.generateAsInternal ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            int n5 = this.generateFilterNotNull ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            result = result * 31 + n5;
            int n6 = this.generateFragmentImplementations ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            result = result * 31 + n6;
            int n7 = this.generateResponseFields ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            result = result * 31 + n7;
            int n8 = this.generateQueryDocument ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            result = result * 31 + n8;
            result = result * 31 + this.moduleName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleOptions)) {
                return false;
            }
            ModuleOptions moduleOptions = (ModuleOptions)other;
            if (!Intrinsics.areEqual(this.alwaysGenerateTypesMatching, moduleOptions.alwaysGenerateTypesMatching)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metadataOutputFile, (Object)moduleOptions.metadataOutputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.packageNameProvider, (Object)moduleOptions.packageNameProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputFile, (Object)moduleOptions.operationOutputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputGenerator, (Object)moduleOptions.operationOutputGenerator)) {
                return false;
            }
            if (this.useSemanticNaming != moduleOptions.useSemanticNaming) {
                return false;
            }
            if (this.warnOnDeprecatedUsages != moduleOptions.warnOnDeprecatedUsages) {
                return false;
            }
            if (this.failOnWarnings != moduleOptions.failOnWarnings) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logger, (Object)moduleOptions.logger)) {
                return false;
            }
            if (this.generateAsInternal != moduleOptions.generateAsInternal) {
                return false;
            }
            if (this.generateFilterNotNull != moduleOptions.generateFilterNotNull) {
                return false;
            }
            if (this.generateFragmentImplementations != moduleOptions.generateFragmentImplementations) {
                return false;
            }
            if (this.generateResponseFields != moduleOptions.generateResponseFields) {
                return false;
            }
            if (this.generateQueryDocument != moduleOptions.generateQueryDocument) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.moduleName, (Object)moduleOptions.moduleName);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0014\u0010 \u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0011\u0010$\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0014\u0010&\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000fR\u0013\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0013\u00108\u001a\u0004\u0018\u000102\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00104R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0017R\u0014\u0010D\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0017\u00a8\u0006F"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion;", "", "()V", "DefaultModuleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "getDefaultModuleOptions", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "defaultAlwaysGenerateTypesMatching", "", "", "getDefaultAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "defaultCustomScalarsMapping", "", "getDefaultCustomScalarsMapping", "()Ljava/util/Map;", "defaultFailOnWarnings", "", "getDefaultFailOnWarnings", "()Z", "defaultGenerateAsInternal", "getDefaultGenerateAsInternal", "defaultGenerateFilterNotNull", "getDefaultGenerateFilterNotNull", "defaultGenerateFragmentImplementations", "getDefaultGenerateFragmentImplementations", "defaultGenerateFragmentsAsInterfaces", "getDefaultGenerateFragmentsAsInterfaces", "defaultGenerateQueryDocument", "getDefaultGenerateQueryDocument", "defaultGenerateResponseFields", "getDefaultGenerateResponseFields", "defaultLogger", "getDefaultLogger", "defaultMetadataCustomScalars", "getDefaultMetadataCustomScalars", "defaultMetadataEnums", "getDefaultMetadataEnums", "defaultMetadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "getDefaultMetadataFragments", "()Ljava/util/List;", "defaultMetadataInputObjects", "getDefaultMetadataInputObjects", "defaultMetadataOutputFile", "", "getDefaultMetadataOutputFile", "()Ljava/lang/Void;", "defaultModuleName", "getDefaultModuleName", "()Ljava/lang/String;", "defaultOperationOutputFile", "getDefaultOperationOutputFile", "defaultOperationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator$Default;", "getDefaultOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator$Default;", "defaultPackageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider$Flat;", "getDefaultPackageNameProvider", "()Lcom/apollographql/apollo3/compiler/PackageNameProvider$Flat;", "defaultUseSemanticNaming", "getDefaultUseSemanticNaming", "defaultWarnOnDeprecatedUsages", "getDefaultWarnOnDeprecatedUsages", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getNoOpLogger() {
            return NoOpLogger;
        }

        @NotNull
        public final List<MetadataFragment> getDefaultMetadataFragments() {
            return defaultMetadataFragments;
        }

        @NotNull
        public final Set<String> getDefaultMetadataInputObjects() {
            return defaultMetadataInputObjects;
        }

        @NotNull
        public final Set<String> getDefaultMetadataEnums() {
            return defaultMetadataEnums;
        }

        public final boolean getDefaultMetadataCustomScalars() {
            return defaultMetadataCustomScalars;
        }

        @NotNull
        public final PackageNameProvider.Flat getDefaultPackageNameProvider() {
            return defaultPackageNameProvider;
        }

        @NotNull
        public final Set<String> getDefaultAlwaysGenerateTypesMatching() {
            return defaultAlwaysGenerateTypesMatching;
        }

        @Nullable
        public final Void getDefaultOperationOutputFile() {
            return defaultOperationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator.Default getDefaultOperationOutputGenerator() {
            return defaultOperationOutputGenerator;
        }

        @NotNull
        public final Map<String, String> getDefaultCustomScalarsMapping() {
            return defaultCustomScalarsMapping;
        }

        public final boolean getDefaultUseSemanticNaming() {
            return defaultUseSemanticNaming;
        }

        public final boolean getDefaultWarnOnDeprecatedUsages() {
            return defaultWarnOnDeprecatedUsages;
        }

        public final boolean getDefaultFailOnWarnings() {
            return defaultFailOnWarnings;
        }

        @NotNull
        public final Logger getDefaultLogger() {
            return defaultLogger;
        }

        public final boolean getDefaultGenerateAsInternal() {
            return defaultGenerateAsInternal;
        }

        public final boolean getDefaultGenerateFilterNotNull() {
            return defaultGenerateFilterNotNull;
        }

        public final boolean getDefaultGenerateFragmentsAsInterfaces() {
            return defaultGenerateFragmentsAsInterfaces;
        }

        public final boolean getDefaultGenerateFragmentImplementations() {
            return defaultGenerateFragmentImplementations;
        }

        public final boolean getDefaultGenerateResponseFields() {
            return defaultGenerateResponseFields;
        }

        public final boolean getDefaultGenerateQueryDocument() {
            return defaultGenerateQueryDocument;
        }

        @NotNull
        public final String getDefaultModuleName() {
            return defaultModuleName;
        }

        @Nullable
        public final Void getDefaultMetadataOutputFile() {
            return defaultMetadataOutputFile;
        }

        @NotNull
        public final ModuleOptions getDefaultModuleOptions() {
            return DefaultModuleOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

