/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.graphql.ast;

import com.apollographql.apollo3.graphql.ast.GQLDefinition;
import com.apollographql.apollo3.graphql.ast.GQLDirectiveDefinition;
import com.apollographql.apollo3.graphql.ast.GQLDocument;
import com.apollographql.apollo3.graphql.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.graphql.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLOperationDefinition;
import com.apollographql.apollo3.graphql.ast.GQLSchemaDefinition;
import com.apollographql.apollo3.graphql.ast.GQLTypeDefinition;
import com.apollographql.apollo3.graphql.ast.Issue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007*\u00020\tH\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\tH\u0002J\f\u0010\r\u001a\u00020\f*\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\tH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\tH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\tH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/graphql/ast/SchemaValidationScope;", "", "()V", "issues", "", "Lcom/apollographql/apollo3/graphql/ast/Issue;", "validate", "", "document", "Lcom/apollographql/apollo3/graphql/ast/GQLDocument;", "validateAsSchema", "validateDirectiveNames", "", "validateInterfaces", "validateNotExecutable", "validateObjects", "validateTypeNames", "validateUniqueSchemaDefinition", "apollo-graphql-ast"})
public final class SchemaValidationScope {
    @NotNull
    private final List<Issue> issues;

    public SchemaValidationScope() {
        boolean bl = false;
        this.issues = new ArrayList();
    }

    @NotNull
    public final List<Issue> validate(@NotNull GQLDocument document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        return this.validateAsSchema(document);
    }

    private final List<Issue> validateAsSchema(GQLDocument $this$validateAsSchema) {
        this.validateNotExecutable($this$validateAsSchema);
        this.validateUniqueSchemaDefinition($this$validateAsSchema);
        this.validateTypeNames($this$validateAsSchema);
        this.validateDirectiveNames($this$validateAsSchema);
        this.validateInterfaces($this$validateAsSchema);
        this.validateObjects($this$validateAsSchema);
        return this.issues;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateInterfaces(GQLDocument $this$validateInterfaces) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateInterfaces.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLInterfaceTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLInterfaceTypeDefinition it = (GQLInterfaceTypeDefinition)element$iv;
            boolean bl = false;
            if (!it.getFields().isEmpty()) continue;
            this.issues.add(new Issue.ValidationError("Interfaces must specify one or more fields", it.getSourceLocation()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateObjects(GQLDocument $this$validateObjects) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateObjects.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLObjectTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLObjectTypeDefinition o = (GQLObjectTypeDefinition)element$iv;
            boolean bl = false;
            if (o.getFields().isEmpty()) {
                this.issues.add(new Issue.ValidationError("Object must specify one or more fields", o.getSourceLocation()));
            }
            Iterable $this$forEach$iv2 = o.getImplementsInterfaces();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GQLDefinition iface;
                Object v0;
                String implementsInterface;
                block5: {
                    implementsInterface = (String)element$iv2;
                    boolean bl2 = false;
                    Iterable $this$firstOrNull$iv = $this$validateObjects.getDefinitions();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        GQLDefinition it = (GQLDefinition)element$iv3;
                        boolean bl3 = false;
                        GQLInterfaceTypeDefinition gQLInterfaceTypeDefinition = it instanceof GQLInterfaceTypeDefinition ? (GQLInterfaceTypeDefinition)it : null;
                        if (!Intrinsics.areEqual((Object)(gQLInterfaceTypeDefinition == null ? null : gQLInterfaceTypeDefinition.getName()), (Object)implementsInterface)) continue;
                        v0 = element$iv3;
                        break block5;
                    }
                    v0 = null;
                }
                if ((iface = (GQLDefinition)v0) != null) continue;
                this.issues.add(new Issue.ValidationError("Object '" + o.getName() + "' cannot implement non-interface '" + implementsInterface + '\'', o.getSourceLocation()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueSchemaDefinition(GQLDocument $this$validateUniqueSchemaDefinition) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$validateUniqueSchemaDefinition.getDefinitions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GQLDefinition it = (GQLDefinition)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof GQLSchemaDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List schemaDefinitions = (List)destination$iv$iv;
        Collection collection = schemaDefinitions;
        boolean bl = false;
        if (collection.size() > 1) {
            this.issues.add(new Issue.ValidationError("multiple schema definitions found", ((GQLDefinition)CollectionsKt.last((List)schemaDefinitions)).getSourceLocation()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateTypeNames(GQLDocument $this$validateTypeNames) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl = false;
        Map typeDefinitions = new LinkedHashMap();
        boolean bl2 = false;
        List conflicts = new ArrayList();
        Iterable $this$filterIsInstance$iv = $this$validateTypeNames.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLTypeDefinition it = (GQLTypeDefinition)element$iv;
            boolean bl3 = false;
            String name = it.getName();
            if (!typeDefinitions.containsKey(name)) {
                Map map = typeDefinitions;
                boolean bl4 = false;
                map.put(name, it);
                continue;
            }
            conflicts.add(it);
        }
        if (conflicts.size() > 0) {
            GQLTypeDefinition conflict = (GQLTypeDefinition)CollectionsKt.first((List)conflicts);
            this.issues.add(new Issue.ValidationError("type '" + conflict.getName() + "' is defined multiple times", conflict.getSourceLocation()));
        }
        typeDefinitions.forEach((arg_0, arg_1) -> SchemaValidationScope.validateTypeNames$lambda-6(this, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void validateDirectiveNames(GQLDocument $this$validateDirectiveNames) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        boolean bl = false;
        Map directiveDefinitions = new LinkedHashMap();
        boolean bl2 = false;
        List conflicts = new ArrayList();
        Iterable iterable = $this$validateDirectiveNames.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLDirectiveDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirectiveDefinition it = (GQLDirectiveDefinition)element$iv;
            boolean bl3 = false;
            String name = it.getName();
            if (!directiveDefinitions.containsKey(name)) {
                directiveDefinitions.put(name, it);
                continue;
            }
            conflicts.add(it);
        }
        if (conflicts.size() > 0) {
            GQLDirectiveDefinition conflict = (GQLDirectiveDefinition)CollectionsKt.first((List)conflicts);
            this.issues.add(new Issue.ValidationError("directive '" + conflict.getName() + "' is defined multiple times", conflict.getSourceLocation()));
        }
        directiveDefinitions.forEach((arg_0, arg_1) -> SchemaValidationScope.validateDirectiveNames$lambda-8(this, arg_0, arg_1));
    }

    private final void validateNotExecutable(GQLDocument $this$validateNotExecutable) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$validateNotExecutable.getDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLDefinition it = (GQLDefinition)element$iv;
                boolean bl = false;
                if (!(it instanceof GQLOperationDefinition || it instanceof GQLFragmentDefinition)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GQLDefinition gQLDefinition = v0;
        if (gQLDefinition != null) {
            GQLDefinition gQLDefinition2 = gQLDefinition;
            boolean bl = false;
            boolean bl2 = false;
            GQLDefinition it = gQLDefinition2;
            boolean bl3 = false;
            this.issues.add(new Issue.ValidationError("Found an executable definition. Schemas should not contain operations or fragments.", it.getSourceLocation()));
        }
    }

    private static final void validateTypeNames$lambda-6(SchemaValidationScope this$0, String name, GQLTypeDefinition definition) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        if (StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null)) {
            this$0.issues.add(new Issue.ValidationError("names starting with '__' are reserved for introspection", definition.getSourceLocation()));
        }
    }

    private static final void validateDirectiveNames$lambda-8(SchemaValidationScope this$0, String name, GQLDirectiveDefinition definition) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        if (StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null)) {
            this$0.issues.add(new Issue.ValidationError("names starting with '__' are reserved for introspection", definition.getSourceLocation()));
        }
    }
}

