/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.DeferredFragmentIdentifier;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Executables;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.internal.ResponseParserKt;
import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.MapJsonReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JY\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\r2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseParser;", "", "<init>", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "requestUuid", "Lcom/benasher44/uuid/Uuid;", "Ljava/util/UUID;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "deferredFragmentIds", "", "Lcom/apollographql/apollo3/api/DeferredFragmentIdentifier;", "(Lcom/apollographql/apollo3/api/json/JsonReader;Lcom/apollographql/apollo3/api/Operation;Ljava/util/UUID;Lcom/apollographql/apollo3/api/CustomScalarAdapters;Ljava/util/Set;)Lcom/apollographql/apollo3/api/ApolloResponse;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "payload", "", "", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nResponseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo3/api/internal/ResponseParser\n+ 2 uuid.kt\ncom/benasher44/uuid/UuidKt\n*L\n1#1,157:1\n100#2:158\n*S KotlinDebug\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo3/api/internal/ResponseParser\n*L\n48#1:158\n*E\n"})
public final class ResponseParser {
    @NotNull
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @Nullable UUID requestUuid, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable Set<DeferredFragmentIdentifier> deferredFragmentIds) {
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    Set<String> falseVariables = Executables.falseVariables(operation, customScalarAdapters);
                    data = (Operation.Data)Executables.parseData(operation, jsonReader, customScalarAdapters, falseVariables, deferredFragmentIds, errors);
                    continue block10;
                }
                case "errors": {
                    errors = ResponseParserKt.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    Object object = -JsonReaders.readAny(jsonReader);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        UUID uUID = requestUuid;
        if (uUID == null) {
            boolean $i$f$uuid4 = false;
            UUID uUID2 = UUID.randomUUID();
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
        }
        return new ApolloResponse.Builder<D>(operation, uUID).errors(errors).data(data).extensions(extensions).build();
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return ResponseParserKt.access$readError(new MapJsonReader(payload, null, 2, null));
    }
}

