/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.UploadsHttpBody;
import com.apollographql.apollo3.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.api.json.MapJsonWriter;
import com.apollographql.apollo3.api.json.internal.FileUploadAwareJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serverUrl;
    @NotNull
    private static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    private static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    private static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "Apollo-Require-Preflight";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed;deferSpec=20220824, application/json";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed;subscriptionSpec=1.0, application/json";

    public DefaultHttpRequestComposer(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest.Builder builder;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        if (apolloRequest.getOperation() instanceof Subscription) {
            $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_MULTIPART));
        } else {
            $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_DEFER));
        }
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        List requestHeaders = list;
        Boolean bl2 = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl2 != null ? bl2 : false;
        Boolean bl3 = apolloRequest.getSendDocument();
        boolean sendDocument = bl3 != null ? bl3 : true;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                builder = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, sendApqExtensions, sendDocument)).addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                break;
            }
            case 2: {
                String query = sendDocument ? operation.document() : null;
                HttpBody body = Companion.buildPostBody(operation, customScalarAdapters2, sendApqExtensions, query);
                HttpRequest.Builder it = new HttpRequest.Builder(HttpMethod.Post, this.serverUrl).body(body);
                boolean bl4 = false;
                if (StringsKt.startsWith$default((String)body.getContentType(), (String)"multipart/form-data", (boolean)false, (int)2, null)) {
                    builder = it.addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                    break;
                }
                builder = it;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest.Builder httpRequestBuilder = builder;
        return httpRequestBuilder.addHeaders(requestHeaders).addExecutionContext(apolloRequest.getExecutionContext()).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J@\u0010\u001b\u001a\u00020\u0004\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0002J6\u0010$\u001a\u00020%\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aJ:\u0010'\u001a\u00020(\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0007JI\u0010'\u001a\u00020(\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\u00042\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017JD\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040,\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0002J,\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010,\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001c0/JN\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002010,\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u00102\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J_\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002010,\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u00102\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 2\u0006\u0010!\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\u00042\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017H\u0002J\u001e\u00103\u001a\u00020\u0004*\u00020\u00042\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040,R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0006R\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u00065"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "()V", "HEADER_ACCEPT_NAME", "", "getHEADER_ACCEPT_NAME", "()Ljava/lang/String;", "HEADER_ACCEPT_VALUE_DEFER", "getHEADER_ACCEPT_VALUE_DEFER", "HEADER_ACCEPT_VALUE_MULTIPART", "getHEADER_ACCEPT_VALUE_MULTIPART", "HEADER_APOLLO_OPERATION_ID", "getHEADER_APOLLO_OPERATION_ID$annotations", "getHEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "getHEADER_APOLLO_OPERATION_NAME$annotations", "getHEADER_APOLLO_OPERATION_NAME", "HEADER_APOLLO_REQUIRE_PREFLIGHT", "getHEADER_APOLLO_REQUIRE_PREFLIGHT$apollo_api", "apqExtensionsWriter", "Lkotlin/Function1;", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "", "Lkotlin/ExtensionFunctionType;", "id", "sendApqExtensions", "", "buildGetUrl", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "sendDocument", "buildParamsMap", "Lokio/ByteString;", "autoPersistQueries", "buildPostBody", "Lcom/apollographql/apollo3/api/http/HttpBody;", "query", "extensionsWriter", "composeGetParams", "", "composePayload", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "composePostParams", "Lcom/apollographql/apollo3/api/Upload;", "writer", "appendQueryParameters", "parameters", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion\n+ 2 JsonWriters.kt\ncom/apollographql/apollo3/api/json/-JsonWriters\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n45#2,6:398\n45#2,8:404\n51#2,2:412\n66#2,7:414\n45#2,8:421\n73#2:429\n66#2,7:430\n45#2,6:437\n45#2,8:443\n51#2,2:451\n73#2:453\n78#2,7:456\n77#2,8:463\n89#2,7:471\n1853#3,2:454\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion\n*L\n132#1:398,6\n138#1:404,8\n132#1:412,2\n196#1:414,7\n198#1:421,8\n196#1:429\n213#1:430,7\n214#1:437,6\n216#1:443,8\n214#1:451,2\n213#1:453\n266#1:456,7\n296#1:463,8\n312#1:471,7\n234#1:454,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHEADER_APOLLO_OPERATION_ID() {
            return HEADER_APOLLO_OPERATION_ID;
        }

        @Deprecated(message="If needed, add this header with ApolloCall.addHttpHeader() instead", level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getHEADER_APOLLO_OPERATION_ID$annotations() {
        }

        @NotNull
        public final String getHEADER_APOLLO_OPERATION_NAME() {
            return HEADER_APOLLO_OPERATION_NAME;
        }

        @Deprecated(message="If needed, add this header with ApolloCall.addHttpHeader() instead", level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getHEADER_APOLLO_OPERATION_NAME$annotations() {
        }

        @NotNull
        public final String getHEADER_APOLLO_REQUIRE_PREFLIGHT$apollo_api() {
            return HEADER_APOLLO_REQUIRE_PREFLIGHT;
        }

        @NotNull
        public final String getHEADER_ACCEPT_NAME() {
            return HEADER_ACCEPT_NAME;
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_DEFER() {
            return HEADER_ACCEPT_VALUE_DEFER;
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_MULTIPART() {
            return HEADER_ACCEPT_VALUE_MULTIPART;
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, String query, Function1<? super JsonWriter, Unit> extensionsWriter) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u241.name("operationName");
            $this$composePostParams_u24lambda_u241.value(operation.name());
            $this$composePostParams_u24lambda_u241.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u241);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241_u24lambda_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u241_u24lambda_u240, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u241.name("query");
                $this$composePostParams_u24lambda_u241.value(query);
            }
            extensionsWriter.invoke((Object)$this$composePostParams_u24lambda_u241);
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, String query) {
            return this.composePostParams(writer, operation, customScalarAdapters, query, this.apqExtensionsWriter(operation.id(), sendApqExtensions));
        }

        private final Function1<JsonWriter, Unit> apqExtensionsWriter(String id, boolean sendApqExtensions) {
            return (Function1)new Function1<JsonWriter, Unit>(sendApqExtensions, id){
                final /* synthetic */ boolean $sendApqExtensions;
                final /* synthetic */ String $id;
                {
                    this.$sendApqExtensions = $sendApqExtensions;
                    this.$id = $id;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(JsonWriter $this$null) {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    if (this.$sendApqExtensions) {
                        void $this$writeObject$iv;
                        $this$null.name("extensions");
                        JsonWriter jsonWriter = $this$null;
                        String string = this.$id;
                        boolean $i$f$writeObject = false;
                        $this$writeObject$iv.beginObject();
                        void $this$invoke_u24lambda_u241 = $this$writeObject$iv;
                        boolean bl = false;
                        $this$invoke_u24lambda_u241.name("persistedQuery");
                        void $this$writeObject$iv2 = $this$invoke_u24lambda_u241;
                        boolean $i$f$writeObject2 = false;
                        $this$writeObject$iv2.beginObject();
                        void $this$invoke_u24lambda_u241_u24lambda_u240 = $this$writeObject$iv2;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.name("version").value(1);
                        $this$invoke_u24lambda_u241_u24lambda_u240.name("sha256Hash").value(string);
                        $this$writeObject$iv2.endObject();
                        $this$writeObject$iv.endObject();
                    }
                }
            };
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u244 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u244);
            JsonWriter $this$writeObject$iv = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u244_u24lambda_u242 = $this$writeObject$iv;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u244_u24lambda_u242, customScalarAdapters, false);
            $this$writeObject$iv.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                String indent$iv2 = null;
                boolean $i$f$buildJsonString2 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$composeGetParams_u24lambda_u247 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2, indent$iv2);
                boolean bl3 = false;
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u247;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u247_u24lambda_u246 = $this$writeObject$iv;
                boolean bl4 = false;
                $this$composeGetParams_u24lambda_u247_u24lambda_u246.name("persistedQuery");
                JsonWriter $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u247_u24lambda_u246;
                boolean $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u247_u24lambda_u246_u24lambda_u245 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u247_u24lambda_u246_u24lambda_u245.name("version").value(1);
                $this$composeGetParams_u24lambda_u247_u24lambda_u246_u24lambda_u245.name("sha256Hash").value(operation.id());
                $this$writeObject$iv2.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u249 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u249.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    $this$appendQueryParameters_u24lambda_u249.append('&');
                } else {
                    hasQuestionMark = true;
                    $this$appendQueryParameters_u24lambda_u249.append('?');
                }
                $this$appendQueryParameters_u24lambda_u249.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u249.append('=');
                $this$appendQueryParameters_u24lambda_u249.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Deprecated(message="Use buildPostBody(operation, customScalarADapters, query, extensionsWriter) instead")
        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return this.buildPostBody(operation, customScalarAdapters, query, this.apqExtensionsWriter(operation.id(), autoPersistQueries));
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable String query, @NotNull Function1<? super JsonWriter, Unit> extensionsWriter) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Intrinsics.checkNotNullParameter(extensionsWriter, (String)"extensionsWriter");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2410 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u2410, operation, customScalarAdapters, query, (Function1<? super JsonWriter, Unit>)extensionsWriter);
            ByteString operationByteString = buffer$iv.readByteString();
            return uploads.isEmpty() ? (HttpBody)new HttpBody(operationByteString){
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                {
                    this.$operationByteString = $operationByteString;
                    this.contentType = "application/json";
                    this.contentLength = $operationByteString.size();
                }

                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                public void writeTo(BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    bufferedSink.write(this.$operationByteString);
                }
            } : (HttpBody)new UploadsHttpBody(uploads, operationByteString);
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2411 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2411, operation, customScalarAdapters, autoPersistQueries, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                customScalarAdapters = CustomScalarAdapters.Empty;
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2412 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2412, operation, customScalarAdapters2, sendApqExtensions, query);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

