/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.DefaultAdaptersKt;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo3.api.internal.json.MapJsonReader;
import com.apollographql.apollo3.api.internal.json.Utils;
import com.apollographql.apollo3.api.json.JsonReader;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJB\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eJ\u001a\u0010\u0014\u001a\u00020\u0013*\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000eH\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseBodyParser;", "", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "payload", "", "", "source", "Lokio/BufferedSource;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "readError", "readErrorLocation", "Lcom/apollographql/apollo3/api/Error$Location;", "readErrors", "", "apollo-api"})
public final class ResponseBodyParser {
    @NotNull
    public static final ResponseBodyParser INSTANCE = new ResponseBodyParser();

    private ResponseBodyParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    data = (Operation.Data)DefaultAdaptersKt.nullable(operation.adapter()).fromJson(jsonReader, customScalarAdapters);
                    continue block10;
                }
                case "errors": {
                    errors = this.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    Object object = Utils.INSTANCE.readRecursively(jsonReader);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    extensions = (Map)object;
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        Map map = extensions;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return new ApolloResponse(uUID, operation, data, errors, map2, null, 32, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull BufferedSource source, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        ApolloResponse<D> apolloResponse;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Closeable $this$use$iv = new BufferedSourceJsonReader(source);
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            BufferedSourceJsonReader jsonReader = (BufferedSourceJsonReader)$this$use$iv;
            boolean bl = false;
            apolloResponse = INSTANCE.parse(jsonReader, operation, customScalarAdapters);
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (exception$iv == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return apolloResponse;
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull Map<String, ? extends Object> payload, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        return this.parse(new MapJsonReader(payload), operation, customScalarAdapters);
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.readError(payload);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Error> readErrors(JsonReader $this$readErrors) {
        List list;
        Object object = Utils.INSTANCE.readRecursively($this$readErrors);
        List responseErrors = object instanceof List ? (List)object : null;
        object = responseErrors;
        if (object == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void errorPayload;
                Map map = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Error error = INSTANCE.readError((Map<String, ? extends Object>)errorPayload);
                collection.add(error);
            }
            list = (List)destination$iv$iv;
        }
        object = list;
        boolean bl = false;
        Object object3 = object;
        if (object3 == null) {
            object3 = CollectionsKt.emptyList();
        }
        return object3;
    }

    /*
     * WARNING - void declaration
     */
    private final Error readError(Map<String, ? extends Object> $this$readError) {
        String message = "";
        List locations = CollectionsKt.emptyList();
        boolean bl = false;
        Map customAttributes = new LinkedHashMap();
        Object object = $this$readError;
        boolean bl2 = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3 = object = iterator.next();
            boolean bl3 = false;
            String key = (String)object3.getKey();
            Object object4 = object;
            boolean bl4 = false;
            Object value = object4.getValue();
            object4 = key;
            if (Intrinsics.areEqual((Object)object4, (Object)"message")) {
                String string;
                object2 = value;
                message = object2 == null ? "" : ((string = object2.toString()) == null ? "" : string);
                continue;
            }
            if (Intrinsics.areEqual((Object)object4, (Object)"locations")) {
                List list;
                List locationItems = value instanceof List ? (List)value : null;
                List list2 = locationItems;
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Map map = (Map)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        Error.Location location = INSTANCE.readErrorLocation((Map<String, ? extends Object>)it);
                        collection.add(location);
                    }
                    list = (List)destination$iv$iv;
                }
                List list3 = list;
                locations = list3 == null ? CollectionsKt.emptyList() : list3;
                continue;
            }
            object2 = customAttributes;
            boolean bl6 = false;
            object2.put((String)key, value);
        }
        return new Error(message, locations, customAttributes);
    }

    private final Error.Location readErrorLocation(Map<String, ? extends Object> $this$readErrorLocation) {
        long line = -1L;
        long column = -1L;
        if ($this$readErrorLocation != null) {
            Object object = $this$readErrorLocation;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String key = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                Object value = object3.getValue();
                object3 = key;
                if (Intrinsics.areEqual((Object)object3, (Object)"line")) {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    line = ((Number)value).longValue();
                    continue;
                }
                if (!Intrinsics.areEqual((Object)object3, (Object)"column")) continue;
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                column = ((Number)value).longValue();
            }
        }
        return new Error.Location(line, column);
    }
}

