/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.android.compiler;

import com.apollographql.android.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.android.compiler.InflectorKt;
import com.apollographql.android.compiler.NullableValueType;
import com.apollographql.android.compiler.OperationTypeSpecBuilder;
import com.apollographql.android.compiler.ir.CodeGenerationContext;
import com.apollographql.android.compiler.ir.CodeGenerationIR;
import com.apollographql.android.compiler.ir.Fragment;
import com.apollographql.android.compiler.ir.Operation;
import com.apollographql.android.compiler.ir.TypeDeclaration;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001c\u0010\u0014\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/android/compiler/GraphQLCompiler;", "", "()V", "irAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lcom/apollographql/android/compiler/ir/CodeGenerationIR;", "kotlin.jvm.PlatformType", "moshi", "Lcom/squareup/moshi/Moshi;", "write", "", "args", "Lcom/apollographql/android/compiler/GraphQLCompiler$Arguments;", "supportedScalarTypeMapping", "", "", "typeDeclarations", "", "Lcom/apollographql/android/compiler/ir/TypeDeclaration;", "supportedTypeDeclarations", "writeJavaFiles", "context", "Lcom/apollographql/android/compiler/ir/CodeGenerationContext;", "outputDir", "Ljava/io/File;", "Arguments", "Companion", "apollo-compiler_main"})
public final class GraphQLCompiler {
    private final Moshi moshi = new Moshi.Builder().build();
    private final JsonAdapter<CodeGenerationIR> irAdapter = this.moshi.adapter(CodeGenerationIR.class);
    @NotNull
    public static final String FILE_EXTENSION = "graphql";
    @NotNull
    private static final List<String> OUTPUT_DIRECTORY;
    @NotNull
    public static final String APOLLOCODEGEN_VERSION = "0.10.9";
    public static final Companion Companion;

    public final void write(@NotNull Arguments args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CodeGenerationIR ir = (CodeGenerationIR)this.irAdapter.fromJson(FilesKt.readText$default((File)args.getIrFile(), null, (int)1, null));
        String irPackageName = InflectorKt.formatPackageName(args.getIrFile().getAbsolutePath());
        CharSequence charSequence = irPackageName;
        String fragmentsPackage = charSequence.length() > 0 ? irPackageName + ".fragment" : "fragment";
        CharSequence charSequence2 = irPackageName;
        String typesPackage = charSequence2.length() > 0 ? irPackageName + ".type" : "type";
        Map<String, String> supportedScalarTypeMapping = this.supportedScalarTypeMapping(args.getCustomTypeMap(), ir.getTypesUsed());
        List list = CollectionsKt.emptyList();
        List<TypeDeclaration> list2 = ir.getTypesUsed();
        NullableValueType nullableValueType = args.getNullableValueType();
        boolean bl = args.getGenerateAccessors();
        CodeGenerationIR codeGenerationIR = ir;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeGenerationIR, (String)"ir");
        CodeGenerationContext context = new CodeGenerationContext(list, list2, fragmentsPackage, typesPackage, supportedScalarTypeMapping, nullableValueType, bl, codeGenerationIR);
        this.writeJavaFiles(ir, context, args.getOutputDir());
    }

    /*
     * WARNING - void declaration
     */
    private final void writeJavaFiles(@NotNull CodeGenerationIR $receiver, CodeGenerationContext context, File outputDir) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable typeSpec;
        TypeSpec typeSpec2;
        Object it;
        Object element$iv;
        Object $receiver$iv;
        Iterable iterable = $receiver.getFragments();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (Fragment)element$iv;
            typeSpec2 = ((Fragment)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, 255, null));
            JavaFile.builder((String)context.getFragmentsPackage(), (TypeSpec)typeSpec2).build().writeTo(outputDir);
        }
        $receiver$iv = this.supportedTypeDeclarations($receiver.getTypesUsed());
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (TypeDeclaration)element$iv;
            typeSpec2 = ((TypeDeclaration)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, 255, null));
            JavaFile.builder((String)context.getTypesPackage(), (TypeSpec)typeSpec2).build().writeTo(outputDir);
        }
        $receiver$iv = context.getCustomTypeMap();
        if (!$receiver$iv.isEmpty()) {
            typeSpec = new CustomEnumTypeSpecBuilder(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, 255, null)).build();
            JavaFile.builder((String)context.getTypesPackage(), (TypeSpec)typeSpec).build().writeTo(outputDir);
        }
        typeSpec = $receiver.getOperations();
        iterator = $receiver$iv;
        element$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            Operation $i$a$2$forEach = (Operation)item$iv$iv;
            void var13_10 = destination$iv$iv;
            OperationTypeSpecBuilder operationTypeSpecBuilder = new OperationTypeSpecBuilder((Operation)it2, $receiver.getFragments());
            var13_10.add(operationTypeSpecBuilder);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (OperationTypeSpecBuilder)element$iv;
            String packageName = InflectorKt.formatPackageName(((OperationTypeSpecBuilder)it).getOperation().getFilePath());
            TypeSpec typeSpec3 = ((OperationTypeSpecBuilder)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, 255, null));
            JavaFile.builder((String)packageName, (TypeSpec)typeSpec3).build().writeTo(outputDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeDeclaration> supportedTypeDeclarations(@NotNull List<TypeDeclaration> $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = $receiver;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_ENUM()) || Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_INPUT_OBJECT_TYPE()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> supportedScalarTypeMapping(@NotNull Map<String, String> $receiver, List<TypeDeclaration> typeDeclarations) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable destination$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv = typeDeclarations;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_SCALAR_TYPE())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv2 = $receiver$iv;
        Map map = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void var9_10 = destination$iv$iv;
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            String string = it.getName();
            String string2 = $receiver.get(it.getName());
            if (string2 == null) {
                string2 = "Object";
            }
            Pair pair = TuplesKt.to((Object)string, (Object)string2);
            var9_10.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    static {
        Companion = new Companion(null);
        OUTPUT_DIRECTORY = CollectionsKt.listOf((Object[])new String[]{"generated", "source", "apollo"});
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/android/compiler/GraphQLCompiler$Arguments;", "", "irFile", "Ljava/io/File;", "outputDir", "customTypeMap", "", "", "nullableValueType", "Lcom/apollographql/android/compiler/NullableValueType;", "generateAccessors", "", "(Ljava/io/File;Ljava/io/File;Ljava/util/Map;Lcom/apollographql/android/compiler/NullableValueType;Z)V", "getCustomTypeMap", "()Ljava/util/Map;", "getGenerateAccessors", "()Z", "getIrFile", "()Ljava/io/File;", "getNullableValueType", "()Lcom/apollographql/android/compiler/NullableValueType;", "getOutputDir", "component1", "component2", "component3", "component4", "component5", "copy", "apollo-compiler_main"})
    public static final class Arguments {
        @NotNull
        private final File irFile;
        @NotNull
        private final File outputDir;
        @NotNull
        private final Map<String, String> customTypeMap;
        @NotNull
        private final NullableValueType nullableValueType;
        private final boolean generateAccessors;

        @NotNull
        public final File getIrFile() {
            return this.irFile;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        @NotNull
        public final Map<String, String> getCustomTypeMap() {
            return this.customTypeMap;
        }

        @NotNull
        public final NullableValueType getNullableValueType() {
            return this.nullableValueType;
        }

        public final boolean getGenerateAccessors() {
            return this.generateAccessors;
        }

        public Arguments(@NotNull File irFile, @NotNull File outputDir, @NotNull Map<String, String> customTypeMap, @NotNull NullableValueType nullableValueType, boolean generateAccessors) {
            Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            this.irFile = irFile;
            this.outputDir = outputDir;
            this.customTypeMap = customTypeMap;
            this.nullableValueType = nullableValueType;
            this.generateAccessors = generateAccessors;
        }

        @NotNull
        public final File component1() {
            return this.irFile;
        }

        @NotNull
        public final File component2() {
            return this.outputDir;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.customTypeMap;
        }

        @NotNull
        public final NullableValueType component4() {
            return this.nullableValueType;
        }

        public final boolean component5() {
            return this.generateAccessors;
        }

        @NotNull
        public final Arguments copy(@NotNull File irFile, @NotNull File outputDir, @NotNull Map<String, String> customTypeMap, @NotNull NullableValueType nullableValueType, boolean generateAccessors) {
            Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            return new Arguments(irFile, outputDir, customTypeMap, nullableValueType, generateAccessors);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Arguments copy$default(Arguments arguments, File file, File file2, Map map, NullableValueType nullableValueType, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                file = arguments.irFile;
            }
            if ((n & 2) != 0) {
                file2 = arguments.outputDir;
            }
            if ((n & 4) != 0) {
                map = arguments.customTypeMap;
            }
            if ((n & 8) != 0) {
                nullableValueType = arguments.nullableValueType;
            }
            if ((n & 0x10) != 0) {
                bl = arguments.generateAccessors;
            }
            return arguments.copy(file, file2, map, nullableValueType, bl);
        }

        public String toString() {
            return "Arguments(irFile=" + this.irFile + ", outputDir=" + this.outputDir + ", customTypeMap=" + this.customTypeMap + ", nullableValueType=" + (Object)((Object)this.nullableValueType) + ", generateAccessors=" + this.generateAccessors + ")";
        }

        public int hashCode() {
            File file = this.irFile;
            File file2 = this.outputDir;
            Map<String, String> map = this.customTypeMap;
            NullableValueType nullableValueType = this.nullableValueType;
            int n = ((((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (nullableValueType != null ? ((Object)((Object)nullableValueType)).hashCode() : 0)) * 31;
            int n2 = this.generateAccessors ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Arguments)) break block3;
                    Arguments arguments = (Arguments)object;
                    if (!Intrinsics.areEqual((Object)this.irFile, (Object)arguments.irFile) || !Intrinsics.areEqual((Object)this.outputDir, (Object)arguments.outputDir) || !Intrinsics.areEqual(this.customTypeMap, arguments.customTypeMap) || !Intrinsics.areEqual((Object)((Object)this.nullableValueType), (Object)((Object)arguments.nullableValueType)) || !(this.generateAccessors == arguments.generateAccessors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/apollographql/android/compiler/GraphQLCompiler$Companion;", "", "()V", "APOLLOCODEGEN_VERSION", "", "FILE_EXTENSION", "OUTPUT_DIRECTORY", "", "getOUTPUT_DIRECTORY", "()Ljava/util/List;", "apollo-compiler_main"})
    public static final class Companion {
        @NotNull
        public final List<String> getOUTPUT_DIRECTORY() {
            return OUTPUT_DIRECTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

