/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.rx;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.util.Cancelable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Emitter;
import rx.Observable;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.subscriptions.Subscriptions;

public final class RxApollo {
    private RxApollo() {
    }

    @NotNull
    public static <T> Observable<Response<T>> from(@NotNull ApolloQueryWatcher<T> watcher) {
        return RxApollo.from(watcher, Emitter.BackpressureMode.LATEST);
    }

    @NotNull
    public static <T> Observable<Response<T>> from(final @NotNull ApolloQueryWatcher<T> watcher, @NotNull Emitter.BackpressureMode backpressureMode) {
        Utils.checkNotNull((Object)backpressureMode, (Object)"backpressureMode == null");
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Observable.create((Action1)new Action1<Emitter<Response<T>>>(){

            public void call(final Emitter<Response<T>> emitter) {
                final AtomicBoolean canceled = new AtomicBoolean();
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        canceled.set(true);
                        watcher.cancel();
                    }
                });
                watcher.enqueueAndWatch(new ApolloCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!canceled.get()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!canceled.get()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        }, (Emitter.BackpressureMode)backpressureMode);
    }

    @NotNull
    public static <T> Observable<Response<T>> from(final @NotNull ApolloCall<T> call, Emitter.BackpressureMode backpressureMode) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Observable.create((Action1)new Action1<Emitter<Response<T>>>(){

            public void call(final Emitter<Response<T>> emitter) {
                final AtomicBoolean canceled = new AtomicBoolean();
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        canceled.set(true);
                        call.cancel();
                    }
                });
                call.enqueue(new ApolloCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!canceled.get()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!canceled.get()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                        if (!canceled.get() && event == ApolloCall.StatusEvent.COMPLETED) {
                            emitter.onCompleted();
                        }
                    }
                });
            }
        }, (Emitter.BackpressureMode)backpressureMode);
    }

    @NotNull
    public static <T> Observable<Response<T>> from(final @NotNull ApolloSubscriptionCall<T> call, Emitter.BackpressureMode backpressureMode) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Observable.create((Action1)new Action1<Emitter<Response<T>>>(){

            public void call(final Emitter<Response<T>> emitter) {
                final AtomicBoolean canceled = new AtomicBoolean();
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        canceled.set(true);
                        call.cancel();
                    }
                });
                call.execute(new ApolloSubscriptionCall.Callback<T>(){

                    public void onResponse(@NotNull Response<T> response) {
                        if (!canceled.get()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!canceled.get()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onCompleted() {
                        if (!canceled.get()) {
                            emitter.onCompleted();
                        }
                    }
                });
            }
        }, (Emitter.BackpressureMode)backpressureMode);
    }

    @NotNull
    public static <T> Single<T> from(final @NotNull ApolloStoreOperation<T> operation) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        return Single.create((Single.OnSubscribe)new Single.OnSubscribe<T>(){

            public void call(final SingleSubscriber<? super T> subscriber) {
                operation.enqueue(new ApolloStoreOperation.Callback<T>(){

                    public void onSuccess(T result) {
                        subscriber.onSuccess(result);
                    }

                    public void onFailure(Throwable t) {
                        subscriber.onError(t);
                    }
                });
            }
        });
    }

    @NotNull
    public static <T> Observable<Response<T>> from(@NotNull ApolloCall<T> call) {
        return RxApollo.from(call, Emitter.BackpressureMode.BUFFER);
    }

    @NotNull
    public static <T> Observable<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call) {
        return RxApollo.from(call, Emitter.BackpressureMode.LATEST);
    }

    @NotNull
    public static Completable from(final @NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

            public void call(final CompletableSubscriber subscriber) {
                final Subscription subscription = RxApollo.getSubscription(subscriber, (Cancelable)prefetch);
                prefetch.enqueue(new ApolloPrefetch.Callback(){

                    public void onSuccess() {
                        if (!subscription.isUnsubscribed()) {
                            subscriber.onCompleted();
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!subscription.isUnsubscribed()) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    static Subscription getSubscription(CompletableSubscriber subscriber, final Cancelable cancelable) {
        Subscription subscription = Subscriptions.create((Action0)new Action0(){

            public void call() {
                cancelable.cancel();
            }
        });
        subscriber.onSubscribe(subscription);
        return subscription;
    }
}

