/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.internal.ResponseNormalizer;
import com.apollographql.apollo.cache.normalized.internal.Transaction;
import com.apollographql.apollo.cache.normalized.internal.WriteableStore;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloCacheInterceptor
implements ApolloInterceptor {
    final ApolloStore apolloStore;
    private final ResponseFieldMapper responseFieldMapper;
    private final Executor dispatcher;
    private final boolean writeToCacheAsynchronously;
    final ApolloLogger logger;
    volatile boolean disposed;

    public ApolloCacheInterceptor(@NotNull ApolloStore apolloStore, @NotNull ResponseFieldMapper responseFieldMapper, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, boolean writeToCacheAsynchronously) {
        this.apolloStore = (ApolloStore)Utils.checkNotNull((Object)apolloStore, (Object)"cache == null");
        this.responseFieldMapper = (ResponseFieldMapper)Utils.checkNotNull((Object)responseFieldMapper, (Object)"responseFieldMapper == null");
        this.dispatcher = (Executor)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.writeToCacheAsynchronously = writeToCacheAsynchronously;
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, final @NotNull ApolloInterceptorChain chain, final @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                if (ApolloCacheInterceptor.this.disposed) {
                    return;
                }
                if (request.fetchFromCache) {
                    callBack.onFetch(ApolloInterceptor.FetchSourceType.CACHE);
                    try {
                        ApolloInterceptor.InterceptorResponse cachedResponse = ApolloCacheInterceptor.this.resolveFromCache(request);
                        callBack.onResponse(cachedResponse);
                        callBack.onCompleted();
                    }
                    catch (ApolloException e) {
                        callBack.onFailure(e);
                    }
                } else {
                    ApolloCacheInterceptor.this.writeOptimisticUpdatesAndPublish(request);
                    chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

                        @Override
                        public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse networkResponse) {
                            if (ApolloCacheInterceptor.this.disposed) {
                                return;
                            }
                            ApolloCacheInterceptor.this.cacheResponseAndPublish(request, networkResponse, ApolloCacheInterceptor.this.writeToCacheAsynchronously);
                            callBack.onResponse(networkResponse);
                            callBack.onCompleted();
                        }

                        @Override
                        public void onFailure(@NotNull ApolloException t) {
                            ApolloCacheInterceptor.this.rollbackOptimisticUpdatesAndPublish(request);
                            callBack.onFailure(t);
                        }

                        @Override
                        public void onCompleted() {
                        }

                        @Override
                        public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                            callBack.onFetch(sourceType);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    ApolloInterceptor.InterceptorResponse resolveFromCache(ApolloInterceptor.InterceptorRequest request) throws ApolloException {
        ResponseNormalizer responseNormalizer = this.apolloStore.cacheResponseNormalizer();
        ApolloStoreOperation apolloStoreOperation = this.apolloStore.read(request.operation, this.responseFieldMapper, responseNormalizer, request.cacheHeaders);
        Response cachedResponse = (Response)apolloStoreOperation.execute();
        if (cachedResponse.getData() != null) {
            this.logger.d("Cache HIT for operation %s", new Object[]{request.operation.name().name()});
            return new ApolloInterceptor.InterceptorResponse(null, cachedResponse, responseNormalizer.records());
        }
        this.logger.d("Cache MISS for operation %s", new Object[]{request.operation.name().name()});
        throw new ApolloException(String.format("Cache miss for operation %s", request.operation.name().name()));
    }

    Set<String> cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse, final ApolloInterceptor.InterceptorRequest request) {
        if (networkResponse.parsedResponse.isPresent() && ((Response)networkResponse.parsedResponse.get()).hasErrors() && !request.cacheHeaders.hasHeader("store-partial-responses")) {
            return Collections.emptySet();
        }
        final Optional records = networkResponse.cacheRecords.map((Function)new Function<Collection<Record>, List<Record>>(){

            @NotNull
            public List<Record> apply(@NotNull Collection<Record> records) {
                ArrayList<Record> result = new ArrayList<Record>(records.size());
                for (Record record : records) {
                    result.add(record.toBuilder().mutationId(request.uniqueId).build());
                }
                return result;
            }
        });
        if (!records.isPresent()) {
            return Collections.emptySet();
        }
        try {
            return (Set)this.apolloStore.writeTransaction((Transaction)new Transaction<WriteableStore, Set<String>>(){

                @Nullable
                public Set<String> execute(WriteableStore cache) {
                    return cache.merge((Collection)records.get(), request.cacheHeaders);
                }
            });
        }
        catch (Exception e) {
            this.logger.e("Failed to cache operation response", new Object[]{e});
            return Collections.emptySet();
        }
    }

    void cacheResponseAndPublish(final ApolloInterceptor.InterceptorRequest request, final ApolloInterceptor.InterceptorResponse networkResponse, boolean async) {
        if (async) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    ApolloCacheInterceptor.this.cacheResponseAndPublishSynchronously(request, networkResponse);
                }
            });
        } else {
            this.cacheResponseAndPublishSynchronously(request, networkResponse);
        }
    }

    void cacheResponseAndPublishSynchronously(ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse networkResponse) {
        try {
            Set<String> networkResponseCacheKeys = this.cacheResponse(networkResponse, request);
            Set<String> rolledBackCacheKeys = this.rollbackOptimisticUpdates(request);
            HashSet<String> changedCacheKeys = new HashSet<String>();
            changedCacheKeys.addAll(rolledBackCacheKeys);
            changedCacheKeys.addAll(networkResponseCacheKeys);
            this.publishCacheKeys(changedCacheKeys);
        }
        catch (Exception rethrow) {
            this.rollbackOptimisticUpdatesAndPublish(request);
            throw rethrow;
        }
    }

    void writeOptimisticUpdatesAndPublish(final ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (request.optimisticUpdates.isPresent()) {
                        Operation.Data optimisticUpdates = (Operation.Data)request.optimisticUpdates.get();
                        ApolloCacheInterceptor.this.apolloStore.writeOptimisticUpdatesAndPublish(request.operation, optimisticUpdates, request.uniqueId).execute();
                    }
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e((Throwable)e, "failed to write operation optimistic updates, for: %s", new Object[]{request.operation});
                }
            }
        });
    }

    void rollbackOptimisticUpdatesAndPublish(final ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.rollbackOptimisticUpdatesAndPublish(request.uniqueId).execute();
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e((Throwable)e, "failed to rollback operation optimistic updates, for: %s", new Object[]{request.operation});
                }
            }
        });
    }

    Set<String> rollbackOptimisticUpdates(ApolloInterceptor.InterceptorRequest request) {
        try {
            return (Set)this.apolloStore.rollbackOptimisticUpdates(request.uniqueId).execute();
        }
        catch (Exception e) {
            this.logger.e((Throwable)e, "failed to rollback operation optimistic updates, for: %s", new Object[]{request.operation});
            return Collections.emptySet();
        }
    }

    void publishCacheKeys(final Set<String> cacheKeys) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.publish(cacheKeys);
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e((Throwable)e, "Failed to publish cache changes", new Object[0]);
                }
            }
        });
    }
}

