/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.internal.util.Cancelable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApolloCall<T>
extends Cancelable {
    public void enqueue(@Nullable Callback<T> var1);

    @Deprecated
    @NotNull
    public ApolloCall<T> cacheHeaders(@NotNull CacheHeaders var1);

    @Deprecated
    @NotNull
    public ApolloCall<T> clone();

    @NotNull
    public Operation operation();

    @Override
    public void cancel();

    @NotNull
    public Builder<T> toBuilder();

    public static enum StatusEvent {
        SCHEDULED,
        FETCH_CACHE,
        FETCH_NETWORK,
        COMPLETED;

    }

    public static abstract class Callback<T> {
        public abstract void onResponse(@NotNull Response<T> var1);

        public abstract void onFailure(@NotNull ApolloException var1);

        public void onStatusEvent(@NotNull StatusEvent event) {
        }

        public void onHttpError(@NotNull ApolloHttpException e) {
            this.onFailure(e);
            okhttp3.Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@NotNull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onParseError(@NotNull ApolloParseException e) {
            this.onFailure(e);
        }

        public void onCanceledError(@NotNull ApolloCanceledException e) {
            this.onFailure(e);
        }
    }

    public static interface Builder<T> {
        @NotNull
        public ApolloCall<T> build();

        @NotNull
        public Builder<T> cacheHeaders(@NotNull CacheHeaders var1);
    }
}

