/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.subscription;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Supplier;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionServerException;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.internal.subscription.SubscriptionResponse;
import com.apollographql.apollo.response.OperationResponseParser;
import com.apollographql.apollo.subscription.OnSubscriptionManagerStateChangeListener;
import com.apollographql.apollo.subscription.OperationClientMessage;
import com.apollographql.apollo.subscription.OperationServerMessage;
import com.apollographql.apollo.subscription.SubscriptionConnectionParamsProvider;
import com.apollographql.apollo.subscription.SubscriptionManagerState;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class RealSubscriptionManager
implements SubscriptionManager {
    static final int CONNECTION_ACKNOWLEDGE_TIMEOUT_TIMER_TASK_ID = 1;
    static final int INACTIVITY_TIMEOUT_TIMER_TASK_ID = 2;
    static final int CONNECTION_KEEP_ALIVE_TIMEOUT_TIMER_TASK_ID = 3;
    static final long CONNECTION_ACKNOWLEDGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    static final long INACTIVITY_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    static final String PROTOCOL_NEGOTIATION_ERROR_NOT_FOUND = "PersistedQueryNotFound";
    static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";
    Map<UUID, SubscriptionRecord> subscriptions = new LinkedHashMap<UUID, SubscriptionRecord>();
    volatile SubscriptionManagerState state = SubscriptionManagerState.DISCONNECTED;
    final AutoReleaseTimer timer = new AutoReleaseTimer();
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final SubscriptionTransport transport;
    private final SubscriptionConnectionParamsProvider connectionParams;
    private final Executor dispatcher;
    private final long connectionHeartbeatTimeoutMs;
    private final Supplier<ResponseNormalizer<Map<String, Object>>> responseNormalizer;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final Runnable connectionAcknowledgeTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onConnectionAcknowledgeTimeout();
        }
    };
    private final Runnable inactivityTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onInactivityTimeout();
        }
    };
    private final Runnable connectionHeartbeatTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onConnectionHeartbeatTimeout();
        }
    };
    private final List<OnSubscriptionManagerStateChangeListener> onStateChangeListeners = new CopyOnWriteArrayList<OnSubscriptionManagerStateChangeListener>();
    private final boolean autoPersistSubscription;

    public RealSubscriptionManager(@NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull SubscriptionTransport.Factory transportFactory, @NotNull SubscriptionConnectionParamsProvider connectionParams, @NotNull Executor dispatcher, long connectionHeartbeatTimeoutMs, @NotNull Supplier<ResponseNormalizer<Map<String, Object>>> responseNormalizer, boolean autoPersistSubscription) {
        Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        Utils.checkNotNull((Object)transportFactory, (Object)"transportFactory == null");
        Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        Utils.checkNotNull(responseNormalizer, (Object)"responseNormalizer == null");
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.connectionParams = (SubscriptionConnectionParamsProvider)Utils.checkNotNull((Object)connectionParams, (Object)"connectionParams == null");
        this.transport = transportFactory.create(new SubscriptionTransportCallback(this, dispatcher));
        this.dispatcher = dispatcher;
        this.connectionHeartbeatTimeoutMs = connectionHeartbeatTimeoutMs;
        this.responseNormalizer = responseNormalizer;
        this.autoPersistSubscription = autoPersistSubscription;
    }

    @Override
    public <T> void subscribe(final @NotNull Subscription<?, T, ?> subscription, final @NotNull SubscriptionManager.Callback<T> callback) {
        Utils.checkNotNull(subscription, (Object)"subscription == null");
        Utils.checkNotNull(callback, (Object)"callback == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doSubscribe(subscription, callback);
            }
        });
    }

    public void unsubscribe(final @NotNull Subscription subscription) {
        Utils.checkNotNull((Object)subscription, (Object)"subscription == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doUnsubscribe(subscription);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            if (this.state == SubscriptionManagerState.STOPPED) {
                this.state = SubscriptionManagerState.DISCONNECTED;
            }
        }
        this.notifyStateChanged(oldState, this.state);
    }

    @Override
    public void stop() {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doStop();
            }
        });
    }

    @Override
    public SubscriptionManagerState getState() {
        return this.state;
    }

    @Override
    public void addOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.onStateChangeListeners.add((OnSubscriptionManagerStateChangeListener)Utils.checkNotNull((Object)onStateChangeListener, (Object)"onStateChangeListener == null"));
    }

    @Override
    public void removeOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.onStateChangeListeners.remove(Utils.checkNotNull((Object)onStateChangeListener, (Object)"onStateChangeListener == null"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSubscribe(Subscription subscription, SubscriptionManager.Callback callback) {
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            if (this.state != SubscriptionManagerState.STOPPING && this.state != SubscriptionManagerState.STOPPED) {
                this.timer.cancelTask(2);
                UUID subscriptionId = UUID.randomUUID();
                this.subscriptions.put(subscriptionId, new SubscriptionRecord(subscriptionId, subscription, callback));
                if (this.state == SubscriptionManagerState.DISCONNECTED) {
                    this.state = SubscriptionManagerState.CONNECTING;
                    this.transport.connect();
                } else if (this.state == SubscriptionManagerState.ACTIVE) {
                    this.transport.send(new OperationClientMessage.Start(subscriptionId.toString(), subscription, this.scalarTypeAdapters, this.autoPersistSubscription, false));
                }
            }
        }
        if (oldState == SubscriptionManagerState.STOPPING || oldState == SubscriptionManagerState.STOPPED) {
            callback.onError(new ApolloSubscriptionException("Illegal state: " + this.state.name() + " for subscriptions to be created. SubscriptionManager.start() must be called to re-enable subscriptions."));
        } else if (oldState == SubscriptionManagerState.CONNECTED) {
            callback.onConnected();
        }
        this.notifyStateChanged(oldState, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnsubscribe(Subscription subscription) {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            SubscriptionRecord subscriptionRecord = null;
            for (SubscriptionRecord record : this.subscriptions.values()) {
                if (record.subscription != subscription) continue;
                subscriptionRecord = record;
            }
            if (subscriptionRecord != null) {
                this.subscriptions.remove(subscriptionRecord.id);
                if (this.state == SubscriptionManagerState.ACTIVE || this.state == SubscriptionManagerState.STOPPING) {
                    this.transport.send(new OperationClientMessage.Stop(subscriptionRecord.id.toString()));
                }
            }
            if (this.subscriptions.isEmpty() && this.state != SubscriptionManagerState.STOPPING) {
                this.startInactivityTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        Collection<SubscriptionRecord> subscriptionRecords;
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            this.state = SubscriptionManagerState.STOPPING;
            subscriptionRecords = this.subscriptions.values();
            if (oldState == SubscriptionManagerState.ACTIVE) {
                for (SubscriptionRecord subscriptionRecord : subscriptionRecords) {
                    this.transport.send(new OperationClientMessage.Stop(subscriptionRecord.id.toString()));
                }
            }
            this.state = SubscriptionManagerState.STOPPED;
            this.transport.disconnect(new OperationClientMessage.Terminate());
            this.subscriptions = new LinkedHashMap<UUID, SubscriptionRecord>();
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.notifyOnCompleted();
        }
        this.notifyStateChanged(oldState, SubscriptionManagerState.STOPPING);
        this.notifyStateChanged(SubscriptionManagerState.STOPPING, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTransportConnected() {
        Collection<Object> subscriptionRecords;
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            if (this.state == SubscriptionManagerState.CONNECTING) {
                subscriptionRecords = this.subscriptions.values();
                this.state = SubscriptionManagerState.CONNECTED;
                this.transport.send(new OperationClientMessage.Init(this.connectionParams.provide()));
            } else {
                subscriptionRecords = Collections.emptyList();
            }
            if (this.state == SubscriptionManagerState.CONNECTED) {
                this.timer.schedule(1, this.connectionAcknowledgeTimeoutTimerTask, CONNECTION_ACKNOWLEDGE_TIMEOUT);
            }
        }
        for (SubscriptionRecord subscriptionRecord : subscriptionRecords) {
            subscriptionRecord.callback.onConnected();
        }
        this.notifyStateChanged(oldState, this.state);
    }

    void onConnectionAcknowledgeTimeout() {
        this.timer.cancelTask(1);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.onTransportFailure(new ApolloNetworkException("Subscription server is not responding"));
            }
        });
    }

    void onInactivityTimeout() {
        this.timer.cancelTask(2);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.disconnect(false);
            }
        });
    }

    void onTransportFailure(Throwable t) {
        Collection<SubscriptionRecord> subscriptionRecords = this.disconnect(true);
        for (SubscriptionRecord record : subscriptionRecords) {
            record.notifyOnNetworkError(t);
        }
    }

    void onOperationServerMessage(OperationServerMessage message) {
        if (message instanceof OperationServerMessage.ConnectionAcknowledge) {
            this.onConnectionAcknowledgeServerMessage();
        } else if (message instanceof OperationServerMessage.Data) {
            this.onOperationDataServerMessage((OperationServerMessage.Data)message);
        } else if (message instanceof OperationServerMessage.Error) {
            this.onErrorServerMessage((OperationServerMessage.Error)message);
        } else if (message instanceof OperationServerMessage.Complete) {
            this.onCompleteServerMessage((OperationServerMessage.Complete)message);
        } else if (message instanceof OperationServerMessage.ConnectionError) {
            this.disconnect(true);
        } else if (message instanceof OperationServerMessage.ConnectionKeepAlive) {
            this.resetConnectionKeepAliveTimerTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SubscriptionRecord> disconnect(boolean force) {
        Collection<SubscriptionRecord> subscriptionRecords;
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            subscriptionRecords = this.subscriptions.values();
            if (force || this.subscriptions.isEmpty()) {
                this.transport.disconnect(new OperationClientMessage.Terminate());
                this.state = this.state == SubscriptionManagerState.STOPPING ? SubscriptionManagerState.STOPPED : SubscriptionManagerState.DISCONNECTED;
                this.subscriptions = new LinkedHashMap<UUID, SubscriptionRecord>();
            }
        }
        this.notifyStateChanged(oldState, this.state);
        return subscriptionRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnectionHeartbeatTimeout() {
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            this.state = SubscriptionManagerState.DISCONNECTED;
            this.transport.disconnect(new OperationClientMessage.Terminate());
            this.state = SubscriptionManagerState.CONNECTING;
            this.transport.connect();
        }
        this.notifyStateChanged(oldState, SubscriptionManagerState.DISCONNECTED);
        this.notifyStateChanged(SubscriptionManagerState.DISCONNECTED, SubscriptionManagerState.CONNECTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnectionClosed() {
        Collection<SubscriptionRecord> subscriptionRecords;
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            subscriptionRecords = this.subscriptions.values();
            this.state = SubscriptionManagerState.DISCONNECTED;
            this.subscriptions = new LinkedHashMap<UUID, SubscriptionRecord>();
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.callback.onTerminated();
        }
        this.notifyStateChanged(oldState, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnectionKeepAliveTimerTask() {
        if (this.connectionHeartbeatTimeoutMs <= 0L) {
            return;
        }
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.timer.schedule(3, this.connectionHeartbeatTimeoutTimerTask, this.connectionHeartbeatTimeoutMs);
        }
    }

    private void startInactivityTimer() {
        this.timer.schedule(2, this.inactivityTimeoutTimerTask, INACTIVITY_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOperationDataServerMessage(OperationServerMessage.Data message) {
        SubscriptionRecord subscriptionRecord;
        String subscriptionId = message.id != null ? message.id : "";
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            try {
                subscriptionRecord = this.subscriptions.get(UUID.fromString(subscriptionId));
            }
            catch (IllegalArgumentException e) {
                subscriptionRecord = null;
            }
        }
        if (subscriptionRecord != null) {
            Response<?> response;
            ResponseNormalizer normalizer = (ResponseNormalizer)this.responseNormalizer.get();
            ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create((Operation)subscriptionRecord.subscription);
            OperationResponseParser parser = new OperationResponseParser((Operation<?, ?, ?>)subscriptionRecord.subscription, responseFieldMapper, this.scalarTypeAdapters, normalizer);
            try {
                response = parser.parse(message.payload);
            }
            catch (Exception e) {
                subscriptionRecord = this.removeSubscriptionById(subscriptionId);
                if (subscriptionRecord != null) {
                    subscriptionRecord.notifyOnError(new ApolloSubscriptionException("Failed to parse server message", e));
                }
                return;
            }
            subscriptionRecord.notifyOnResponse(response, normalizer.records());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionAcknowledgeServerMessage() {
        SubscriptionManagerState oldState;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            oldState = this.state;
            this.timer.cancelTask(1);
            if (this.state == SubscriptionManagerState.CONNECTED) {
                this.state = SubscriptionManagerState.ACTIVE;
                for (SubscriptionRecord subscriptionRecord : this.subscriptions.values()) {
                    this.transport.send(new OperationClientMessage.Start(subscriptionRecord.id.toString(), subscriptionRecord.subscription, this.scalarTypeAdapters, this.autoPersistSubscription, false));
                }
            }
        }
        this.notifyStateChanged(oldState, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onErrorServerMessage(OperationServerMessage.Error message) {
        Error error;
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord == null) {
            return;
        }
        boolean resendSubscriptionWithDocument = this.autoPersistSubscription ? PROTOCOL_NEGOTIATION_ERROR_NOT_FOUND.equalsIgnoreCase((error = OperationResponseParser.parseError(message.payload)).message()) || PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED.equalsIgnoreCase(error.message()) : false;
        if (resendSubscriptionWithDocument) {
            RealSubscriptionManager realSubscriptionManager = this;
            synchronized (realSubscriptionManager) {
                this.subscriptions.put(subscriptionRecord.id, subscriptionRecord);
                this.transport.send(new OperationClientMessage.Start(subscriptionRecord.id.toString(), subscriptionRecord.subscription, this.scalarTypeAdapters, true, true));
            }
        } else {
            subscriptionRecord.notifyOnError(new ApolloSubscriptionServerException(message.payload));
        }
    }

    private void onCompleteServerMessage(OperationServerMessage.Complete message) {
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord != null) {
            subscriptionRecord.notifyOnCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionRecord removeSubscriptionById(String subscriptionId) {
        SubscriptionRecord subscriptionRecord;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            try {
                subscriptionRecord = this.subscriptions.remove(UUID.fromString(subscriptionId));
            }
            catch (IllegalArgumentException e) {
                subscriptionRecord = null;
            }
            if (this.subscriptions.isEmpty()) {
                this.startInactivityTimer();
            }
        }
        return subscriptionRecord;
    }

    private void notifyStateChanged(SubscriptionManagerState oldState, SubscriptionManagerState newState) {
        if (oldState == newState) {
            return;
        }
        for (OnSubscriptionManagerStateChangeListener onStateChangeListener : this.onStateChangeListeners) {
            onStateChangeListener.onStateChange(oldState, newState);
        }
    }

    static final class AutoReleaseTimer {
        final Map<Integer, TimerTask> tasks = new LinkedHashMap<Integer, TimerTask>();
        Timer timer;

        AutoReleaseTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(final int taskId, final Runnable task, long delay) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        AutoReleaseTimer.this.cancelTask(taskId);
                    }
                }
            };
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask previousTimerTask = this.tasks.put(taskId, timerTask);
                if (previousTimerTask != null) {
                    previousTimerTask.cancel();
                }
                if (this.timer == null) {
                    this.timer = new Timer("Subscription SmartTimer", true);
                }
                this.timer.schedule(timerTask, delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelTask(int taskId) {
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask timerTask = this.tasks.remove(taskId);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.tasks.isEmpty() && this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
    }

    private static final class SubscriptionTransportCallback
    implements SubscriptionTransport.Callback {
        private final RealSubscriptionManager delegate;
        private final Executor dispatcher;

        SubscriptionTransportCallback(RealSubscriptionManager delegate, Executor dispatcher) {
            this.delegate = delegate;
            this.dispatcher = dispatcher;
        }

        @Override
        public void onConnected() {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportConnected();
                }
            });
        }

        @Override
        public void onFailure(final Throwable t) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportFailure(t);
                }
            });
        }

        @Override
        public void onMessage(final OperationServerMessage message) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onOperationServerMessage(message);
                }
            });
        }

        @Override
        public void onClosed() {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onConnectionClosed();
                }
            });
        }
    }

    private static class SubscriptionRecord {
        final UUID id;
        final Subscription<?, ?, ?> subscription;
        final SubscriptionManager.Callback<?> callback;

        SubscriptionRecord(UUID id, Subscription<?, ?, ?> subscription, SubscriptionManager.Callback<?> callback) {
            this.id = id;
            this.subscription = subscription;
            this.callback = callback;
        }

        void notifyOnResponse(Response response, Collection<Record> cacheRecords) {
            this.callback.onResponse(new SubscriptionResponse(this.subscription, response, cacheRecords));
        }

        void notifyOnError(ApolloSubscriptionException error) {
            this.callback.onError(error);
        }

        void notifyOnNetworkError(Throwable t) {
            this.callback.onNetworkError(t);
        }

        void notifyOnCompleted() {
            this.callback.onCompleted();
        }
    }
}

