/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.response;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.field.MapFieldValueResolver;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.response.RealResponseReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class OperationResponseParser<D extends Operation.Data, W> {
    final Operation<D, W, ?> operation;
    final ResponseFieldMapper responseFieldMapper;
    final ScalarTypeAdapters scalarTypeAdapters;
    final ResponseNormalizer<Map<String, Object>> responseNormalizer;

    public OperationResponseParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters) {
        this(operation, responseFieldMapper, scalarTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
    }

    public OperationResponseParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        this.operation = operation;
        this.responseFieldMapper = responseFieldMapper;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.responseNormalizer = responseNormalizer;
    }

    public Response<W> parse(@NotNull Map<String, Object> payload) {
        List errorPayloads;
        Utils.checkNotNull(payload, (Object)"payload == null");
        this.responseNormalizer.willResolveRootQuery(this.operation);
        Operation.Data data = null;
        Map buffer = (Map)payload.get("data");
        if (buffer != null) {
            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(this.operation.variables(), buffer, new MapFieldValueResolver(), this.scalarTypeAdapters, this.responseNormalizer);
            data = (Operation.Data)this.responseFieldMapper.map(realResponseReader);
        }
        ArrayList<Error> errors = null;
        if (payload.containsKey("errors") && (errorPayloads = (List)payload.get("errors")) != null) {
            errors = new ArrayList<Error>();
            for (Map errorPayload : errorPayloads) {
                errors.add(OperationResponseParser.parseError(errorPayload));
            }
        }
        return Response.builder(this.operation).data(this.operation.wrapData(data)).errors(errors).dependentKeys(this.responseNormalizer.dependentKeys()).extensions((Map)payload.get("extensions")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<W> parse(BufferedSource source) throws IOException {
        this.responseNormalizer.willResolveRootQuery(this.operation);
        try (BufferedSourceJsonReader jsonReader = null;){
            jsonReader = new BufferedSourceJsonReader(source);
            jsonReader.beginObject();
            Operation.Data data = null;
            List<Error> errors = null;
            Map extensions = null;
            ResponseJsonStreamReader responseStreamReader = ApolloJsonReader.responseJsonStreamReader(jsonReader);
            while (responseStreamReader.hasNext()) {
                String name = responseStreamReader.nextName();
                if ("data".equals(name)) {
                    data = (Operation.Data)responseStreamReader.nextObject(true, (ResponseJsonStreamReader.ObjectReader)new ResponseJsonStreamReader.ObjectReader<Object>(){

                        public Object read(ResponseJsonStreamReader reader) throws IOException {
                            Map buffer = reader.toMap();
                            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(OperationResponseParser.this.operation.variables(), buffer, new MapFieldValueResolver(), OperationResponseParser.this.scalarTypeAdapters, OperationResponseParser.this.responseNormalizer);
                            return OperationResponseParser.this.responseFieldMapper.map(realResponseReader);
                        }
                    });
                    continue;
                }
                if ("errors".equals(name)) {
                    errors = this.readResponseErrors(responseStreamReader);
                    continue;
                }
                if ("extensions".equals(name)) {
                    extensions = (Map)responseStreamReader.nextObject(true, (ResponseJsonStreamReader.ObjectReader)new ResponseJsonStreamReader.ObjectReader<Map<String, Object>>(){

                        public Map<String, Object> read(ResponseJsonStreamReader reader) throws IOException {
                            return reader.toMap();
                        }
                    });
                    continue;
                }
                responseStreamReader.skipNext();
            }
            jsonReader.endObject();
            Response response = Response.builder(this.operation).data(this.operation.wrapData(data)).errors(errors).dependentKeys(this.responseNormalizer.dependentKeys()).extensions(extensions).build();
            return response;
        }
    }

    private List<Error> readResponseErrors(ResponseJsonStreamReader reader) throws IOException {
        return reader.nextList(true, (ResponseJsonStreamReader.ListReader)new ResponseJsonStreamReader.ListReader<Error>(){

            public Error read(ResponseJsonStreamReader reader) throws IOException {
                return (Error)reader.nextObject(true, (ResponseJsonStreamReader.ObjectReader)new ResponseJsonStreamReader.ObjectReader<Error>(){

                    public Error read(ResponseJsonStreamReader reader) throws IOException {
                        return OperationResponseParser.parseError(reader.toMap());
                    }
                });
            }
        });
    }

    public static Error parseError(Map<String, Object> payload) {
        String message = null;
        ArrayList<Error.Location> locations = new ArrayList<Error.Location>();
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            if ("message".equals(entry.getKey())) {
                Object value = entry.getValue();
                message = value != null ? value.toString() : null;
                continue;
            }
            if ("locations".equals(entry.getKey())) {
                List locationItems = (List)entry.getValue();
                if (locationItems == null) continue;
                for (Map item : locationItems) {
                    locations.add(OperationResponseParser.parseErrorLocation(item));
                }
                continue;
            }
            if (entry.getValue() == null) continue;
            customAttributes.put(entry.getKey(), entry.getValue());
        }
        return new Error(message, locations, customAttributes);
    }

    private static Error.Location parseErrorLocation(Map<String, Object> data) {
        long line = -1L;
        long column = -1L;
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if ("line".equals(entry.getKey())) {
                    line = ((Number)entry.getValue()).longValue();
                    continue;
                }
                if (!"column".equals(entry.getKey())) continue;
                column = ((Number)entry.getValue()).longValue();
            }
        }
        return new Error.Location(line, column);
    }
}

