/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class ApolloAutoPersistedQueryInterceptor
implements ApolloInterceptor {
    private static final String PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND = "PersistedQueryNotFound";
    private static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";
    private final ApolloLogger logger;
    private volatile boolean disposed;
    final boolean useHttpGetMethodForPersistedQueries;

    public ApolloAutoPersistedQueryInterceptor(@NotNull ApolloLogger logger, boolean useHttpGetMethodForPersistedQueries) {
        this.logger = logger;
        this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, final @NotNull ApolloInterceptorChain chain, final @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        ApolloInterceptor.InterceptorRequest newRequest = request.toBuilder().sendQueryDocument(false).autoPersistQueries(true).useHttpGetMethodForQueries(request.useHttpGetMethodForQueries || this.useHttpGetMethodForPersistedQueries).build();
        chain.proceedAsync(newRequest, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                if (ApolloAutoPersistedQueryInterceptor.this.disposed) {
                    return;
                }
                Optional<ApolloInterceptor.InterceptorRequest> retryRequest = ApolloAutoPersistedQueryInterceptor.this.handleProtocolNegotiation(request, response);
                if (retryRequest.isPresent()) {
                    chain.proceedAsync((ApolloInterceptor.InterceptorRequest)retryRequest.get(), dispatcher, callBack);
                } else {
                    callBack.onResponse(response);
                    callBack.onCompleted();
                }
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                callBack.onFetch(sourceType);
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    Optional<ApolloInterceptor.InterceptorRequest> handleProtocolNegotiation(final ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        return response.parsedResponse.flatMap((Function)new Function<Response, Optional<ApolloInterceptor.InterceptorRequest>>(){

            @NotNull
            public Optional<ApolloInterceptor.InterceptorRequest> apply(@NotNull Response response) {
                if (response.hasErrors()) {
                    if (ApolloAutoPersistedQueryInterceptor.this.isPersistedQueryNotFound(response.errors())) {
                        ApolloAutoPersistedQueryInterceptor.this.logger.w("GraphQL server couldn't find Automatic Persisted Query for operation name: " + request.operation.name().name() + " id: " + request.operation.operationId(), new Object[0]);
                        return Optional.of((Object)request);
                    }
                    if (ApolloAutoPersistedQueryInterceptor.this.isPersistedQueryNotSupported(response.errors())) {
                        ApolloAutoPersistedQueryInterceptor.this.logger.e("GraphQL server doesn't support Automatic Persisted Queries", new Object[0]);
                        return Optional.of((Object)request);
                    }
                }
                return Optional.absent();
            }
        });
    }

    boolean isPersistedQueryNotFound(List<Error> errors) {
        for (Error error : errors) {
            if (!PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND.equalsIgnoreCase(error.message())) continue;
            return true;
        }
        return false;
    }

    boolean isPersistedQueryNotSupported(List<Error> errors) {
        for (Error error : errors) {
            if (!PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED.equalsIgnoreCase(error.message())) continue;
            return true;
        }
        return false;
    }
}

