/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.response;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import com.apollographql.apollo.internal.response.ResolveDelegate;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.CustomTypeValue;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RealResponseReader<R>
implements ResponseReader {
    final Operation.Variables operationVariables;
    private final R recordSet;
    final ScalarTypeAdapters scalarTypeAdapters;
    final FieldValueResolver<R> fieldValueResolver;
    final ResolveDelegate<R> resolveDelegate;
    private final Map<String, Object> variableValues;

    public RealResponseReader(Operation.Variables operationVariables, R recordSet, FieldValueResolver<R> fieldValueResolver, ScalarTypeAdapters scalarTypeAdapters, ResolveDelegate<R> resolveDelegate) {
        this.operationVariables = operationVariables;
        this.recordSet = recordSet;
        this.fieldValueResolver = fieldValueResolver;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.resolveDelegate = resolveDelegate;
        this.variableValues = operationVariables.valueMap();
    }

    public String readString(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public Integer readInt(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public Long readLong(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Double readDouble(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    public Boolean readBoolean(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        Boolean value = (Boolean)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public <T> T readObject(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        Object parsedValue;
        if (this.shouldSkip(field)) {
            return null;
        }
        Object value = this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        this.resolveDelegate.willResolveObject(field, Optional.fromNullable(value));
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            parsedValue = null;
        } else {
            parsedValue = objectReader.read(new RealResponseReader(this.operationVariables, value, this.fieldValueResolver, this.scalarTypeAdapters, this.resolveDelegate));
        }
        this.resolveDelegate.didResolveObject(field, Optional.fromNullable(value));
        this.didResolve(field);
        return (T)parsedValue;
    }

    public <T> List<T> readList(ResponseField field, ResponseReader.ListReader<T> listReader) {
        ArrayList<Object> result;
        if (this.shouldSkip(field)) {
            return null;
        }
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, values);
        this.willResolve(field, values);
        if (values == null) {
            this.resolveDelegate.didResolveNull();
            result = null;
        } else {
            result = new ArrayList<Object>();
            for (int i = 0; i < values.size(); ++i) {
                this.resolveDelegate.willResolveElement(i);
                Object value = values.get(i);
                if (value == null) {
                    result.add(null);
                    this.resolveDelegate.didResolveNull();
                } else {
                    Object item = listReader.read((ResponseReader.ListItemReader)new ListItemReader(field, value));
                    result.add(item);
                }
                this.resolveDelegate.didResolveElement(i);
            }
            this.resolveDelegate.didResolveList(values);
        }
        this.didResolve(field);
        return result != null ? Collections.unmodifiableList(result) : null;
    }

    public <T> T readCustomType(ResponseField.CustomTypeField field) {
        Object result;
        if (this.shouldSkip((ResponseField)field)) {
            return null;
        }
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (ResponseField)field);
        this.checkValue((ResponseField)field, value);
        this.willResolve((ResponseField)field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            result = null;
        } else {
            CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
            result = typeAdapter.decode(CustomTypeValue.fromRawValue(value));
            this.checkValue((ResponseField)field, result);
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve((ResponseField)field);
        return (T)result;
    }

    public <T> T readFragment(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            this.didResolve(field);
            return null;
        }
        this.resolveDelegate.didResolveScalar(value);
        this.didResolve(field);
        if (field.type() == ResponseField.Type.FRAGMENT) {
            for (ResponseField.Condition condition : field.conditions()) {
                if (!(condition instanceof ResponseField.TypeNameCondition) || !((ResponseField.TypeNameCondition)condition).typeNames().contains(value)) continue;
                return (T)objectReader.read((ResponseReader)this);
            }
        }
        return null;
    }

    private boolean shouldSkip(ResponseField field) {
        for (ResponseField.Condition condition : field.conditions()) {
            if (!(condition instanceof ResponseField.BooleanCondition)) continue;
            ResponseField.BooleanCondition booleanCondition = (ResponseField.BooleanCondition)condition;
            Boolean conditionValue = (Boolean)this.variableValues.get(booleanCondition.variableName());
            if (!(booleanCondition.inverted() ? Boolean.TRUE.equals(conditionValue) : Boolean.FALSE.equals(conditionValue))) continue;
            return true;
        }
        return false;
    }

    private void willResolve(ResponseField field, Object value) {
        this.resolveDelegate.willResolve(field, this.operationVariables, Optional.fromNullable((Object)value));
    }

    private void didResolve(ResponseField field) {
        this.resolveDelegate.didResolve(field, this.operationVariables);
    }

    private void checkValue(ResponseField field, Object value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException("corrupted response reader, expected non null value for " + field.fieldName());
        }
    }

    private class ListItemReader
    implements ResponseReader.ListItemReader {
        private final ResponseField field;
        private final Object value;

        ListItemReader(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }

        public String readString() {
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return (String)this.value;
        }

        public Integer readInt() {
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return ((BigDecimal)this.value).intValue();
        }

        public Long readLong() {
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return ((BigDecimal)this.value).longValue();
        }

        public Double readDouble() {
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return ((BigDecimal)this.value).doubleValue();
        }

        public Boolean readBoolean() {
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return (Boolean)this.value;
        }

        public <T> T readCustomType(ScalarType scalarType) {
            CustomTypeAdapter typeAdapter = RealResponseReader.this.scalarTypeAdapters.adapterFor(scalarType);
            RealResponseReader.this.resolveDelegate.didResolveScalar(this.value);
            return (T)typeAdapter.decode(CustomTypeValue.fromRawValue((Object)this.value));
        }

        public <T> T readObject(ResponseReader.ObjectReader<T> objectReader) {
            Object value = this.value;
            RealResponseReader.this.resolveDelegate.willResolveObject(this.field, Optional.fromNullable((Object)value));
            Object item = objectReader.read(new RealResponseReader<Object>(RealResponseReader.this.operationVariables, value, RealResponseReader.this.fieldValueResolver, RealResponseReader.this.scalarTypeAdapters, RealResponseReader.this.resolveDelegate));
            RealResponseReader.this.resolveDelegate.didResolveObject(this.field, Optional.fromNullable((Object)value));
            return (T)item;
        }

        public <T> List<T> readList(ResponseReader.ListReader<T> listReader) {
            List values = (List)this.value;
            if (values == null) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < values.size(); ++i) {
                RealResponseReader.this.resolveDelegate.willResolveElement(i);
                Object value = values.get(i);
                if (value == null) {
                    result.add(null);
                    RealResponseReader.this.resolveDelegate.didResolveNull();
                } else {
                    Object item = listReader.read((ResponseReader.ListItemReader)new ListItemReader(this.field, value));
                    result.add(item);
                }
                RealResponseReader.this.resolveDelegate.didResolveElement(i);
            }
            RealResponseReader.this.resolveDelegate.didResolveList(values);
            return Collections.unmodifiableList(result);
        }
    }
}

