/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.subscription;

import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

public abstract class OperationClientMessage {
    static final String JSON_KEY_ID = "id";
    static final String JSON_KEY_TYPE = "type";
    static final String JSON_KEY_PAYLOAD = "payload";

    OperationClientMessage() {
    }

    public String toJsonString() {
        try {
            Buffer buffer = new Buffer();
            JsonWriter writer = JsonWriter.of((BufferedSink)buffer);
            writer.beginObject();
            this.writeToJson(writer);
            writer.endObject();
            writer.close();
            return buffer.readUtf8();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize to json", e);
        }
    }

    public abstract void writeToJson(@NotNull JsonWriter var1) throws IOException;

    public static final class Terminate
    extends OperationClientMessage {
        private static final String TYPE = "connection_terminate";

        @Override
        public void writeToJson(@NotNull JsonWriter writer) throws IOException {
            Utils.checkNotNull((Object)writer, (Object)"writer == null");
            writer.name(OperationClientMessage.JSON_KEY_TYPE).value(TYPE);
        }
    }

    public static final class Stop
    extends OperationClientMessage {
        private static final String TYPE = "stop";
        public final String subscriptionId;

        public Stop(@NotNull String subscriptionId) {
            this.subscriptionId = (String)Utils.checkNotNull((Object)subscriptionId, (Object)"subscriptionId == null");
        }

        @Override
        public void writeToJson(@NotNull JsonWriter writer) throws IOException {
            Utils.checkNotNull((Object)writer, (Object)"writer == null");
            writer.name(OperationClientMessage.JSON_KEY_ID).value(this.subscriptionId);
            writer.name(OperationClientMessage.JSON_KEY_TYPE).value(TYPE);
        }
    }

    public static final class Start
    extends OperationClientMessage {
        private static final String TYPE = "start";
        private static final String JSON_KEY_QUERY = "query";
        private static final String JSON_KEY_VARIABLES = "variables";
        private static final String JSON_KEY_OPERATION_NAME = "operationName";
        private static final String JSON_KEY_EXTENSIONS = "extensions";
        private static final String JSON_KEY_EXTENSIONS_PERSISTED_QUERY = "persistedQuery";
        private static final String JSON_KEY_EXTENSIONS_PERSISTED_QUERY_VERSION = "version";
        private static final String JSON_KEY_EXTENSIONS_PERSISTED_QUERY_HASH = "sha256Hash";
        private final ScalarTypeAdapters scalarTypeAdapters;
        public final String subscriptionId;
        public final Subscription<?, ?, ?> subscription;
        public final boolean autoPersistSubscription;
        public final boolean sendSubscriptionDocument;

        public Start(@NotNull String subscriptionId, @NotNull Subscription<?, ?, ?> subscription, @NotNull ScalarTypeAdapters scalarTypeAdapters, boolean autoPersistSubscription, boolean sendSubscriptionDocument) {
            this.subscriptionId = (String)Utils.checkNotNull((Object)subscriptionId, (Object)"subscriptionId == null");
            this.subscription = (Subscription)Utils.checkNotNull(subscription, (Object)"subscription == null");
            this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
            this.autoPersistSubscription = autoPersistSubscription;
            this.sendSubscriptionDocument = sendSubscriptionDocument;
        }

        @Override
        public void writeToJson(@NotNull JsonWriter writer) throws IOException {
            Utils.checkNotNull((Object)writer, (Object)"writer == null");
            writer.name(OperationClientMessage.JSON_KEY_ID).value(this.subscriptionId);
            writer.name(OperationClientMessage.JSON_KEY_TYPE).value(TYPE);
            writer.name(OperationClientMessage.JSON_KEY_PAYLOAD).beginObject();
            writer.name(JSON_KEY_VARIABLES).jsonValue(this.subscription.variables().marshal(this.scalarTypeAdapters));
            writer.name(JSON_KEY_OPERATION_NAME).value(this.subscription.name().name());
            if (!this.autoPersistSubscription || this.sendSubscriptionDocument) {
                writer.name(JSON_KEY_QUERY).value(this.subscription.queryDocument());
            }
            if (this.autoPersistSubscription) {
                writer.name(JSON_KEY_EXTENSIONS).beginObject().name(JSON_KEY_EXTENSIONS_PERSISTED_QUERY).beginObject().name(JSON_KEY_EXTENSIONS_PERSISTED_QUERY_VERSION).value(1L).name(JSON_KEY_EXTENSIONS_PERSISTED_QUERY_HASH).value(this.subscription.operationId()).endObject().endObject();
            }
            writer.endObject();
        }
    }

    public static final class Init
    extends OperationClientMessage {
        private static final String TYPE = "connection_init";
        private final Map<String, Object> connectionParams;

        public Init(@NotNull Map<String, Object> connectionParams) {
            this.connectionParams = (Map)Utils.checkNotNull(connectionParams, (Object)"connectionParams == null");
        }

        @Override
        public void writeToJson(@NotNull JsonWriter writer) throws IOException {
            Utils.checkNotNull((Object)writer, (Object)"writer == null");
            writer.name(OperationClientMessage.JSON_KEY_TYPE).value(TYPE);
            if (!this.connectionParams.isEmpty()) {
                writer.name(OperationClientMessage.JSON_KEY_PAYLOAD);
                com.apollographql.apollo.api.internal.json.Utils.writeToJson(this.connectionParams, (JsonWriter)writer);
            }
        }
    }
}

