/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.response;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.internal.response.RealResponseWriter;
import com.apollographql.apollo.internal.response.ResolveDelegate;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OperationJsonWriter {
    private final Operation.Data operationData;
    private final ScalarTypeAdapters scalarTypeAdapters;

    public OperationJsonWriter(Operation.Data operationData, ScalarTypeAdapters scalarTypeAdapters) {
        this.operationData = operationData;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    public void write(@NotNull JsonWriter jsonWriter) throws IOException {
        Utils.checkNotNull((Object)jsonWriter, (Object)"jsonWriter == null");
        RealResponseWriter realResponseWriter = new RealResponseWriter(Operation.EMPTY_VARIABLES, this.scalarTypeAdapters);
        this.operationData.marshaller().marshal((ResponseWriter)realResponseWriter);
        jsonWriter.beginObject();
        jsonWriter.name("data");
        jsonWriter.beginObject();
        try {
            realResponseWriter.resolveFields(new JsonResponseResolver(jsonWriter));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private static final class JsonResponseResolver
    implements ResolveDelegate<Map<String, Object>> {
        private final JsonWriter jsonWriter;

        JsonResponseResolver(JsonWriter jsonWriter) {
            this.jsonWriter = jsonWriter;
        }

        @Override
        public void willResolveRootQuery(Operation operation) {
        }

        @Override
        public void willResolve(ResponseField field, Operation.Variables variables) {
            try {
                this.jsonWriter.name(field.responseName());
                if (field.type() == ResponseField.Type.LIST) {
                    this.jsonWriter.beginArray();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void didResolve(ResponseField field, Operation.Variables variables) {
        }

        @Override
        public void didResolveScalar(Object value) {
            try {
                if (value instanceof Number) {
                    this.jsonWriter.value((Number)value);
                } else if (value instanceof Boolean) {
                    this.jsonWriter.value(((Boolean)value).booleanValue());
                } else {
                    this.jsonWriter.value(value.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void willResolveObject(ResponseField field, Optional<Map<String, Object>> objectSource) {
            try {
                this.jsonWriter.beginObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void didResolveObject(ResponseField field, Optional<Map<String, Object>> objectSource) {
            try {
                this.jsonWriter.endObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void didResolveList(List array) {
            try {
                this.jsonWriter.endArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void willResolveElement(int atIndex) {
        }

        @Override
        public void didResolveElement(int atIndex) {
        }

        @Override
        public void didResolveNull() {
            try {
                this.jsonWriter.nullValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

