/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.response;

import com.apollographql.apollo.api.FileUpload;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.CustomTypeValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ScalarTypeAdapters {
    private static final Map<Class, CustomTypeAdapter> DEFAULT_ADAPTERS = ScalarTypeAdapters.defaultAdapters();
    private final Map<String, CustomTypeAdapter> customAdapters;

    public ScalarTypeAdapters(@NotNull Map<ScalarType, CustomTypeAdapter> customAdapters) {
        Map nonNullcustomAdapters = (Map)Utils.checkNotNull(customAdapters, (Object)"customAdapters == null");
        this.customAdapters = new HashMap<String, CustomTypeAdapter>();
        for (Map.Entry entry : nonNullcustomAdapters.entrySet()) {
            this.customAdapters.put(((ScalarType)entry.getKey()).typeName(), (CustomTypeAdapter)entry.getValue());
        }
    }

    @NotNull
    public <T> CustomTypeAdapter<T> adapterFor(@NotNull ScalarType scalarType) {
        Utils.checkNotNull((Object)scalarType, (Object)"scalarType == null");
        CustomTypeAdapter customTypeAdapter = this.customAdapters.get(scalarType.typeName());
        if (customTypeAdapter == null) {
            customTypeAdapter = DEFAULT_ADAPTERS.get(scalarType.javaType());
        }
        if (customTypeAdapter == null) {
            throw new IllegalArgumentException(String.format("Can't map GraphQL type: %s to: %s. Did you forget to add custom type adapter?", scalarType.typeName(), scalarType.javaType()));
        }
        return customTypeAdapter;
    }

    private static Map<Class, CustomTypeAdapter> defaultAdapters() {
        LinkedHashMap<Class, CustomTypeAdapter> adapters = new LinkedHashMap<Class, CustomTypeAdapter>();
        adapters.put(String.class, new DefaultCustomTypeAdapter<String>(){

            @Override
            @NotNull
            public String decode(@NotNull CustomTypeValue value) {
                return value.value.toString();
            }
        });
        adapters.put(Boolean.class, new DefaultCustomTypeAdapter<Boolean>(){

            @Override
            @NotNull
            public Boolean decode(@NotNull CustomTypeValue value) {
                if (value instanceof CustomTypeValue.GraphQLBoolean) {
                    return (Boolean)value.value;
                }
                if (value instanceof CustomTypeValue.GraphQLString) {
                    return Boolean.parseBoolean((String)((CustomTypeValue.GraphQLString)value).value);
                }
                throw new IllegalArgumentException("Can't map: " + value + " to Boolean");
            }
        });
        adapters.put(Integer.class, new DefaultCustomTypeAdapter<Integer>(){

            @Override
            @NotNull
            public Integer decode(@NotNull CustomTypeValue value) {
                if (value instanceof CustomTypeValue.GraphQLNumber) {
                    return ((Number)value.value).intValue();
                }
                if (value instanceof CustomTypeValue.GraphQLString) {
                    return Integer.parseInt((String)((CustomTypeValue.GraphQLString)value).value);
                }
                throw new IllegalArgumentException("Can't map: " + value + " to Integer");
            }
        });
        adapters.put(Long.class, new DefaultCustomTypeAdapter<Long>(){

            @Override
            @NotNull
            public Long decode(@NotNull CustomTypeValue value) {
                if (value instanceof CustomTypeValue.GraphQLNumber) {
                    return ((Number)value.value).longValue();
                }
                if (value instanceof CustomTypeValue.GraphQLString) {
                    return Long.parseLong((String)((CustomTypeValue.GraphQLString)value).value);
                }
                throw new IllegalArgumentException("Can't map: " + value + " to Long");
            }
        });
        adapters.put(Float.class, new DefaultCustomTypeAdapter<Float>(){

            @Override
            @NotNull
            public Float decode(@NotNull CustomTypeValue value) {
                if (value instanceof CustomTypeValue.GraphQLNumber) {
                    return Float.valueOf(((Number)value.value).floatValue());
                }
                if (value instanceof CustomTypeValue.GraphQLString) {
                    return Float.valueOf(Float.parseFloat((String)((CustomTypeValue.GraphQLString)value).value));
                }
                throw new IllegalArgumentException("Can't map: " + value + " to Float");
            }
        });
        adapters.put(Double.class, new DefaultCustomTypeAdapter<Double>(){

            @Override
            @NotNull
            public Double decode(@NotNull CustomTypeValue value) {
                if (value instanceof CustomTypeValue.GraphQLNumber) {
                    return ((Number)value.value).doubleValue();
                }
                if (value instanceof CustomTypeValue.GraphQLString) {
                    return Double.parseDouble((String)((CustomTypeValue.GraphQLString)value).value);
                }
                throw new IllegalArgumentException("Can't map: " + value + " to Double");
            }
        });
        adapters.put(FileUpload.class, new CustomTypeAdapter<FileUpload>(){

            @Override
            public FileUpload decode(@NotNull CustomTypeValue value) {
                return null;
            }

            @Override
            @NotNull
            public CustomTypeValue encode(@NotNull FileUpload value) {
                return new CustomTypeValue.GraphQLString(null);
            }
        });
        return adapters;
    }

    private static abstract class DefaultCustomTypeAdapter<T>
    implements CustomTypeAdapter<T> {
        private DefaultCustomTypeAdapter() {
        }

        @Override
        @NotNull
        public CustomTypeValue encode(@NotNull T value) {
            return CustomTypeValue.fromRawValue(value);
        }
    }
}

