/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class CacheHeaders {
    private final Map<String, String> headerMap;
    public static final CacheHeaders NONE = new CacheHeaders(Collections.emptyMap());

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = CacheHeaders.builder();
        builder.addHeaders(this.headerMap);
        return builder;
    }

    CacheHeaders(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    @Nullable
    public String headerValue(String header) {
        return this.headerMap.get(header);
    }

    public boolean hasHeader(String headerName) {
        return this.headerMap.containsKey(headerName);
    }

    public static final class Builder {
        private final Map<String, String> headerMap = new LinkedHashMap<String, String>();

        public Builder addHeader(String headerName, String headerValue) {
            this.headerMap.put(headerName, headerValue);
            return this;
        }

        public Builder addHeaders(Map<String, String> headerMap) {
            this.headerMap.putAll(headerMap);
            return this;
        }

        public CacheHeaders build() {
            return new CacheHeaders(this.headerMap);
        }
    }
}

