/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.subscription;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionServerException;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.response.OperationResponseParser;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import com.apollographql.apollo.subscription.OperationClientMessage;
import com.apollographql.apollo.subscription.OperationServerMessage;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class RealSubscriptionManager
implements SubscriptionManager {
    static final int CONNECTION_ACKNOWLEDGE_TIMEOUT_TIMER_TASK_ID = 1;
    static final int INACTIVITY_TIMEOUT_TIMER_TASK_ID = 2;
    static final int CONNECTION_KEEP_ALIVE_TIMEOUT_TIMER_TASK_ID = 3;
    static final long CONNECTION_ACKNOWLEDGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    static final long INACTIVITY_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    Map<String, SubscriptionRecord> subscriptions = new LinkedHashMap<String, SubscriptionRecord>();
    volatile State state = State.DISCONNECTED;
    final AutoReleaseTimer timer = new AutoReleaseTimer();
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final SubscriptionTransport transport;
    private Map<String, Object> connectionParams;
    private final Executor dispatcher;
    private final long connectionHeartbeatTimeoutMs;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final Runnable connectionAcknowledgeTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onConnectionAcknowledgeTimeout();
        }
    };
    private final Runnable inactivityTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onInactivityTimeout();
        }
    };
    private final Runnable connectionHeartbeatTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onConnectionHeartbeatTimeout();
        }
    };
    private final List<OnStateChangeListener> onStateChangeListeners = new CopyOnWriteArrayList<OnStateChangeListener>();

    public RealSubscriptionManager(@NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull SubscriptionTransport.Factory transportFactory, @NotNull Map<String, Object> connectionParams, @NotNull Executor dispatcher, long connectionHeartbeatTimeoutMs) {
        Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        Utils.checkNotNull((Object)transportFactory, (Object)"transportFactory == null");
        Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.connectionParams = (Map)Utils.checkNotNull(connectionParams, (Object)"connectionParams == null");
        this.transport = transportFactory.create(new SubscriptionTransportCallback(this, dispatcher));
        this.dispatcher = dispatcher;
        this.connectionHeartbeatTimeoutMs = connectionHeartbeatTimeoutMs;
    }

    @Override
    public <T> void subscribe(final @NotNull Subscription<?, T, ?> subscription, final @NotNull SubscriptionManager.Callback<T> callback) {
        Utils.checkNotNull(subscription, (Object)"subscription == null");
        Utils.checkNotNull(callback, (Object)"callback == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doSubscribe(subscription, callback);
            }
        });
    }

    public void unsubscribe(final @NotNull Subscription subscription) {
        Utils.checkNotNull((Object)subscription, (Object)"subscription == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doUnsubscribe(subscription);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            if (this.state == State.STOPPED) {
                this.setStateAndNotify(State.DISCONNECTED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.setStateAndNotify(State.STOPPING);
            ArrayList<SubscriptionRecord> values = new ArrayList<SubscriptionRecord>(this.subscriptions.values());
            for (SubscriptionRecord subscription : values) {
                this.doUnsubscribe(subscription.subscription);
            }
            this.disconnect(true);
        }
    }

    public void addOnStateChangeListener(@NotNull OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListeners.add((OnStateChangeListener)Utils.checkNotNull((Object)onStateChangeListener, (Object)"onStateChangeListener == null"));
    }

    public void removeOnStateChangeListener(@NotNull OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListeners.remove(Utils.checkNotNull((Object)onStateChangeListener, (Object)"onStateChangeListener == null"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSubscribe(Subscription subscription, SubscriptionManager.Callback callback) {
        if (this.state == State.STOPPING || this.state == State.STOPPED) {
            callback.onError(new ApolloSubscriptionException("Illegal state: " + this.state.name() + " for subscriptions to be created. SubscriptionManager.start() must be called to re-enable subscriptions."));
            return;
        }
        this.timer.cancelTask(2);
        String subscriptionId = RealSubscriptionManager.idForSubscription(subscription);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            if (this.subscriptions.containsKey(subscriptionId)) {
                callback.onError(new ApolloSubscriptionException("Already subscribed"));
                return;
            }
            this.subscriptions.put(subscriptionId, new SubscriptionRecord(subscription, callback));
            if (this.state == State.DISCONNECTED) {
                this.setStateAndNotify(State.CONNECTING);
                this.transport.connect();
            } else if (this.state == State.ACTIVE) {
                this.transport.send(new OperationClientMessage.Start(subscriptionId, subscription, this.scalarTypeAdapters));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnsubscribe(Subscription subscription) {
        String subscriptionId = RealSubscriptionManager.idForSubscription(subscription);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            SubscriptionRecord subscriptionRecord = this.subscriptions.remove(subscriptionId);
            if (subscriptionRecord != null && (this.state == State.ACTIVE || this.state == State.STOPPING)) {
                this.transport.send(new OperationClientMessage.Stop(subscriptionId));
            }
            if (this.subscriptions.isEmpty() && this.state != State.STOPPING) {
                this.startInactivityTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTransportConnected() {
        Collection<SubscriptionRecord> subscriptionRecords;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecords = this.subscriptions.values();
            this.setStateAndNotify(State.CONNECTED);
            this.transport.send(new OperationClientMessage.Init(this.connectionParams));
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.callback.onConnected();
        }
        this.timer.schedule(1, this.connectionAcknowledgeTimeoutTimerTask, CONNECTION_ACKNOWLEDGE_TIMEOUT);
    }

    void onConnectionAcknowledgeTimeout() {
        this.timer.cancelTask(1);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.onTransportFailure(new ApolloNetworkException("Subscription server is not responding"));
            }
        });
    }

    void onInactivityTimeout() {
        this.timer.cancelTask(2);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.disconnect(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTransportFailure(Throwable t) {
        Collection<SubscriptionRecord> subscriptionRecords;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecords = this.subscriptions.values();
            this.disconnect(true);
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.notifyOnNetworkError(t);
        }
    }

    void onOperationServerMessage(OperationServerMessage message) {
        if (message instanceof OperationServerMessage.ConnectionAcknowledge) {
            this.onConnectionAcknowledgeServerMessage();
        } else if (message instanceof OperationServerMessage.Data) {
            this.onOperationDataServerMessage((OperationServerMessage.Data)message);
        } else if (message instanceof OperationServerMessage.Error) {
            this.onErrorServerMessage((OperationServerMessage.Error)message);
        } else if (message instanceof OperationServerMessage.Complete) {
            this.onCompleteServerMessage((OperationServerMessage.Complete)message);
        } else if (message instanceof OperationServerMessage.ConnectionError) {
            this.disconnect(true);
        } else if (message instanceof OperationServerMessage.ConnectionKeepAlive) {
            this.resetConnectionKeepAliveTimerTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean force) {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            if (force || this.subscriptions.isEmpty()) {
                this.transport.disconnect(new OperationClientMessage.Terminate());
                State disconnectionState = this.state == State.STOPPING ? State.STOPPED : State.DISCONNECTED;
                this.setStateAndNotify(disconnectionState);
                this.subscriptions = new LinkedHashMap<String, SubscriptionRecord>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnectionHeartbeatTimeout() {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.transport.disconnect(new OperationClientMessage.Terminate());
            this.setStateAndNotify(State.DISCONNECTED);
            this.setStateAndNotify(State.CONNECTING);
            this.transport.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnectionClosed() {
        Collection<SubscriptionRecord> subscriptionRecords;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecords = this.subscriptions.values();
            this.setStateAndNotify(State.DISCONNECTED);
            this.subscriptions = new LinkedHashMap<String, SubscriptionRecord>();
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.callback.onTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnectionKeepAliveTimerTask() {
        if (this.connectionHeartbeatTimeoutMs <= 0L) {
            return;
        }
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.timer.schedule(3, this.connectionHeartbeatTimeoutTimerTask, this.connectionHeartbeatTimeoutMs);
        }
    }

    private void startInactivityTimer() {
        this.timer.schedule(2, this.inactivityTimeoutTimerTask, INACTIVITY_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOperationDataServerMessage(OperationServerMessage.Data message) {
        SubscriptionRecord subscriptionRecord;
        String subscriptionId = message.id != null ? message.id : "";
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecord = this.subscriptions.get(subscriptionId);
        }
        if (subscriptionRecord != null) {
            Response<?> response;
            ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create((Operation)subscriptionRecord.subscription);
            OperationResponseParser parser = new OperationResponseParser((Operation<?, ?, ?>)subscriptionRecord.subscription, responseFieldMapper, this.scalarTypeAdapters);
            try {
                response = parser.parse(message.payload);
            }
            catch (Exception e) {
                subscriptionRecord = this.removeSubscriptionById(subscriptionId);
                if (subscriptionRecord != null) {
                    subscriptionRecord.notifyOnError(new ApolloSubscriptionException("Failed to parse server message", e));
                }
                return;
            }
            subscriptionRecord.notifyOnResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionAcknowledgeServerMessage() {
        this.timer.cancelTask(1);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.setStateAndNotify(State.ACTIVE);
            for (Map.Entry<String, SubscriptionRecord> entry : this.subscriptions.entrySet()) {
                String subscriptionId = entry.getKey();
                Subscription<?, ?, ?> subscription = entry.getValue().subscription;
                this.transport.send(new OperationClientMessage.Start(subscriptionId, subscription, this.scalarTypeAdapters));
            }
        }
    }

    private void onErrorServerMessage(OperationServerMessage.Error message) {
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord != null) {
            subscriptionRecord.notifyOnError(new ApolloSubscriptionServerException(message.payload));
        }
    }

    private void onCompleteServerMessage(OperationServerMessage.Complete message) {
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord != null) {
            subscriptionRecord.notifyOnCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionRecord removeSubscriptionById(String subscriptionId) {
        SubscriptionRecord subscriptionRecord;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecord = this.subscriptions.remove(subscriptionId);
            if (this.subscriptions.isEmpty()) {
                this.startInactivityTimer();
            }
        }
        return subscriptionRecord;
    }

    private void setStateAndNotify(State newState) {
        State oldState = this.state;
        this.state = newState;
        for (OnStateChangeListener onStateChangeListener : this.onStateChangeListeners) {
            onStateChangeListener.onStateChange(oldState, newState);
        }
    }

    static String idForSubscription(Subscription<?, ?, ?> subscription) {
        return subscription.operationId() + "$" + subscription.variables().valueMap().hashCode();
    }

    static interface OnStateChangeListener {
        public void onStateChange(State var1, State var2);
    }

    static final class AutoReleaseTimer {
        final Map<Integer, TimerTask> tasks = new LinkedHashMap<Integer, TimerTask>();
        Timer timer;

        AutoReleaseTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(final int taskId, final Runnable task, long delay) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        AutoReleaseTimer.this.cancelTask(taskId);
                    }
                }
            };
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask previousTimerTask = this.tasks.put(taskId, timerTask);
                if (previousTimerTask != null) {
                    previousTimerTask.cancel();
                }
                if (this.timer == null) {
                    this.timer = new Timer("Subscription SmartTimer", true);
                }
                this.timer.schedule(timerTask, delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelTask(int taskId) {
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask timerTask = this.tasks.remove(taskId);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.tasks.isEmpty() && this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
    }

    private static final class SubscriptionTransportCallback
    implements SubscriptionTransport.Callback {
        private final RealSubscriptionManager delegate;
        private final Executor dispatcher;

        SubscriptionTransportCallback(RealSubscriptionManager delegate, Executor dispatcher) {
            this.delegate = delegate;
            this.dispatcher = dispatcher;
        }

        @Override
        public void onConnected() {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportConnected();
                }
            });
        }

        @Override
        public void onFailure(final Throwable t) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportFailure(t);
                }
            });
        }

        @Override
        public void onMessage(final OperationServerMessage message) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onOperationServerMessage(message);
                }
            });
        }

        @Override
        public void onClosed() {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onConnectionClosed();
                }
            });
        }
    }

    private static class SubscriptionRecord {
        final Subscription<?, ?, ?> subscription;
        final SubscriptionManager.Callback<?> callback;

        SubscriptionRecord(Subscription<?, ?, ?> subscription, SubscriptionManager.Callback<?> callback) {
            this.subscription = subscription;
            this.callback = callback;
        }

        void notifyOnResponse(Response response) {
            this.callback.onResponse(response);
        }

        void notifyOnError(ApolloSubscriptionException error) {
            this.callback.onError(error);
        }

        void notifyOnNetworkError(Throwable t) {
            this.callback.onNetworkError(t);
        }

        void notifyOnCompleted() {
            this.callback.onCompleted();
        }
    }

    static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        ACTIVE,
        STOPPING,
        STOPPED;

    }
}

