/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NormalizedCache {
    private Optional<NormalizedCache> nextCache = Optional.absent();

    @Nullable
    public abstract Record loadRecord(@NotNull String var1, @NotNull CacheHeaders var2);

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        ArrayList<Record> records = new ArrayList<Record>(keys.size());
        for (String key : keys) {
            Record record = this.loadRecord(key, cacheHeaders);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    @NotNull
    public Set<String> merge(final @NotNull Record record, final @NotNull CacheHeaders cacheHeaders) {
        Utils.checkNotNull((Object)record, (Object)"apolloRecord == null");
        Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return Collections.emptySet();
        }
        Set nextCacheChangedKeys = (Set)this.nextCache().map((Function)new Function<NormalizedCache, Set<String>>(){

            @NotNull
            public Set<String> apply(@NotNull NormalizedCache cache) {
                return cache.merge(record, cacheHeaders);
            }
        }).or(Collections.emptySet());
        Set<String> currentCacheChangedKeys = this.performMerge(record, cacheHeaders);
        HashSet<String> changedKeys = new HashSet<String>();
        changedKeys.addAll(nextCacheChangedKeys);
        changedKeys.addAll(currentCacheChangedKeys);
        return changedKeys;
    }

    @NotNull
    public Set<String> merge(final @NotNull Collection<Record> recordSet, final @NotNull CacheHeaders cacheHeaders) {
        Utils.checkNotNull(recordSet, (Object)"recordSet == null");
        Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return Collections.emptySet();
        }
        Set nextCacheChangedKeys = (Set)this.nextCache().map((Function)new Function<NormalizedCache, Set<String>>(){

            @NotNull
            public Set<String> apply(@NotNull NormalizedCache cache) {
                return cache.merge(recordSet, cacheHeaders);
            }
        }).or(Collections.emptySet());
        HashSet<String> currentCacheChangedKeys = new HashSet<String>();
        for (Record record : recordSet) {
            currentCacheChangedKeys.addAll(this.performMerge(record, cacheHeaders));
        }
        HashSet<String> changedKeys = new HashSet<String>();
        changedKeys.addAll(nextCacheChangedKeys);
        changedKeys.addAll(currentCacheChangedKeys);
        return changedKeys;
    }

    @NotNull
    protected abstract Set<String> performMerge(@NotNull Record var1, @NotNull CacheHeaders var2);

    public abstract void clearAll();

    public boolean remove(@NotNull CacheKey cacheKey) {
        return this.remove(cacheKey, false);
    }

    public abstract boolean remove(@NotNull CacheKey var1, boolean var2);

    public final NormalizedCache chain(@NotNull NormalizedCache cache) {
        Utils.checkNotNull((Object)cache, (Object)"cache == null");
        NormalizedCache leafCache = this;
        while (leafCache.nextCache.isPresent()) {
            leafCache = (NormalizedCache)leafCache.nextCache.get();
        }
        leafCache.nextCache = Optional.of((Object)cache);
        return this;
    }

    public final Optional<NormalizedCache> nextCache() {
        return this.nextCache;
    }

    public Map<Class, Map<String, Record>> dump() {
        Class<?> clazz = this.getClass();
        return Collections.singletonMap(clazz, Collections.emptyMap());
    }

    public static String prettifyDump(Map<Class, Map<String, Record>> dump) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Class, Map<String, Record>> dumpEntry : dump.entrySet()) {
            builder.append(dumpEntry.getKey().getSimpleName()).append(" {");
            for (Map.Entry<String, Record> recordEntry : dumpEntry.getValue().entrySet()) {
                builder.append("\n  \"").append(recordEntry.getKey()).append("\" : {");
                for (Map.Entry<String, Object> fieldEntry : recordEntry.getValue().fields().entrySet()) {
                    builder.append("\n    \"").append(fieldEntry.getKey()).append("\" : ");
                    if (fieldEntry.getValue() instanceof CacheReference) {
                        builder.append("CacheRecordRef(").append(fieldEntry.getValue()).append(")");
                        continue;
                    }
                    if (fieldEntry.getValue() instanceof List) {
                        builder.append("[");
                        for (Object item : (List)fieldEntry.getValue()) {
                            builder.append("\n      ").append(item instanceof CacheReference ? "CacheRecordRef(" : "").append(item).append(item instanceof CacheReference ? ")" : "");
                        }
                        builder.append("\n    ]");
                        continue;
                    }
                    builder.append(fieldEntry.getValue());
                }
                builder.append("\n  }\n");
            }
            builder.append("}\n");
        }
        return builder.toString();
    }
}

