/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SortedInputFieldMapWriter
implements InputFieldWriter {
    final Comparator<String> fieldNameComparator;
    final Map<String, Object> buffer;

    public SortedInputFieldMapWriter(@NotNull Comparator<String> fieldNameComparator) {
        this.fieldNameComparator = (Comparator)Utils.checkNotNull(fieldNameComparator, (Object)"fieldNameComparator == null");
        this.buffer = new TreeMap<String, Object>(fieldNameComparator);
    }

    public Map<String, Object> map() {
        return Collections.unmodifiableMap(this.buffer);
    }

    public void writeString(@NotNull String fieldName, String value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeInt(@NotNull String fieldName, Integer value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeLong(@NotNull String fieldName, Long value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeDouble(@NotNull String fieldName, Double value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeNumber(@NotNull String fieldName, Number value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeBoolean(@NotNull String fieldName, Boolean value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeCustom(@NotNull String fieldName, ScalarType scalarType, Object value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeObject(@NotNull String fieldName, InputFieldMarshaller marshaller) throws IOException {
        if (marshaller == null) {
            this.buffer.put(fieldName, null);
        } else {
            SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
            marshaller.marshal((InputFieldWriter)nestedWriter);
            this.buffer.put(fieldName, nestedWriter.buffer);
        }
    }

    public void writeList(@NotNull String fieldName, InputFieldWriter.ListWriter listWriter) throws IOException {
        if (listWriter == null) {
            this.buffer.put(fieldName, null);
        } else {
            ListItemWriter listItemWriter = new ListItemWriter(this.fieldNameComparator);
            listWriter.write((InputFieldWriter.ListItemWriter)listItemWriter);
            this.buffer.put(fieldName, listItemWriter.list);
        }
    }

    public void writeMap(@NotNull String fieldName, Map<String, Object> value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    private static class ListItemWriter
    implements InputFieldWriter.ListItemWriter {
        final Comparator<String> fieldNameComparator;
        final List list = new ArrayList();

        ListItemWriter(Comparator<String> fieldNameComparator) {
            this.fieldNameComparator = fieldNameComparator;
        }

        public void writeString(String value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeInt(Integer value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeLong(Long value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeDouble(Double value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeNumber(Number value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeBoolean(Boolean value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeCustom(ScalarType scalarType, Object value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeObject(InputFieldMarshaller marshaller) throws IOException {
            if (marshaller != null) {
                SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
                marshaller.marshal((InputFieldWriter)nestedWriter);
                this.list.add(nestedWriter.buffer);
            }
        }

        public void writeList(InputFieldWriter.ListWriter listWriter) throws IOException {
            if (listWriter != null) {
                ListItemWriter nestedListItemWriter = new ListItemWriter(this.fieldNameComparator);
                listWriter.write((InputFieldWriter.ListItemWriter)nestedListItemWriter);
                this.list.add(nestedListItemWriter.list);
            }
        }

        public void writeMap(Map<String, Object> value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }
    }
}

