/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.internal.json.Utils;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.CustomTypeValue;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InputFieldJsonWriter
implements InputFieldWriter {
    private final JsonWriter jsonWriter;
    private final ScalarTypeAdapters scalarTypeAdapters;

    public InputFieldJsonWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
        this.jsonWriter = jsonWriter;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    public void writeString(@NotNull String fieldName, String value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeInt(@NotNull String fieldName, Integer value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeLong(@NotNull String fieldName, Long value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeDouble(@NotNull String fieldName, Double value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeNumber(@NotNull String fieldName, Number value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeBoolean(@NotNull String fieldName, Boolean value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCustom(@NotNull String fieldName, ScalarType scalarType, Object value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
            CustomTypeValue customTypeValue = customTypeAdapter.encode(value);
            if (customTypeValue instanceof CustomTypeValue.GraphQLString) {
                this.writeString(fieldName, (String)((CustomTypeValue.GraphQLString)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLBoolean) {
                this.writeBoolean(fieldName, (Boolean)((CustomTypeValue.GraphQLBoolean)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLNumber) {
                this.writeNumber(fieldName, (Number)((CustomTypeValue.GraphQLNumber)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLJsonString) {
                this.writeString(fieldName, (String)((CustomTypeValue.GraphQLJsonString)customTypeValue).value);
                return;
            } else {
                if (!(customTypeValue instanceof CustomTypeValue.GraphQLJson)) throw new IllegalArgumentException("Unsupported custom value type: " + customTypeValue);
                this.writeMap(fieldName, (Map)((CustomTypeValue.GraphQLJson)customTypeValue).value);
            }
            return;
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeObject(@NotNull String fieldName, InputFieldMarshaller marshaller) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (marshaller != null) {
            this.jsonWriter.name(fieldName).beginObject();
            marshaller.marshal((InputFieldWriter)this);
            this.jsonWriter.endObject();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeList(@NotNull String fieldName, InputFieldWriter.ListWriter listWriter) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (listWriter != null) {
            this.jsonWriter.name(fieldName).beginArray();
            listWriter.write((InputFieldWriter.ListItemWriter)new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
            this.jsonWriter.endArray();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeMap(@NotNull String fieldName, Map<String, Object> value) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value == null) {
            this.jsonWriter.name(fieldName).nullValue();
        } else {
            this.jsonWriter.name(fieldName);
            Utils.writeToJson(value, this.jsonWriter);
        }
    }

    private static final class JsonListItemWriter
    implements InputFieldWriter.ListItemWriter {
        private final JsonWriter jsonWriter;
        private final ScalarTypeAdapters scalarTypeAdapters;

        JsonListItemWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
            this.jsonWriter = jsonWriter;
            this.scalarTypeAdapters = scalarTypeAdapters;
        }

        public void writeString(String value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeInt(Integer value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeLong(Long value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeDouble(Double value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeNumber(Number value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeBoolean(Boolean value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        public void writeMap(Map<String, Object> value) throws IOException {
            Utils.writeToJson(value, this.jsonWriter);
        }

        public void writeCustom(ScalarType scalarType, Object value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
                CustomTypeValue customTypeValue = customTypeAdapter.encode(value);
                if (customTypeValue instanceof CustomTypeValue.GraphQLString) {
                    this.writeString((String)((CustomTypeValue.GraphQLString)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLBoolean) {
                    this.writeBoolean((Boolean)((CustomTypeValue.GraphQLBoolean)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLNumber) {
                    this.writeNumber((Number)((CustomTypeValue.GraphQLNumber)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLJsonString) {
                    this.writeString((String)((CustomTypeValue.GraphQLJsonString)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLJson) {
                    this.writeMap((Map)((CustomTypeValue.GraphQLJson)customTypeValue).value);
                } else {
                    throw new IllegalArgumentException("Unsupported custom value type: " + customTypeValue);
                }
            }
        }

        public void writeObject(InputFieldMarshaller marshaller) throws IOException {
            if (marshaller == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.beginObject();
                marshaller.marshal((InputFieldWriter)new InputFieldJsonWriter(this.jsonWriter, this.scalarTypeAdapters));
                this.jsonWriter.endObject();
            }
        }

        public void writeList(InputFieldWriter.ListWriter listWriter) throws IOException {
            if (listWriter == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.beginArray();
                listWriter.write((InputFieldWriter.ListItemWriter)new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
                this.jsonWriter.endArray();
            }
        }
    }
}

