/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class CacheOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheOnlyInterceptor();
    }

    private static final class CacheOnlyInterceptor
    implements ApolloInterceptor {
        private CacheOnlyInterceptor() {
        }

        @Override
        public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull Executor dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    callBack.onResponse(CacheOnlyInterceptor.this.cacheMissResponse(request.operation));
                    callBack.onCompleted();
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
        }

        private ApolloInterceptor.InterceptorResponse cacheMissResponse(Operation operation) {
            return new ApolloInterceptor.InterceptorResponse(null, Response.builder((Operation)operation).fromCache(true).build(), null);
        }
    }
}

