/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.cache.http.HttpCache;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.interceptor.HttpResponseBodyParser;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import okhttp3.Response;

public final class ApolloParseInterceptor
implements ApolloInterceptor {
    private final HttpCache httpCache;
    private final ResponseNormalizer<Map<String, Object>> normalizer;
    private final ResponseFieldMapper responseFieldMapper;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final ApolloLogger logger;
    private volatile boolean disposed;

    public ApolloParseInterceptor(HttpCache httpCache, ResponseNormalizer<Map<String, Object>> normalizer, ResponseFieldMapper responseFieldMapper, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ApolloLogger logger) {
        this.httpCache = httpCache;
        this.normalizer = normalizer;
        this.responseFieldMapper = responseFieldMapper;
        this.customTypeAdapters = customTypeAdapters;
        this.logger = logger;
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain) throws ApolloException {
        if (this.disposed) {
            throw new ApolloCanceledException("Canceled");
        }
        ApolloInterceptor.InterceptorResponse response = chain.proceed(request);
        return this.parse(request.operation, (Response)response.httpResponse.get());
    }

    @Override
    public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                try {
                    if (ApolloParseInterceptor.this.disposed) {
                        return;
                    }
                    ApolloInterceptor.InterceptorResponse result = ApolloParseInterceptor.this.parse(request.operation, (Response)response.httpResponse.get());
                    callBack.onResponse(result);
                    callBack.onCompleted();
                }
                catch (ApolloException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (ApolloParseInterceptor.this.disposed) {
                    return;
                }
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    private ApolloInterceptor.InterceptorResponse parse(Operation operation, Response httpResponse) throws ApolloHttpException, ApolloParseException {
        String cacheKey = httpResponse.request().header("X-APOLLO-CACHE-KEY");
        if (httpResponse.isSuccessful()) {
            try {
                HttpResponseBodyParser parser = new HttpResponseBodyParser(operation, this.responseFieldMapper, this.customTypeAdapters);
                com.apollographql.apollo.api.Response parsedResponse = parser.parse(httpResponse, this.normalizer);
                if (parsedResponse.hasErrors() && this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                return new ApolloInterceptor.InterceptorResponse(httpResponse, parsedResponse, this.normalizer.records());
            }
            catch (Exception rethrown) {
                this.logger.e(rethrown, "Failed to parse network response for operation: %s", operation);
                ApolloParseInterceptor.closeQuietly((Closeable)httpResponse);
                if (this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                throw new ApolloParseException("Failed to parse http response", rethrown);
            }
        }
        this.logger.e("Failed to parse network response: %s", httpResponse);
        throw new ApolloHttpException(httpResponse);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

