/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class ApolloServerInterceptor
implements ApolloInterceptor {
    private static final String ACCEPT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "application/json";
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final Optional<HttpCachePolicy.Policy> cachePolicy;
    final boolean prefetch;
    final ApolloLogger logger;
    final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final boolean sendOperationIdentifiers;
    volatile Call httpCall;
    volatile boolean disposed;

    public ApolloServerInterceptor(@Nonnull HttpUrl serverUrl, @Nonnull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @Nonnull Map<ScalarType, CustomTypeAdapter> customTypeAdapters, @Nonnull ApolloLogger logger, boolean sendOperationIdentifiers) {
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        this.cachePolicy = Optional.fromNullable((Object)cachePolicy);
        this.prefetch = prefetch;
        this.customTypeAdapters = (Map)Utils.checkNotNull(customTypeAdapters, (Object)"customTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.sendOperationIdentifiers = sendOperationIdentifiers;
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
        if (this.disposed) {
            throw new ApolloCanceledException("Canceled");
        }
        try {
            this.httpCall = this.httpCall(operation);
        }
        catch (IOException e) {
            this.logger.e(e, "Failed to prepare http call", new Object[0]);
            throw new ApolloNetworkException("Failed to prepare http call", e);
        }
        try {
            Response response = this.httpCall.execute();
            return new ApolloInterceptor.InterceptorResponse(response);
        }
        catch (IOException e) {
            this.logger.e(e, "Failed to execute http call", new Object[0]);
            throw new ApolloNetworkException("Failed to execute http call", e);
        }
    }

    @Override
    public void interceptAsync(final @Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, @Nonnull FetchOptions fetchOptions, final @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloServerInterceptor.this.httpCall = ApolloServerInterceptor.this.httpCall(operation);
                }
                catch (IOException e) {
                    ApolloServerInterceptor.this.logger.e(e, "Failed to prepare http call for operation %s", operation.name().name());
                    callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
                    return;
                }
                ApolloServerInterceptor.this.httpCall.enqueue(new Callback(){

                    public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        ApolloServerInterceptor.this.logger.e(e, "Failed to execute http call for operation %s", operation.name().name());
                        callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                    }

                    public void onResponse(@Nonnull Call call, @Nonnull Response response) throws IOException {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                        callBack.onCompleted();
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        Call httpCall = this.httpCall;
        if (httpCall != null) {
            httpCall.cancel();
        }
        this.httpCall = null;
    }

    private Call httpCall(Operation operation) throws IOException {
        RequestBody requestBody = this.httpRequestBody(operation);
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody).header("Accept", "application/json").header("Content-Type", "application/json");
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            String cacheKey = ApolloServerInterceptor.cacheKey(requestBody);
            requestBuilder = requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch));
        }
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    private RequestBody httpRequestBody(Operation operation) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.beginObject();
        if (this.sendOperationIdentifiers) {
            jsonWriter.name("id").value(operation.operationId());
        } else {
            jsonWriter.name("query").value(operation.queryDocument().replaceAll("\\n", ""));
        }
        jsonWriter.name("variables").beginObject();
        operation.variables().marshaller().marshal((InputFieldWriter)new InputFieldJsonWriter(jsonWriter, this.customTypeAdapters));
        jsonWriter.endObject();
        jsonWriter.endObject();
        jsonWriter.close();
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }

    public static String cacheKey(RequestBody requestBody) {
        Buffer hashBuffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)hashBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hashBuffer.readByteString().md5().hex();
    }
}

